/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.dynamic;

import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.dynamic.Concatenator;
import org.apache.hadoop.util.dynamic.DynConstructors;
import org.apache.hadoop.util.dynamic.DynMethods;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDynMethods
extends AbstractHadoopTestBase {
    @Test
    public void testNoImplCall() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat");
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> ((DynMethods.Builder)builder).build());
    }

    @Test
    public void testMissingClass() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> builder.build());
    }

    @Test
    public void testMissingMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl(Concatenator.class, "cat2strings", new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> ((DynMethods.Builder)builder).buildChecked());
        LambdaTestUtils.intercept(RuntimeException.class, () -> builder.build());
    }

    @Test
    public void testFirstImplReturned() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat2 = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class, String.class}).buildChecked();
        Assertions.assertEquals((Object)"a-b", (Object)cat2.invoke((Object)obj, new Object[]{"a", "b"}), (String)"Should call the 2-arg version successfully");
        Assertions.assertEquals((Object)"a-b", (Object)cat2.invoke((Object)obj, new Object[]{"a", "b", "c"}), (String)"Should ignore extra arguments");
        DynMethods.UnboundMethod cat3 = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).build();
        Assertions.assertEquals((Object)"a-b-c", (Object)cat3.invoke((Object)obj, new Object[]{"a", "b", "c"}), (String)"Should call the 3-arg version successfully");
        Assertions.assertEquals((Object)"a-b-null", (Object)cat3.invoke((Object)obj, new Object[]{"a", "b"}), (String)"Should call the 3-arg version null padding");
    }

    @Test
    public void testVarArgs() throws Exception {
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String[].class}).buildChecked();
        Assertions.assertEquals((Object)"abcde", (Object)cat.invokeChecked((Object)new Concatenator(), new Object[]{new String[]{"a", "b", "c", "d", "e"}}), (String)"Should use the varargs version");
        Assertions.assertEquals((Object)"abcde", (Object)cat.bind((Object)new Concatenator()).invokeChecked(new Object[]{new String[]{"a", "b", "c", "d", "e"}}), (String)"Should use the varargs version");
    }

    @Test
    public void testIncorrectArguments() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked();
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> cat.invoke((Object)obj, new Object[]{3, 4}));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> cat.invokeChecked((Object)obj, new Object[]{3, 4}));
    }

    @Test
    public void testExceptionThrown() throws Exception {
        Concatenator.SomeCheckedException exc = new Concatenator.SomeCheckedException();
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).impl(Concatenator.class, new Class[]{Exception.class}).buildChecked();
        LambdaTestUtils.intercept(Concatenator.SomeCheckedException.class, () -> cat.invokeChecked((Object)obj, new Object[]{exc}));
        LambdaTestUtils.intercept(RuntimeException.class, () -> cat.invoke((Object)obj, new Object[]{exc}));
    }

    @Test
    public void testNameChange() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("cat").impl(Concatenator.class, "concat", new Class[]{String.class, String.class}).buildChecked();
        Assertions.assertEquals((Object)"a-b", (Object)cat.invoke((Object)obj, new Object[]{"a", "b"}), (String)"Should find 2-arg concat method");
    }

    @Test
    public void testStringClassname() throws Exception {
        Concatenator obj = new Concatenator("-");
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class.getName(), new Class[]{String.class, String.class}).buildChecked();
        Assertions.assertEquals((Object)"a-b", (Object)cat.invoke((Object)obj, new Object[]{"a", "b"}), (String)"Should find 2-arg concat method");
    }

    @Test
    public void testHiddenMethod() throws Exception {
        Concatenator obj = new Concatenator("-");
        LambdaTestUtils.intercept(NoSuchMethodException.class, () -> new DynMethods.Builder("setSeparator").impl(Concatenator.class, new Class[]{String.class}).buildChecked());
        DynMethods.UnboundMethod changeSep = new DynMethods.Builder("setSeparator").hiddenImpl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Assertions.assertNotNull((Object)changeSep, (String)"Should find hidden method with hiddenImpl");
        changeSep.invokeChecked((Object)obj, new Object[]{"/"});
        Assertions.assertEquals((Object)"a/b", (Object)obj.concat("a", "b"), (String)"Should use separator / instead of -");
    }

    @Test
    public void testBoundMethod() throws Exception {
        DynMethods.UnboundMethod cat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked();
        DynMethods.BoundMethod dashCat = cat.bind((Object)new Concatenator("-"));
        DynMethods.BoundMethod underCat = cat.bind((Object)new Concatenator("_"));
        Assertions.assertEquals((Object)"a-b", (Object)dashCat.invoke(new Object[]{"a", "b"}), (String)"Should use '-' object without passing");
        Assertions.assertEquals((Object)"a_b", (Object)underCat.invoke(new Object[]{"a", "b"}), (String)"Should use '_' object without passing");
        DynMethods.BoundMethod slashCat = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class}).buildChecked((Object)new Concatenator("/"));
        Assertions.assertEquals((Object)"a/b", (Object)slashCat.invoke(new Object[]{"a", "b"}), (String)"Should use bound object from builder without passing");
    }

    @Test
    public void testBindStaticMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("cat").impl(Concatenator.class, new Class[]{String[].class});
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.buildChecked((Object)new Concatenator()));
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.build((Object)new Concatenator()));
        DynMethods.UnboundMethod staticCat = builder.buildChecked();
        Assertions.assertTrue((boolean)staticCat.isStatic(), (String)"Should be static");
        LambdaTestUtils.intercept(IllegalStateException.class, () -> staticCat.bind((Object)new Concatenator()));
    }

    @Test
    public void testStaticMethod() throws Exception {
        DynMethods.StaticMethod staticCat = new DynMethods.Builder("cat").impl(Concatenator.class, new Class[]{String[].class}).buildStaticChecked();
        Assertions.assertEquals((Object)"abcde", (Object)staticCat.invokeChecked(new Object[]{new String[]{"a", "b", "c", "d", "e"}}), (String)"Should call varargs static method cat(String...)");
    }

    @Test
    public void testNonStaticMethod() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("concat").impl(Concatenator.class, new Class[]{String.class, String.class});
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ((DynMethods.Builder)builder).buildStatic());
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ((DynMethods.Builder)builder).buildStaticChecked());
        DynMethods.UnboundMethod cat2 = builder.buildChecked();
        Assertions.assertFalse((boolean)cat2.isStatic(), (String)"concat(String,String) should not be static");
        LambdaTestUtils.intercept(IllegalStateException.class, () -> ((DynMethods.UnboundMethod)cat2).asStatic());
    }

    @Test
    public void testConstructorImpl() throws Exception {
        DynMethods.Builder builder = new DynMethods.Builder("newConcatenator").ctorImpl(Concatenator.class, new Class[]{String.class}).impl(Concatenator.class, new Class[]{String.class});
        DynMethods.UnboundMethod newConcatenator = builder.buildChecked();
        Assertions.assertTrue((boolean)(newConcatenator instanceof DynConstructors.Ctor), (String)"Should find constructor implementation");
        Assertions.assertTrue((boolean)newConcatenator.isStatic(), (String)"Constructor should be a static method");
        Assertions.assertFalse((boolean)newConcatenator.isNoop(), (String)"Constructor should not be NOOP");
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.buildChecked((Object)new Concatenator()));
        LambdaTestUtils.intercept(IllegalStateException.class, () -> builder.build((Object)new Concatenator()));
        Concatenator concatenator = (Concatenator)newConcatenator.asStatic().invoke(new Object[]{"*"});
        Assertions.assertEquals((Object)"a*b", (Object)concatenator.concat("a", "b"), (String)"Should function as a concatenator");
        concatenator = (Concatenator)newConcatenator.asStatic().invokeChecked(new Object[]{"@"});
        Assertions.assertEquals((Object)"a@b", (Object)concatenator.concat("a", "b"), (String)"Should function as a concatenator");
    }

    @Test
    public void testConstructorImplAfterFactoryMethod() throws Exception {
        DynMethods.UnboundMethod newConcatenator = new DynMethods.Builder("newConcatenator").impl(Concatenator.class, new Class[]{String.class}).ctorImpl(Concatenator.class, new Class[]{String.class}).buildChecked();
        Assertions.assertFalse((boolean)(newConcatenator instanceof DynConstructors.Ctor), (String)"Should find factory method before constructor method");
    }

    @Test
    public void testNoop() throws Exception {
        DynMethods.UnboundMethod noop = new DynMethods.Builder("concat").impl("not.a.RealClass", new Class[]{String.class, String.class}).orNoop().buildChecked();
        Assertions.assertTrue((boolean)noop.isNoop(), (String)"No implementation found, should return NOOP");
        Assertions.assertNull((Object)noop.invoke((Object)new Concatenator(), new Object[]{"a"}), (String)"NOOP should always return null");
        Assertions.assertNull((Object)noop.invoke(null, new Object[]{"a"}), (String)"NOOP can be called with null");
        Assertions.assertNull((Object)noop.bind((Object)new Concatenator()).invoke(new Object[]{"a"}), (String)"NOOP can be bound");
        Assertions.assertNull((Object)noop.bind(null).invoke(new Object[]{"a"}), (String)"NOOP can be bound to null");
        Assertions.assertNull((Object)noop.asStatic().invoke(new Object[]{"a"}), (String)"NOOP can be static");
    }
}

