/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.bloom;

import java.util.AbstractCollection;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.bloom.BloomFilter;
import org.apache.hadoop.util.bloom.BloomFilterCommonTester;
import org.apache.hadoop.util.bloom.CountingBloomFilter;
import org.apache.hadoop.util.bloom.DynamicBloomFilter;
import org.apache.hadoop.util.bloom.Filter;
import org.apache.hadoop.util.bloom.Key;
import org.apache.hadoop.util.bloom.RetouchedBloomFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBloomFilters {
    int numInsertions = 1000;
    int bitSize = BloomFilterCommonTester.optimalNumOfBits(this.numInsertions, 0.03);
    int hashFunctionNumber = 5;
    private static final ImmutableMap<Integer, ? extends AbstractCollection<Key>> FALSE_POSITIVE_UNDER_1000 = ImmutableMap.of((Object)0, (Object)new AbstractCollection<Key>(){
        final ImmutableList<Key> falsePositive = ImmutableList.of((Object)new Key("99".getBytes()), (Object)new Key("963".getBytes()));

        @Override
        public Iterator<Key> iterator() {
            return this.falsePositive.iterator();
        }

        @Override
        public int size() {
            return this.falsePositive.size();
        }
    }, (Object)1, (Object)new AbstractCollection<Key>(){
        final ImmutableList<Key> falsePositive = ImmutableList.of((Object)new Key("769".getBytes()), (Object)new Key("772".getBytes()), (Object)new Key("810".getBytes()), (Object)new Key("874".getBytes()));

        @Override
        public Iterator<Key> iterator() {
            return this.falsePositive.iterator();
        }

        @Override
        public int size() {
            return this.falsePositive.size();
        }
    });

    @Test
    public void testDynamicBloomFilter() {
        int hashId = 0;
        DynamicBloomFilter filter = new DynamicBloomFilter(this.bitSize, this.hashFunctionNumber, 0, 3);
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(filter).withTestCases((ImmutableSet<BloomFilterCommonTester.BloomFilterTestStrategy>)ImmutableSet.of((Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY))).test();
        Assertions.assertNotNull((Object)"testDynamicBloomFilter error ", (String)filter.toString());
    }

    @Test
    public void testCountingBloomFilter() {
        int hashId = 0;
        CountingBloomFilter filter = new CountingBloomFilter(this.bitSize, this.hashFunctionNumber, hashId);
        Key key = new Key(new byte[]{48, 48});
        filter.add(key);
        Assertions.assertTrue((boolean)filter.membershipTest(key), (String)"CountingBloomFilter.membership error ");
        Assertions.assertTrue((filter.approximateCount(key) == 1 ? 1 : 0) != 0, (String)"CountingBloomFilter.approximateCount error");
        filter.add(key);
        Assertions.assertTrue((filter.approximateCount(key) == 2 ? 1 : 0) != 0, (String)"CountingBloomFilter.approximateCount error");
        filter.delete(key);
        Assertions.assertTrue((boolean)filter.membershipTest(key), (String)"CountingBloomFilter.membership error ");
        filter.delete(key);
        Assertions.assertFalse((boolean)filter.membershipTest(key), (String)"CountingBloomFilter.membership error ");
        Assertions.assertTrue((filter.approximateCount(key) == 0 ? 1 : 0) != 0, (String)"CountingBloomFilter.approximateCount error");
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(filter).withTestCases((ImmutableSet<BloomFilterCommonTester.BloomFilterTestStrategy>)ImmutableSet.of((Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_OR_STRATEGY), (Object[])new BloomFilterCommonTester.BloomFilterTestStrategy[]{BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_XOR_STRATEGY})).test();
    }

    @Test
    public void testRetouchedBloomFilterSpecific() {
        int numInsertions = 1000;
        int hashFunctionNumber = 5;
        ImmutableSet hashes = ImmutableSet.of((Object)1, (Object)0);
        for (Integer hashId : hashes) {
            RetouchedBloomFilter filter = new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue());
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.ODD, (short)2);
            filter.and((Filter)new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue()));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.EVEN, (short)2);
            filter.and((Filter)new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue()));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.ODD, (short)1);
            filter.and((Filter)new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue()));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.EVEN, (short)1);
            filter.and((Filter)new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue()));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.ODD, (short)3);
            filter.and((Filter)new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue()));
            this.checkOnAbsentFalsePositive(hashId, numInsertions, filter, Digits.EVEN, (short)3);
            filter.and((Filter)new RetouchedBloomFilter(this.bitSize, hashFunctionNumber, hashId.intValue()));
        }
    }

    private void checkOnAbsentFalsePositive(int hashId, int numInsertions, RetouchedBloomFilter filter, Digits digits, short removeSchema) {
        AbstractCollection falsePositives = (AbstractCollection)FALSE_POSITIVE_UNDER_1000.get((Object)hashId);
        if (falsePositives == null) {
            Assertions.fail((String)String.format("false positives for hash %d not founded", hashId));
        }
        filter.addFalsePositive((Collection)falsePositives);
        for (int i = digits.getStart(); i < numInsertions; i += 2) {
            filter.add(new Key(Integer.toString(i).getBytes()));
        }
        for (Key key : falsePositives) {
            filter.selectiveClearing(key, removeSchema);
        }
        for (int i = 1 - digits.getStart(); i < numInsertions; i += 2) {
            Assertions.assertFalse((boolean)filter.membershipTest(new Key(Integer.toString(i).getBytes())), (String)(" testRetouchedBloomFilterAddFalsePositive error " + i));
        }
    }

    @Test
    public void testFiltersWithJenkinsHash() {
        int hashId = 0;
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(new BloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withFilterInstance((BloomFilter)new RetouchedBloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withTestCases((ImmutableSet<BloomFilterCommonTester.BloomFilterTestStrategy>)ImmutableSet.of((Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_OR_STRATEGY), (Object[])new BloomFilterCommonTester.BloomFilterTestStrategy[]{BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_AND_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_XOR_STRATEGY})).test();
    }

    @Test
    public void testFiltersWithMurmurHash() {
        int hashId = 1;
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(new BloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withFilterInstance((BloomFilter)new RetouchedBloomFilter(this.bitSize, this.hashFunctionNumber, hashId)).withTestCases((ImmutableSet<BloomFilterCommonTester.BloomFilterTestStrategy>)ImmutableSet.of((Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.KEY_TEST_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ADD_KEYS_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.EXCEPTIONS_CHECK_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.ODD_EVEN_ABSENT_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY), (Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_OR_STRATEGY), (Object[])new BloomFilterCommonTester.BloomFilterTestStrategy[]{BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_AND_STRATEGY, BloomFilterCommonTester.BloomFilterTestStrategy.FILTER_XOR_STRATEGY})).test();
    }

    @Test
    public void testFiltersWithLargeVectorSize() {
        int hashId = 1;
        BloomFilter filter = new BloomFilter(Integer.MAX_VALUE, this.hashFunctionNumber, hashId);
        BloomFilterCommonTester.of(hashId, this.numInsertions).withFilterInstance(filter).withTestCases((ImmutableSet<BloomFilterCommonTester.BloomFilterTestStrategy>)ImmutableSet.of((Object)((Object)BloomFilterCommonTester.BloomFilterTestStrategy.WRITE_READ_STRATEGY))).test();
    }

    @Test
    public void testNot() {
        BloomFilter bf = new BloomFilter(8, 1, 0);
        bf.bits = BitSet.valueOf(new byte[]{-107});
        BitSet origBitSet = (BitSet)bf.bits.clone();
        bf.not();
        Assertions.assertFalse((boolean)bf.bits.intersects(origBitSet), (String)"BloomFilter#not should have inverted all bits");
    }

    private static enum Digits {
        ODD(1),
        EVEN(0);

        int start;

        private Digits(int start) {
            this.start = start;
        }

        int getStart() {
            return this.start;
        }
    }
}

