/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWinUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestWinUtils.class);
    private static File TEST_DIR = GenericTestUtils.getTestDir(TestWinUtils.class.getSimpleName());
    String winutils;

    @BeforeEach
    public void setUp() throws IOException {
        PlatformAssumptions.assumeWindows();
        TEST_DIR.mkdirs();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)TEST_DIR.isDirectory(), (String)("Failed to create Test directory " + TEST_DIR));
        this.winutils = Shell.getWinUtilsPath();
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
    }

    private void requireWinutils() throws IOException {
        Shell.getWinUtilsPath();
    }

    private void writeFile(File file, String content) throws IOException {
        byte[] data = content.getBytes();
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(data);
            os.close();
        }
    }

    private String readFile(File file) throws IOException {
        byte[] b;
        try (FileInputStream fos = new FileInputStream(file);){
            b = new byte[100];
            int count = fos.read(b);
            org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)count);
        }
        return new String(b);
    }

    @Test
    @Timeout(value=30L)
    public void testLs() throws IOException {
        this.requireWinutils();
        String content = "6bytes";
        int contentSize = "6bytes".length();
        File testFile = new File(TEST_DIR, "file1");
        this.writeFile(testFile, "6bytes");
        String testPath = testFile.getCanonicalPath();
        String output = Shell.execCommand((String[])new String[]{this.winutils, "ls", testPath});
        String[] outputArgs = output.split("[ \r\n]");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-rwx------", (Object)outputArgs[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)outputArgs[outputArgs.length - 1], (Object)testPath);
        output = Shell.execCommand((String[])new String[]{this.winutils, "ls", "-F", testPath});
        outputArgs = output.split("[|\r\n]");
        org.junit.jupiter.api.Assertions.assertEquals((int)9, (int)outputArgs.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-rwx------", (Object)outputArgs[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)contentSize, (long)Long.parseLong(outputArgs[4]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)outputArgs[8], (Object)testPath);
        testFile.delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testFile.exists());
    }

    @Test
    @Timeout(value=30L)
    public void testGroups() throws IOException {
        this.requireWinutils();
        String currentUser = System.getProperty("user.name");
        String outputNoArgs = Shell.execCommand((String[])new String[]{this.winutils, "groups"}).trim();
        String output = Shell.execCommand((String[])new String[]{this.winutils, "groups", currentUser}).trim();
        org.junit.jupiter.api.Assertions.assertEquals((Object)output, (Object)outputNoArgs);
        String outputFormat = Shell.execCommand((String[])new String[]{this.winutils, "groups", "-F", currentUser}).trim();
        outputFormat = outputFormat.replace("|", " ");
        org.junit.jupiter.api.Assertions.assertEquals((Object)output, (Object)outputFormat);
    }

    private void chmod(String mask, File file) throws IOException {
        Shell.execCommand((String[])new String[]{this.winutils, "chmod", mask, file.getCanonicalPath()});
    }

    private void chmodR(String mask, File file) throws IOException {
        Shell.execCommand((String[])new String[]{this.winutils, "chmod", "-R", mask, file.getCanonicalPath()});
    }

    private String ls(File file) throws IOException {
        return Shell.execCommand((String[])new String[]{this.winutils, "ls", file.getCanonicalPath()});
    }

    private String lsF(File file) throws IOException {
        return Shell.execCommand((String[])new String[]{this.winutils, "ls", "-F", file.getCanonicalPath()});
    }

    private void assertPermissions(File file, String expected) throws IOException {
        String output = this.ls(file).split("[ \r\n]")[0];
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)output);
    }

    private void testChmodInternal(String mode, String expectedPerm) throws IOException {
        this.requireWinutils();
        File a = new File(TEST_DIR, "file1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)a.createNewFile());
        this.chmod("700", a);
        this.chmod(mode, a);
        this.assertPermissions(a, expectedPerm);
        a.delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)a.exists());
    }

    private void testNewFileChmodInternal(String expectedPerm) throws IOException {
        this.requireWinutils();
        File dir = new File(TEST_DIR, "dir1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dir.mkdir());
        this.chmod("755", dir);
        File child = new File(dir, "file1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)child.createNewFile());
        this.assertPermissions(child, expectedPerm);
        child.delete();
        dir.delete();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)dir.exists());
    }

    private void testChmodInternalR(String mode, String expectedPerm, String expectedPermx) throws IOException {
        this.requireWinutils();
        File a = new File(TEST_DIR, "a");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)a.mkdir());
        this.chmod("700", a);
        File aa = new File(a, "a");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)aa.createNewFile());
        this.chmod("600", aa);
        File ab = new File(a, "b");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ab.mkdir());
        this.chmod("700", ab);
        File aba = new File(ab, "a");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)aba.mkdir());
        this.chmod("700", aba);
        File abb = new File(ab, "b");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)abb.createNewFile());
        this.chmod("600", abb);
        File abx = new File(ab, "x");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)abx.createNewFile());
        this.chmod("u+x", abx);
        this.chmodR(mode, a);
        this.assertPermissions(a, "d" + expectedPermx);
        this.assertPermissions(aa, "-" + expectedPerm);
        this.assertPermissions(ab, "d" + expectedPermx);
        this.assertPermissions(aba, "d" + expectedPermx);
        this.assertPermissions(abb, "-" + expectedPerm);
        this.assertPermissions(abx, "-" + expectedPermx);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileUtil.fullyDelete((File)a));
    }

    @Test
    @Timeout(value=30L)
    public void testBasicChmod() throws IOException {
        this.requireWinutils();
        File a = new File(TEST_DIR, "a");
        a.createNewFile();
        this.chmod("377", a);
        try {
            this.readFile(a);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)true, (String)"readFile should have failed!");
        }
        catch (IOException ex) {
            LOG.info("Expected: Failed read from a file with permissions 377");
        }
        this.chmod("700", a);
        this.chmod("577", a);
        try {
            this.writeFile(a, "test");
            org.junit.jupiter.api.Assertions.fail((String)"writeFile should have failed!");
        }
        catch (IOException ex) {
            LOG.info("Expected: Failed write to a file with permissions 577");
        }
        this.chmod("700", a);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)a.delete());
        File winutilsFile = Shell.getWinUtilsFile();
        File aExe = new File(TEST_DIR, "a.exe");
        FileUtils.copyFile((File)winutilsFile, (File)aExe);
        this.chmod("677", aExe);
        try {
            Shell.execCommand((String[])new String[]{aExe.getCanonicalPath(), "ls"});
            org.junit.jupiter.api.Assertions.fail((String)("executing " + aExe + " should have failed!"));
        }
        catch (IOException ex) {
            LOG.info("Expected: Failed to execute a file with permissions 677");
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)aExe.delete());
    }

    @Test
    @Timeout(value=30L)
    public void testBasicChmodOnDir() throws IOException {
        this.requireWinutils();
        File a = new File(TEST_DIR, "a");
        File b = new File(a, "b");
        a.mkdirs();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)b.createNewFile());
        this.chmod("300", a);
        String[] files = a.list();
        org.junit.jupiter.api.Assertions.assertNull((Object)files, (String)"Listing a directory without read permission should fail");
        this.chmod("700", a);
        files = a.list();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"b", (Object)files[0]);
        this.chmod("500", a);
        File c = new File(a, "c");
        try {
            c.createNewFile();
            org.junit.jupiter.api.Assertions.fail((String)"writeFile should have failed!");
        }
        catch (IOException ex) {
            LOG.info("Expected: Failed to create a file when directory permissions are 577");
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)b.delete(), (String)"Special behavior: deleting a file will succeed on Windows even if a user does not have write permissions on the parent dir");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)b.renameTo(new File(a, "d")), (String)"Renaming a file should fail on the dir where a user does not have write permissions");
        this.chmod("700", a);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)c.createNewFile());
        File d = new File(a, "d");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)c.renameTo(d));
        this.chmod("600", a);
        files = a.list();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"d", (Object)files[0]);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)d.delete());
        File e = new File(a, "e");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)e.createNewFile());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)e.renameTo(new File(a, "f")));
        this.chmod("700", a);
    }

    @Test
    @Timeout(value=30L)
    public void testChmod() throws IOException {
        this.requireWinutils();
        this.testChmodInternal("7", "-------rwx");
        this.testChmodInternal("70", "----rwx---");
        this.testChmodInternal("u-x,g+r,o=g", "-rw-r--r--");
        this.testChmodInternal("u-x,g+rw", "-rw-rw----");
        this.testChmodInternal("u-x,g+rwx-x,o=u", "-rw-rw-rw-");
        this.testChmodInternal("+", "-rwx------");
        this.testChmodInternalR("755", "rwxr-xr-x", "rwxr-xr-x");
        this.testChmodInternalR("u-x,g+r,o=g", "rw-r--r--", "rw-r--r--");
        this.testChmodInternalR("u-x,g+rw", "rw-rw----", "rw-rw----");
        this.testChmodInternalR("u-x,g+rwx-x,o=u", "rw-rw-rw-", "rw-rw-rw-");
        this.testChmodInternalR("a+rX", "rw-r--r--", "rwxr-xr-x");
        this.testNewFileChmodInternal("-rwxr-xr-x");
    }

    private void chown(String userGroup, File file) throws IOException {
        Shell.execCommand((String[])new String[]{this.winutils, "chown", userGroup, file.getCanonicalPath()});
    }

    private void assertOwners(File file, String expectedUser, String expectedGroup) throws IOException {
        String[] args = this.lsF(file).trim().split("[\\|]");
        org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.toLowerCase((String)expectedUser), (Object)StringUtils.toLowerCase((String)args[2]));
        org.junit.jupiter.api.Assertions.assertEquals((Object)StringUtils.toLowerCase((String)expectedGroup), (Object)StringUtils.toLowerCase((String)args[3]));
    }

    @Test
    @Timeout(value=30L)
    public void testChown() throws IOException {
        this.requireWinutils();
        File a = new File(TEST_DIR, "a");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)a.createNewFile());
        String username = System.getProperty("user.name");
        String qualifiedUsername = Shell.execCommand((String[])new String[]{"whoami"}).trim();
        String admins = "Administrators";
        String qualifiedAdmins = "BUILTIN\\Administrators";
        this.chown(username + ":" + admins, a);
        this.assertOwners(a, qualifiedUsername, qualifiedAdmins);
        this.chown(username, a);
        this.chown(":" + admins, a);
        this.assertOwners(a, qualifiedUsername, qualifiedAdmins);
        this.chown(":" + admins, a);
        this.chown(username + ":", a);
        this.assertOwners(a, qualifiedUsername, qualifiedAdmins);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)a.delete());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)a.exists());
    }

    @Test
    @Timeout(value=30L)
    public void testSymlinkRejectsForwardSlashesInLink() throws IOException {
        this.requireWinutils();
        File newFile = new File(TEST_DIR, "file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newFile.createNewFile());
        String target = newFile.getPath();
        String link = new File(TEST_DIR, "link").getPath().replaceAll("\\\\", "/");
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "symlink", link, target});
            org.junit.jupiter.api.Assertions.fail((String)String.format("did not receive expected failure creating symlink with forward slashes in link: link = %s, target = %s", link, target));
        }
        catch (IOException e) {
            LOG.info("Expected: Failed to create symlink with forward slashes in target");
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSymlinkRejectsForwardSlashesInTarget() throws IOException {
        this.requireWinutils();
        File newFile = new File(TEST_DIR, "file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)newFile.createNewFile());
        String target = newFile.getPath().replaceAll("\\\\", "/");
        String link = new File(TEST_DIR, "link").getPath();
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "symlink", link, target});
            org.junit.jupiter.api.Assertions.fail((String)String.format("did not receive expected failure creating symlink with forward slashes in target: link = %s, target = %s", link, target));
        }
        catch (IOException e) {
            LOG.info("Expected: Failed to create symlink with forward slashes in target");
        }
    }

    @Test
    @Timeout(value=30L)
    public void testReadLink() throws IOException {
        this.requireWinutils();
        File dir1 = new File(TEST_DIR, "dir1");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dir1.mkdirs());
        File file1 = new File(dir1, "file1.txt");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)file1.createNewFile());
        File dirLink = new File(TEST_DIR, "dlink");
        File fileLink = new File(TEST_DIR, "flink");
        Shell.execCommand((String[])new String[]{this.winutils, "symlink", dirLink.toString(), dir1.toString()});
        Shell.execCommand((String[])new String[]{this.winutils, "symlink", fileLink.toString(), file1.toString()});
        String readLinkOutput = Shell.execCommand((String[])new String[]{this.winutils, "readlink", dirLink.toString()});
        Assertions.assertThat((String)readLinkOutput).isEqualTo((Object)dir1.toString());
        readLinkOutput = Shell.execCommand((String[])new String[]{this.winutils, "readlink", fileLink.toString()});
        Assertions.assertThat((String)readLinkOutput).isEqualTo((Object)file1.toString());
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "readlink", ""});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1);
        }
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "readlink", "ThereIsNoSuchLink"});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1);
        }
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "readlink", dir1.toString()});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1);
        }
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "readlink", file1.toString()});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException when reading bad symlink");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1);
        }
        try {
            Shell.execCommand((String[])new String[]{this.winutils, "readlink", "a", "b"});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException with bad parameters");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testTaskCreate() throws IOException {
        this.requireWinutils();
        File batch = new File(TEST_DIR, "testTaskCreate.cmd");
        File proof = new File(TEST_DIR, "testTaskCreate.out");
        FileWriter fw = new FileWriter(batch);
        String testNumber = String.format("%f", Math.random());
        fw.write(String.format("echo %s > \"%s\"", testNumber, proof.getAbsolutePath()));
        fw.close();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)proof.exists());
        Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "testTaskCreate" + testNumber, batch.getAbsolutePath()});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)proof.exists());
        String outNumber = FileUtils.readFileToString((File)proof);
        Assertions.assertThat((String)outNumber).contains(new CharSequence[]{testNumber});
    }

    @Test
    @Timeout(value=30L)
    public void testTaskCreateWithLimits() throws IOException {
        this.requireWinutils();
        String jobId = String.format("%f", Math.random());
        String out = Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "job" + jobId, "cmd /c echo job" + jobId});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)out.trim().equals("job" + jobId));
        jobId = String.format("%f", Math.random());
        out = Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "-c", "-1", "-m", "-1", "job" + jobId, "cmd /c echo job" + jobId});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)out.trim().equals("job" + jobId));
        jobId = String.format("%f", Math.random());
        out = Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "-c", "10000", "-m", "128", "job" + jobId, "cmd /c echo job" + jobId});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)out.trim().equals("job" + jobId));
        try {
            jobId = String.format("%f", Math.random());
            out = Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "-m", "128", "job" + jobId, "java -Xmx256m -version"});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException with insufficient memory");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1);
        }
        try {
            jobId = String.format("%f", Math.random());
            Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "-c", "-1", "-m", "-1", "foo", "job" + jobId, "cmd /c echo job" + jobId});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException with bad parameters");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1639);
        }
        try {
            jobId = String.format("%f", Math.random());
            Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "-c", "-m", "-1", "job" + jobId, "cmd /c echo job" + jobId});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException with bad parameters");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1639);
        }
        try {
            jobId = String.format("%f", Math.random());
            Shell.execCommand((String[])new String[]{this.winutils, "task", "create", "-c", "foo", "job" + jobId, "cmd /c echo job" + jobId});
            org.junit.jupiter.api.Assertions.fail((String)"Failed to get Shell.ExitCodeException with bad parameters");
        }
        catch (Shell.ExitCodeException ece) {
            Assertions.assertThat((int)ece.getExitCode()).isEqualTo(1639);
        }
    }
}

