/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.SysInfoLinux;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSysInfoLinux {
    private static final FakeLinuxResourceCalculatorPlugin plugin;
    private static String TEST_ROOT_DIR;
    private static final String FAKE_MEMFILE;
    private static final String FAKE_CPUFILE;
    private static final String FAKE_STATFILE;
    private static final String FAKE_NETFILE;
    private static final String FAKE_DISKSFILE;
    private static final long FAKE_JIFFY_LENGTH = 10L;
    static final String MEMINFO_FORMAT = "MemTotal:      %d kB\nMemFree:         %d kB\nBuffers:        138244 kB\nCached:         947780 kB\nSwapCached:     142880 kB\nActive:        3229888 kB\nInactive:       %d kB\nSwapTotal:     %d kB\nSwapFree:      %d kB\nDirty:          122012 kB\nWriteback:           0 kB\nAnonPages:     2710792 kB\nMapped:          24740 kB\nSlab:           132528 kB\nSReclaimable:   105096 kB\nSUnreclaim:      27432 kB\nPageTables:      11448 kB\nNFS_Unstable:        0 kB\nBounce:              0 kB\nCommitLimit:   4125904 kB\nCommitted_AS:  4143556 kB\nVmallocTotal: 34359738367 kB\nVmallocUsed:      1632 kB\nVmallocChunk: 34359736375 kB\nHugePages_Total:     %d\nHugePages_Free:      0\nHugePages_Rsvd:      0\nHugepagesize:     2048 kB";
    static final String MEMINFO_FORMAT_2 = "MemTotal:       %d kB\nMemFree:        %d kB\nBuffers:          129976 kB\nCached:         32317676 kB\nSwapCached:            0 kB\nActive:         88938588 kB\nInactive:       %d kB\nActive(anon):   77502200 kB\nInactive(anon):  6385336 kB\nActive(file):   11436388 kB\nInactive(file): %d kB\nUnevictable:           0 kB\nMlocked:               0 kB\nSwapTotal:      %d kB\nSwapFree:       %d kB\nDirty:            575864 kB\nWriteback:            16 kB\nAnonPages:      83886180 kB\nMapped:           108640 kB\nShmem:              1880 kB\nSlab:            2413448 kB\nSReclaimable:    2194488 kB\nSUnreclaim:       218960 kB\nKernelStack:       31496 kB\nPageTables:       195176 kB\nNFS_Unstable:          0 kB\nBounce:                0 kB\nWritebackTmp:          0 kB\nCommitLimit:    97683468 kB\nCommitted_AS:   94553560 kB\nVmallocTotal:   34359738367 kB\nVmallocUsed:      498580 kB\nVmallocChunk:   34256922296 kB\nHardwareCorrupted: %d kB\nAnonHugePages:         0 kB\nHugePages_Total:       %d\nHugePages_Free:        0\nHugePages_Rsvd:        0\nHugePages_Surp:        0\nHugepagesize:       2048 kB\nDirectMap4k:        4096 kB\nDirectMap2M:     2027520 kB\nDirectMap1G:    132120576 kB\n";
    static final String MEMINFO_FORMAT3 = "MemTotal:      %d kB\nMemFree:         %s kB\nBuffers:        138244 kB\nCached:         947780 kB\nSwapCached:     142880 kB\nActive:        3229888 kB\nInactive:       %d kB\nSwapTotal:     %d kB\nSwapFree:      %s kB\nDirty:          122012 kB\nWriteback:           0 kB\nAnonPages:     2710792 kB\nMapped:          24740 kB\nSlab:           132528 kB\nSReclaimable:   105096 kB\nSUnreclaim:      27432 kB\nPageTables:      11448 kB\nNFS_Unstable:        0 kB\nBounce:              0 kB\nCommitLimit:   4125904 kB\nCommitted_AS:  4143556 kB\nVmallocTotal: 34359738367 kB\nVmallocUsed:      1632 kB\nVmallocChunk: 34359736375 kB\nHugePages_Total:     %d\nHugePages_Free:      0\nHugePages_Rsvd:      0\nHugepagesize:     2048 kB";
    static final String CPUINFO_FORMAT = "processor : %s\nvendor_id : AuthenticAMD\ncpu family  : 15\nmodel   : 33\nmodel name  : Dual Core AMD Opteron(tm) Processor 280\nstepping  : 2\ncpu MHz   : %f\ncache size  : 1024 KB\nphysical id : %s\nsiblings  : 2\ncore id   : %s\ncpu cores : 2\nfpu   : yes\nfpu_exception : yes\ncpuid level : 1\nwp    : yes\nflags   : fpu vme de pse tsc msr pae mce cx8 apic sep mtrr pge mca cmov pat pse36 clflush mmx fxsr sse sse2 ht syscall nx mmxext fxsr_opt lm 3dnowext 3dnow pni lahf_lm cmp_legacy\nbogomips  : 4792.41\nTLB size  : 1024 4K pages\nclflush size  : 64\ncache_alignment : 64\naddress sizes : 40 bits physical, 48 bits virtual\npower management: ts fid vid ttp";
    static final String STAT_FILE_FORMAT = "cpu  %d %d %d 1646495089 831319 48713 164346 0\ncpu0 15096055 30805 3823005 411456015 206027 13 14269 0\ncpu1 14760561 89890 6432036 408707910 456857 48074 130857 0\ncpu2 12761169 20842 3758639 413976772 98028 411 10288 0\ncpu3 12355207 47322 5789691 412354390 70406 213 8931 0\nintr 114648668 20010764 2 0 945665 2 0 0 0 0 0 0 0 4 0 0 0 0 0 0\nctxt 242017731764\nbtime 1257808753\nprocesses 26414943\nprocs_running 1\nprocs_blocked 0\n";
    static final String NETINFO_FORMAT = "Inter-|   Receive                                                |  Transmit\nface |bytes    packets errs drop fifo frame compressed multicast|bytes    packetserrs drop fifo colls carrier compressed\n   lo: 42236310  563003    0    0    0     0          0         0 42236310  563003    0    0    0     0       0          0\n eth0: %d 3452527    0    0    0     0          0    299787 %d 1866280    0    0    0     0       0          0\n eth1: %d 3152521    0    0    0     0          0    219781 %d 1866290    0    0    0     0       0          0\n";
    static final String DISKSINFO_FORMAT = "1       0 ram0 0 0 0 0 0 0 0 0 0 0 0\n1       1 ram1 0 0 0 0 0 0 0 0 0 0 0\n1       2 ram2 0 0 0 0 0 0 0 0 0 0 0\n1       3 ram3 0 0 0 0 0 0 0 0 0 0 0\n1       4 ram4 0 0 0 0 0 0 0 0 0 0 0\n1       5 ram5 0 0 0 0 0 0 0 0 0 0 0\n1       6 ram6 0 0 0 0 0 0 0 0 0 0 0\n7       0 loop0 0 0 0 0 0 0 0 0 0 0 0\n7       1 loop1 0 0 0 0 0 0 0 0 0 0 0\n8       0 sda 82575678 2486518 %d 59876600 3225402 19761924 %d 6407705 4 48803346 66227952\n8       1 sda1 732 289 21354 787 7 3 32 4 0 769 7918       2 sda2 744272 2206315 23605200 6742762 336830 2979630 26539520 1424776 4 1820130 8165444\n8       3 sda3 81830497 279914 17881852954 53132969 2888558 16782291 157367552 4982925 0 47077660 58061635\n8      32 sdc 10148118 693255 %d 122125461 6090515 401630172 %d 2696685590 0 26848216 2818793840\n8      33 sdc1 10147917 693230 2054138426 122125426 6090506 401630172 3261765880 2696685589 0 26848181 2818793804\n8      64 sde 9989771 553047 %d 93407551 5978572 391997273 %d 2388274325 0 24396646 2481664818\n8      65 sde1 9989570 553022 1943973346 93407489 5978563 391997273 3183807264 2388274325 0 24396584 2481666274\n8      80 sdf 10197163 693995 %d 144374395 6216644 408395438 %d 2669389056 0 26164759 2813746348\n8      81 sdf1 10196962 693970 2033452794 144374355 6216635 408395438 3316897064 2669389056 0 26164719 2813746308\n8     129 sdi1 10078602 657936 2056552626 108362198 6134036 403851153 3279882064 2639256086 0 26260432 2747601085\n";

    @Test
    public void parsingProcStatAndCpuFile() throws IOException {
        long numProcessors = 8L;
        long cpuFrequencyKHz = 2392781L;
        Object fileContent = "";
        int i = 0;
        while ((long)i < numProcessors) {
            fileContent = (String)fileContent + String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0, 0, 0) + "\n";
            ++i;
        }
        File tempFile = new File(FAKE_CPUFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_CPUFILE);
        fWriter.write((String)fileContent);
        fWriter.close();
        Assertions.assertEquals((long)plugin.getNumProcessors(), (long)numProcessors);
        Assertions.assertEquals((long)plugin.getCpuFrequency(), (long)cpuFrequencyKHz);
        long uTime = 54972994L;
        long nTime = 188860L;
        long sTime = 19803373L;
        tempFile = new File(FAKE_STATFILE);
        tempFile.deleteOnExit();
        this.updateStatFile(uTime, nTime, sTime);
        Assertions.assertEquals((long)plugin.getCumulativeCpuTime(), (long)(10L * (uTime + nTime + sTime)));
        Assertions.assertEquals((double)plugin.getCpuUsagePercentage(), (double)-1.0, (double)0.0);
        Assertions.assertEquals((double)plugin.getNumVCoresUsed(), (double)-1.0, (double)0.0);
        plugin.advanceTime(200L);
        this.updateStatFile(uTime += 100L, nTime, sTime);
        Assertions.assertEquals((long)plugin.getCumulativeCpuTime(), (long)(10L * (uTime + nTime + sTime)));
        Assertions.assertEquals((double)plugin.getCpuUsagePercentage(), (double)6.25, (double)0.0);
        Assertions.assertEquals((double)plugin.getNumVCoresUsed(), (double)0.5, (double)0.0);
        plugin.advanceTime(300L);
        this.updateStatFile(uTime += 600L, nTime, sTime);
        Assertions.assertEquals((double)plugin.getCpuUsagePercentage(), (double)25.0, (double)0.0);
        Assertions.assertEquals((double)plugin.getNumVCoresUsed(), (double)2.0, (double)0.0);
        plugin.advanceTime(1L);
        this.updateStatFile(++uTime, nTime, sTime);
        Assertions.assertEquals((long)plugin.getCumulativeCpuTime(), (long)(10L * (uTime + nTime + sTime)));
        Assertions.assertEquals((double)plugin.getCpuUsagePercentage(), (double)25.0, (double)0.0);
        Assertions.assertEquals((double)plugin.getNumVCoresUsed(), (double)2.0, (double)0.0);
    }

    private void updateStatFile(long uTime, long nTime, long sTime) throws IOException {
        FileWriter fWriter = new FileWriter(FAKE_STATFILE);
        fWriter.write(String.format(STAT_FILE_FORMAT, uTime, nTime, sTime));
        fWriter.close();
    }

    @Test
    public void parsingProcMemFile() throws IOException {
        long memTotal = 4058864L;
        long memFree = 99632L;
        long inactive = 567732L;
        long swapTotal = 2096472L;
        long swapFree = 1818480L;
        int nrHugePages = 10;
        File tempFile = new File(FAKE_MEMFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_MEMFILE);
        fWriter.write(String.format(MEMINFO_FORMAT, memTotal, memFree, inactive, swapTotal, swapFree, nrHugePages));
        fWriter.close();
        Assertions.assertEquals((long)plugin.getAvailablePhysicalMemorySize(), (long)(1024L * (memFree + inactive)));
        Assertions.assertEquals((long)plugin.getAvailableVirtualMemorySize(), (long)(1024L * (memFree + inactive + swapFree)));
        Assertions.assertEquals((long)plugin.getPhysicalMemorySize(), (long)(1024L * (memTotal - (long)(nrHugePages * 2048))));
        Assertions.assertEquals((long)plugin.getVirtualMemorySize(), (long)(1024L * (memTotal - (long)(nrHugePages * 2048) + swapTotal)));
    }

    @Test
    public void parsingProcMemFile2() throws IOException {
        long memTotal = 131403836L;
        long memFree = 11257036L;
        long inactive = 27396032L;
        long inactiveFile = 21010696L;
        long swapTotal = 31981552L;
        long swapFree = 1818480L;
        long hardwareCorrupt = 31960904L;
        int nrHugePages = 10;
        File tempFile = new File(FAKE_MEMFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_MEMFILE);
        fWriter.write(String.format(MEMINFO_FORMAT_2, memTotal, memFree, inactive, inactiveFile, swapTotal, swapFree, hardwareCorrupt, nrHugePages));
        fWriter.close();
        Assertions.assertEquals((long)plugin.getAvailablePhysicalMemorySize(), (long)(1024L * (memFree + inactiveFile)));
        Assertions.assertFalse((plugin.getAvailablePhysicalMemorySize() == 1024L * (memFree + inactive) ? 1 : 0) != 0);
        Assertions.assertEquals((long)plugin.getAvailableVirtualMemorySize(), (long)(1024L * (memFree + inactiveFile + swapFree)));
        Assertions.assertEquals((long)plugin.getPhysicalMemorySize(), (long)(1024L * (memTotal - hardwareCorrupt - (long)(nrHugePages * 2048))));
        Assertions.assertEquals((long)plugin.getVirtualMemorySize(), (long)(1024L * (memTotal - hardwareCorrupt - (long)(nrHugePages * 2048) + swapTotal)));
    }

    @Test
    public void parsingProcMemFileWithBadValues() throws IOException {
        long memTotal = 4058864L;
        long memFree = 0L;
        long inactive = 567732L;
        long swapTotal = 2096472L;
        long swapFree = 0L;
        int nrHugePages = 10;
        String badFreeValue = "18446744073709551596";
        File tempFile = new File(FAKE_MEMFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_MEMFILE);
        fWriter.write(String.format(MEMINFO_FORMAT3, memTotal, badFreeValue, inactive, swapTotal, badFreeValue, nrHugePages));
        fWriter.close();
        Assertions.assertEquals((long)plugin.getAvailablePhysicalMemorySize(), (long)(1024L * (memFree + inactive)));
        Assertions.assertEquals((long)plugin.getAvailableVirtualMemorySize(), (long)(1024L * (memFree + inactive + swapFree)));
        Assertions.assertEquals((long)plugin.getPhysicalMemorySize(), (long)(1024L * (memTotal - (long)(nrHugePages * 2048))));
        Assertions.assertEquals((long)plugin.getVirtualMemorySize(), (long)(1024L * (memTotal - (long)(nrHugePages * 2048) + swapTotal)));
    }

    @Test
    public void testCoreCounts() throws IOException {
        String fileContent = "";
        long numProcessors = 2L;
        long cpuFrequencyKHz = 2392781L;
        int i = 0;
        while ((long)i < numProcessors) {
            fileContent = fileContent.concat(String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0, 0, 0));
            fileContent = fileContent.concat("\n");
            ++i;
        }
        this.writeFakeCPUInfoFile(fileContent);
        plugin.setReadCpuInfoFile(false);
        Assertions.assertEquals((long)numProcessors, (long)plugin.getNumProcessors());
        Assertions.assertEquals((int)1, (int)plugin.getNumCores());
        fileContent = "";
        numProcessors = 4L;
        i = 0;
        while ((long)i < numProcessors) {
            fileContent = fileContent.concat(String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0, 0, i));
            fileContent = fileContent.concat("\n");
            ++i;
        }
        this.writeFakeCPUInfoFile(fileContent);
        plugin.setReadCpuInfoFile(false);
        Assertions.assertEquals((long)numProcessors, (long)plugin.getNumProcessors());
        Assertions.assertEquals((int)4, (int)plugin.getNumCores());
        fileContent = "";
        numProcessors = 4L;
        i = 0;
        while ((long)i < numProcessors) {
            fileContent = fileContent.concat(String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0, i / 2, 0));
            fileContent = fileContent.concat("\n");
            ++i;
        }
        this.writeFakeCPUInfoFile(fileContent);
        plugin.setReadCpuInfoFile(false);
        Assertions.assertEquals((long)numProcessors, (long)plugin.getNumProcessors());
        Assertions.assertEquals((int)2, (int)plugin.getNumCores());
        fileContent = "";
        numProcessors = 4L;
        i = 0;
        while ((long)i < numProcessors) {
            fileContent = fileContent.concat(String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0, i / 2, i % 2));
            fileContent = fileContent.concat("\n");
            ++i;
        }
        this.writeFakeCPUInfoFile(fileContent);
        plugin.setReadCpuInfoFile(false);
        Assertions.assertEquals((long)numProcessors, (long)plugin.getNumProcessors());
        Assertions.assertEquals((int)4, (int)plugin.getNumCores());
        fileContent = "";
        numProcessors = 8L;
        i = 0;
        while ((long)i < numProcessors) {
            fileContent = fileContent.concat(String.format(CPUINFO_FORMAT, i, (double)cpuFrequencyKHz / 1000.0, i / 4, i % 4 / 2));
            fileContent = fileContent.concat("\n");
            ++i;
        }
        this.writeFakeCPUInfoFile(fileContent);
        plugin.setReadCpuInfoFile(false);
        Assertions.assertEquals((long)numProcessors, (long)plugin.getNumProcessors());
        Assertions.assertEquals((int)4, (int)plugin.getNumCores());
    }

    private void writeFakeCPUInfoFile(String content) throws IOException {
        File tempFile = new File(FAKE_CPUFILE);
        try (FileWriter fWriter = new FileWriter(FAKE_CPUFILE);){
            tempFile.deleteOnExit();
            fWriter.write(content);
        }
    }

    @Test
    public void parsingProcNetFile() throws IOException {
        long numBytesReadIntf1 = 2097172468L;
        long numBytesWrittenIntf1 = 1355620114L;
        long numBytesReadIntf2 = 1097172460L;
        long numBytesWrittenIntf2 = 1055620110L;
        File tempFile = new File(FAKE_NETFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_NETFILE);
        fWriter.write(String.format(NETINFO_FORMAT, numBytesReadIntf1, numBytesWrittenIntf1, numBytesReadIntf2, numBytesWrittenIntf2));
        fWriter.close();
        Assertions.assertEquals((long)plugin.getNetworkBytesRead(), (long)(numBytesReadIntf1 + numBytesReadIntf2));
        Assertions.assertEquals((long)plugin.getNetworkBytesWritten(), (long)(numBytesWrittenIntf1 + numBytesWrittenIntf2));
    }

    @Test
    public void parsingProcDisksFile() throws IOException {
        long numSectorsReadsda = 1790549L;
        long numSectorsWrittensda = 1839071L;
        long numSectorsReadsdc = 20541402L;
        long numSectorsWrittensdc = 32617658L;
        long numSectorsReadsde = 19439751L;
        long numSectorsWrittensde = 31838072L;
        long numSectorsReadsdf = 20334546L;
        long numSectorsWrittensdf = 33168970L;
        File tempFile = new File(FAKE_DISKSFILE);
        tempFile.deleteOnExit();
        FileWriter fWriter = new FileWriter(FAKE_DISKSFILE);
        fWriter.write(String.format(DISKSINFO_FORMAT, numSectorsReadsda, numSectorsWrittensda, numSectorsReadsdc, numSectorsWrittensdc, numSectorsReadsde, numSectorsWrittensde, numSectorsReadsdf, numSectorsWrittensdf));
        fWriter.close();
        long expectedNumSectorsRead = numSectorsReadsda + numSectorsReadsdc + numSectorsReadsde + numSectorsReadsdf;
        long expectedNumSectorsWritten = numSectorsWrittensda + numSectorsWrittensdc + numSectorsWrittensde + numSectorsWrittensdf;
        int diskSectorSize = 4096;
        Assertions.assertEquals((long)(expectedNumSectorsRead * (long)diskSectorSize), (long)plugin.getStorageBytesRead());
        Assertions.assertEquals((long)(expectedNumSectorsWritten * (long)diskSectorSize), (long)plugin.getStorageBytesWritten());
    }

    static {
        TEST_ROOT_DIR = GenericTestUtils.getTestDir().getAbsolutePath();
        int randomNum = new Random().nextInt(1000000000);
        FAKE_MEMFILE = TEST_ROOT_DIR + File.separator + "MEMINFO_" + randomNum;
        FAKE_CPUFILE = TEST_ROOT_DIR + File.separator + "CPUINFO_" + randomNum;
        FAKE_STATFILE = TEST_ROOT_DIR + File.separator + "STATINFO_" + randomNum;
        FAKE_NETFILE = TEST_ROOT_DIR + File.separator + "NETINFO_" + randomNum;
        FAKE_DISKSFILE = TEST_ROOT_DIR + File.separator + "DISKSINFO_" + randomNum;
        plugin = new FakeLinuxResourceCalculatorPlugin(FAKE_MEMFILE, FAKE_CPUFILE, FAKE_STATFILE, FAKE_NETFILE, FAKE_DISKSFILE, 10L);
    }

    static class FakeLinuxResourceCalculatorPlugin
    extends SysInfoLinux {
        static final int SECTORSIZE = 4096;
        long currentTime = 0L;

        public FakeLinuxResourceCalculatorPlugin(String procfsMemFile, String procfsCpuFile, String procfsStatFile, String procfsNetFile, String procfsDisksFile, long jiffyLengthInMillis) {
            super(procfsMemFile, procfsCpuFile, procfsStatFile, procfsNetFile, procfsDisksFile, jiffyLengthInMillis);
        }

        long getCurrentTime() {
            return this.currentTime;
        }

        public void advanceTime(long adv) {
            this.currentTime += adv * this.getJiffyLengthInMillis();
        }

        int readDiskBlockInformation(String diskName, int defSector) {
            return 4096;
        }
    }
}

