/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.UnitTestcaseTimeLimit;
import org.apache.hadoop.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestStringUtils
extends UnitTestcaseTimeLimit {
    private static final String NULL_STR = null;
    private static final String EMPTY_STR = "";
    private static final String STR_WO_SPECIAL_CHARS = "AB";
    private static final String STR_WITH_COMMA = "A,B";
    private static final String ESCAPED_STR_WITH_COMMA = "A\\,B";
    private static final String STR_WITH_ESCAPE = "AB\\";
    private static final String ESCAPED_STR_WITH_ESCAPE = "AB\\\\";
    private static final String STR_WITH_BOTH2 = ",A\\,,B\\\\,";
    private static final String ESCAPED_STR_WITH_BOTH2 = "\\,A\\\\\\,\\,B\\\\\\\\\\,";
    private static final FastDateFormat FAST_DATE_FORMAT = FastDateFormat.getInstance((String)"d-MMM-yyyy HH:mm:ss");

    @Test
    @Timeout(value=30L)
    public void testEscapeString() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)NULL_STR, (Object)StringUtils.escapeString((String)NULL_STR));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.escapeString((String)EMPTY_STR));
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)StringUtils.escapeString((String)STR_WO_SPECIAL_CHARS));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ESCAPED_STR_WITH_COMMA, (Object)StringUtils.escapeString((String)STR_WITH_COMMA));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ESCAPED_STR_WITH_ESCAPE, (Object)StringUtils.escapeString((String)STR_WITH_ESCAPE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ESCAPED_STR_WITH_BOTH2, (Object)StringUtils.escapeString((String)STR_WITH_BOTH2));
    }

    @Test
    @Timeout(value=30L)
    public void testSplit() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)NULL_STR, (Object)StringUtils.split((String)NULL_STR));
        String[] splits = StringUtils.split((String)EMPTY_STR);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)splits.length);
        splits = StringUtils.split((String)",,");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)splits.length);
        splits = StringUtils.split((String)STR_WO_SPECIAL_CHARS);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)splits.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_COMMA);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)splits.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A", (Object)splits[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"B", (Object)splits[1]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_COMMA);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)splits.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ESCAPED_STR_WITH_COMMA, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_ESCAPE);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)splits.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WITH_ESCAPE, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_BOTH2);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)splits.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)splits[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"A\\,", (Object)splits[1]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"B\\\\", (Object)splits[2]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_BOTH2);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)splits.length);
        org.junit.jupiter.api.Assertions.assertEquals((Object)ESCAPED_STR_WITH_BOTH2, (Object)splits[0]);
    }

    @Test
    @Timeout(value=30L)
    public void testSimpleSplit() throws Exception {
        String[] TO_TEST;
        for (String testSubject : TO_TEST = new String[]{"a/b/c", "a/b/c////", "///a/b/c", EMPTY_STR, "/", "////"}) {
            org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])testSubject.split("/"), (Object[])StringUtils.split((String)testSubject, (char)'/'), (String)("Testing '" + testSubject + "'"));
        }
    }

    @Test
    @Timeout(value=30L)
    public void testUnescapeString() throws Exception {
        org.junit.jupiter.api.Assertions.assertEquals((Object)NULL_STR, (Object)StringUtils.unEscapeString((String)NULL_STR));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.unEscapeString((String)EMPTY_STR));
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)StringUtils.unEscapeString((String)STR_WO_SPECIAL_CHARS));
        try {
            StringUtils.unEscapeString((String)STR_WITH_COMMA);
            org.junit.jupiter.api.Assertions.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WITH_COMMA, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_COMMA));
        try {
            StringUtils.unEscapeString((String)STR_WITH_ESCAPE);
            org.junit.jupiter.api.Assertions.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WITH_ESCAPE, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_ESCAPE));
        try {
            StringUtils.unEscapeString((String)STR_WITH_BOTH2);
            org.junit.jupiter.api.Assertions.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)STR_WITH_BOTH2, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_BOTH2));
    }

    @Test
    @Timeout(value=30L)
    public void testTraditionalBinaryPrefix() throws Exception {
        String[] symbol = new String[]{"k", "m", "g", "t", "p", "e"};
        long m = 1024L;
        for (String s : symbol) {
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)("0" + s)));
            org.junit.jupiter.api.Assertions.assertEquals((long)m, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)("1" + s)));
            m *= 1024L;
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"0"));
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"1k"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1024L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1k"));
        org.junit.jupiter.api.Assertions.assertEquals((long)1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"1230K"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1230K"));
        org.junit.jupiter.api.Assertions.assertEquals((long)0x6400000L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"100m"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-104857600L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-100M"));
        org.junit.jupiter.api.Assertions.assertEquals((long)956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"891g"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-891G"));
        org.junit.jupiter.api.Assertions.assertEquals((long)501377302265856L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"456t"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-501377302265856L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-456T"));
        org.junit.jupiter.api.Assertions.assertEquals((long)0x28000000000000L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"10p"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-11258999068426240L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-10P"));
        org.junit.jupiter.api.Assertions.assertEquals((long)0x1000000000000000L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"1e"));
        org.junit.jupiter.api.Assertions.assertEquals((long)-1152921504606846976L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1E"));
        String tooLargeNumStr = "10e";
        try {
            StringUtils.TraditionalBinaryPrefix.string2long((String)tooLargeNumStr);
            org.junit.jupiter.api.Assertions.fail((String)("Test passed for a number " + tooLargeNumStr + " too large"));
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)(tooLargeNumStr + " does not fit in a Long"), (Object)e.getMessage());
        }
        String tooSmallNumStr = "-10e";
        try {
            StringUtils.TraditionalBinaryPrefix.string2long((String)tooSmallNumStr);
            org.junit.jupiter.api.Assertions.fail((String)("Test passed for a number " + tooSmallNumStr + " too small"));
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)(tooSmallNumStr + " does not fit in a Long"), (Object)e.getMessage());
        }
        String invalidFormatNumStr = "10kb";
        char invalidPrefix = 'b';
        try {
            StringUtils.TraditionalBinaryPrefix.string2long((String)invalidFormatNumStr);
            org.junit.jupiter.api.Assertions.fail((String)("Test passed for a number " + invalidFormatNumStr + " has invalid format"));
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)("Invalid size prefix '" + invalidPrefix + "' in '" + invalidFormatNumStr + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)"), (Object)e.getMessage());
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0L, null, (int)2));
        for (int decimalPlace = 0; decimalPlace < 2; ++decimalPlace) {
            int n = 1;
            while ((long)n < StringUtils.TraditionalBinaryPrefix.KILO.value) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)(EMPTY_STR + n), (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace));
                org.junit.jupiter.api.Assertions.assertEquals((Object)(EMPTY_STR + -n), (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)(-n), null, (int)decimalPlace));
                ++n;
            }
            org.junit.jupiter.api.Assertions.assertEquals((Object)"1 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)1024L, null, (int)decimalPlace));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"-1 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)-1024L, null, (int)decimalPlace));
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8.00 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)Long.MAX_VALUE, null, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"8.00 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0x7FFFFFFFFFFFFFFEL, null, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-8 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)Long.MIN_VALUE, null, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-8.00 E", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)-9223372036854775807L, null, (int)2));
        String[] zeros = new String[]{" ", ".0 ", ".00 "};
        for (int decimalPlace = 0; decimalPlace < zeros.length; ++decimalPlace) {
            String trailingZeros = zeros[decimalPlace];
            for (int e = 11; e < 63; ++e) {
                StringUtils.TraditionalBinaryPrefix p = StringUtils.TraditionalBinaryPrefix.values()[e / 10 - 1];
                long n = 1L << e;
                String expected = n / p.value + " " + p.symbol;
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)2), (String)("n=" + n));
                n = (1L << e) + 1L;
                expected = n / p.value + trailingZeros + p.symbol;
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace), (String)("n=" + n));
                n = (1L << e) - 1L;
                expected = (n + 1L) / p.value + trailingZeros + p.symbol;
                org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)n, null, (int)decimalPlace), (String)("n=" + n));
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.50 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)1536L, null, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.5 K", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)1536L, null, (int)1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.50 M", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0x180000L, null, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"2 M", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0x180000L, null, (int)0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3 G", (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)0xC0000000L, null, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0 B", (Object)StringUtils.byteDesc((long)0L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"-100 B", (Object)StringUtils.byteDesc((long)-100L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1 KB", (Object)StringUtils.byteDesc((long)1024L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.50 KB", (Object)StringUtils.byteDesc((long)1536L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1.50 MB", (Object)StringUtils.byteDesc((long)0x180000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"3 GB", (Object)StringUtils.byteDesc((long)0xC0000000L));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10%", (Object)StringUtils.formatPercent((double)0.1, (int)0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.0%", (Object)StringUtils.formatPercent((double)0.1, (int)1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.00%", (Object)StringUtils.formatPercent((double)0.1, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"1%", (Object)StringUtils.formatPercent((double)0.00543, (int)0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.5%", (Object)StringUtils.formatPercent((double)0.00543, (int)1));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.54%", (Object)StringUtils.formatPercent((double)0.00543, (int)2));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.543%", (Object)StringUtils.formatPercent((double)0.00543, (int)3));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"0.5430%", (Object)StringUtils.formatPercent((double)0.00543, (int)4));
    }

    @Test
    @Timeout(value=30L)
    public void testJoin() {
        ArrayList<String> s = new ArrayList<String>();
        s.add("a");
        s.add("b");
        s.add("c");
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.join((CharSequence)":", s.subList(0, 0)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)StringUtils.join((CharSequence)":", s.subList(0, 1)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.join((char)':', s.subList(0, 0)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a", (Object)StringUtils.join((char)':', s.subList(0, 1)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a:b", (Object)StringUtils.join((CharSequence)":", s.subList(0, 2)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a:b:c", (Object)StringUtils.join((CharSequence)":", s.subList(0, 3)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a:b", (Object)StringUtils.join((char)':', s.subList(0, 2)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"a:b:c", (Object)StringUtils.join((char)':', s.subList(0, 3)));
    }

    @Test
    @Timeout(value=30L)
    public void testGetTrimmedStrings() throws Exception {
        String compactDirList = "/spindle1/hdfs,/spindle2/hdfs,/spindle3/hdfs";
        String spacedDirList = "/spindle1/hdfs, /spindle2/hdfs, /spindle3/hdfs";
        String pathologicalDirList1 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs ";
        String pathologicalDirList2 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs , ";
        String emptyList1 = EMPTY_STR;
        String emptyList2 = "   ";
        Object[] expectedArray = new String[]{"/spindle1/hdfs", "/spindle2/hdfs", "/spindle3/hdfs"};
        Object[] emptyArray = new String[]{};
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)compactDirList));
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)spacedDirList));
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList1));
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList2));
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])emptyArray, (Object[])StringUtils.getTrimmedStrings((String)emptyList1));
        Object[] estring = StringUtils.getTrimmedStrings((String)emptyList2);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])emptyArray, (Object[])estring);
    }

    @Test
    @Timeout(value=30L)
    public void testCamelize() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Map", (Object)StringUtils.camelize((String)"MAP"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"JobSetup", (Object)StringUtils.camelize((String)"JOB_SETUP"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SomeStuff", (Object)StringUtils.camelize((String)"some_stuff"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Aa", (Object)StringUtils.camelize((String)"aA"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Bb", (Object)StringUtils.camelize((String)"bB"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Cc", (Object)StringUtils.camelize((String)"cC"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Dd", (Object)StringUtils.camelize((String)"dD"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ee", (Object)StringUtils.camelize((String)"eE"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ff", (Object)StringUtils.camelize((String)"fF"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Gg", (Object)StringUtils.camelize((String)"gG"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hh", (Object)StringUtils.camelize((String)"hH"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ii", (Object)StringUtils.camelize((String)"iI"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Jj", (Object)StringUtils.camelize((String)"jJ"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Kk", (Object)StringUtils.camelize((String)"kK"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ll", (Object)StringUtils.camelize((String)"lL"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Mm", (Object)StringUtils.camelize((String)"mM"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Nn", (Object)StringUtils.camelize((String)"nN"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Oo", (Object)StringUtils.camelize((String)"oO"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Pp", (Object)StringUtils.camelize((String)"pP"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Qq", (Object)StringUtils.camelize((String)"qQ"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Rr", (Object)StringUtils.camelize((String)"rR"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ss", (Object)StringUtils.camelize((String)"sS"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Tt", (Object)StringUtils.camelize((String)"tT"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Uu", (Object)StringUtils.camelize((String)"uU"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Vv", (Object)StringUtils.camelize((String)"vV"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Ww", (Object)StringUtils.camelize((String)"wW"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Xx", (Object)StringUtils.camelize((String)"xX"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Yy", (Object)StringUtils.camelize((String)"yY"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Zz", (Object)StringUtils.camelize((String)"zZ"));
    }

    @Test
    @Timeout(value=30L)
    public void testStringToURI() {
        String[] str = new String[]{"file://"};
        try {
            StringUtils.stringToURI((String[])str);
            org.junit.jupiter.api.Assertions.fail((String)"Ignoring URISyntaxException while creating URI from string file://");
        }
        catch (IllegalArgumentException iae) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Failed to create uri for file://", (Object)iae.getMessage());
        }
    }

    @Test
    @Timeout(value=30L)
    public void testSimpleHostName() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hadoop01", (Object)StringUtils.simpleHostname((String)"hadoop01.domain.com"), (String)"Should return hostname when FQDN is specified");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hadoop01", (Object)StringUtils.simpleHostname((String)"hadoop01"), (String)"Should return hostname when only hostname is specified");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10.10.5.68", (Object)StringUtils.simpleHostname((String)"10.10.5.68"), (String)"Should not truncate when IP address is passed");
    }

    @Test
    @Timeout(value=5L)
    public void testReplaceTokensShellEnvVars() {
        Pattern pattern = StringUtils.SHELL_ENV_VAR_PATTERN;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("FOO", "one");
        replacements.put("BAZ", "two");
        replacements.put("NUMBERS123", "one-two-three");
        replacements.put("UNDER_SCORES", "___");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"one", (Object)StringUtils.replaceTokens((String)"$FOO", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"two", (Object)StringUtils.replaceTokens((String)"$BAZ", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)"$BAR", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)EMPTY_STR, (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"one-two-three", (Object)StringUtils.replaceTokens((String)"$NUMBERS123", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"___", (Object)StringUtils.replaceTokens((String)"$UNDER_SCORES", (Pattern)pattern, replacements));
    }

    @Test
    @Timeout(value=5L)
    public void testReplaceTokensWinEnvVars() {
        Pattern pattern = StringUtils.WIN_ENV_VAR_PATTERN;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("foo", "zoo");
        replacements.put("baz", "zaz");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"zoo", (Object)StringUtils.replaceTokens((String)"%foo%", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"zaz", (Object)StringUtils.replaceTokens((String)"%baz%", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)"%bar%", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)EMPTY_STR, (Object)StringUtils.replaceTokens((String)EMPTY_STR, (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"zoo__zaz", (Object)StringUtils.replaceTokens((String)"%foo%_%bar%_%baz%", (Pattern)pattern, replacements));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"begin zoo__zaz end", (Object)StringUtils.replaceTokens((String)"begin %foo%_%bar%_%baz% end", (Pattern)pattern, replacements));
    }

    @Test
    public void testGetUniqueNonEmptyTrimmedStrings() {
        String TO_SPLIT = ",foo, bar,baz,,blah,blah,bar,";
        Collection col = StringUtils.getTrimmedStringCollection((String)",foo, bar,baz,,blah,blah,bar,");
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)col.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)col.containsAll(Arrays.asList("foo", "bar", "baz", "blah")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLowerAndUpperStrings() {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("tr", "TR"));
            String upperStr = "TITLE";
            String lowerStr = "title";
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)lowerStr, (Object)upperStr.toLowerCase());
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)upperStr, (Object)lowerStr.toUpperCase());
            org.junit.jupiter.api.Assertions.assertEquals((Object)lowerStr, (Object)StringUtils.toLowerCase((String)upperStr));
            org.junit.jupiter.api.Assertions.assertEquals((Object)upperStr, (Object)StringUtils.toUpperCase((String)lowerStr));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)StringUtils.equalsIgnoreCase((String)upperStr, (String)lowerStr));
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    @Test
    public void testGetFormattedTimeWithDiff() throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(16);
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        for (int i = 0; i < 10; ++i) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        cyclicBarrier.await();
                    }
                    catch (InterruptedException | BrokenBarrierException exception) {
                        // empty catch block
                    }
                    long end = System.currentTimeMillis();
                    long start = end - 30000L;
                    String formattedTime1 = StringUtils.getFormattedTimeWithDiff((FastDateFormat)FAST_DATE_FORMAT, (long)start, (long)end);
                    String formattedTime2 = StringUtils.getFormattedTimeWithDiff((FastDateFormat)FAST_DATE_FORMAT, (long)start, (long)end);
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)formattedTime1.equals(formattedTime2), (String)"Method returned inconsistent results indicative of a race condition");
                }
            });
        }
        executorService.shutdown();
        executorService.awaitTermination(50L, TimeUnit.SECONDS);
    }

    @Test
    public void testFormatTimeSortable() {
        long timeDiff = 523452311L;
        String timeDiffStr = "99hrs, 59mins, 59sec";
        org.junit.jupiter.api.Assertions.assertEquals((Object)timeDiffStr, (Object)StringUtils.formatTimeSortable((long)timeDiff), (String)"Incorrect time diff string returned");
    }

    @Test
    public void testIsAlpha() {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)StringUtils.isAlpha((String)"hello"), (String)"Reported hello as non-alpha string");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)StringUtils.isAlpha((String)"hello1"), (String)"Reported hello1 as alpha string");
    }

    @Test
    public void testEscapeHTML() {
        String htmlStr = "<p>Hello. How are you?</p>";
        String escapedStr = "&lt;p&gt;Hello. How are you?&lt;/p&gt;";
        org.junit.jupiter.api.Assertions.assertEquals((Object)escapedStr, (Object)StringUtils.escapeHTML((String)htmlStr), (String)"Incorrect escaped HTML string returned");
    }

    @Test
    public void testCreateStartupShutdownMessage() {
        String msg = StringUtils.createStartupShutdownMessage((String)this.getClass().getName(), (String)"test.host", null);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)msg.startsWith("STARTUP_MSG:"));
    }

    @Test
    public void testStringCollectionSplitByEqualsSuccess() {
        Map splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)EMPTY_STR);
        ((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(0);
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals(null);
        ((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(0);
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)"element.first.key1 = element.first.val1");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(1)).containsEntry((Object)"element.first.key1", (Object)"element.first.val1");
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)"element.xyz.key1 =element.abc.val1 , element.xyz.key2= element.abc.val2");
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(2)).containsEntry((Object)"element.xyz.key1", (Object)"element.abc.val1")).containsEntry((Object)"element.xyz.key2", (Object)"element.abc.val2");
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)"\nelement.xyz.key1 =element.abc.val1 \n, element.xyz.key2=element.abc.val2,element.xyz.key3=element.abc.val3 , element.xyz.key4     =element.abc.val4,element.xyz.key5=        element.abc.val5 ,\n \n \n  element.xyz.key6      =       element.abc.val6 \n , \nelement.xyz.key7=element.abc.val7,\n");
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(7)).containsEntry((Object)"element.xyz.key1", (Object)"element.abc.val1")).containsEntry((Object)"element.xyz.key2", (Object)"element.abc.val2")).containsEntry((Object)"element.xyz.key3", (Object)"element.abc.val3")).containsEntry((Object)"element.xyz.key4", (Object)"element.abc.val4")).containsEntry((Object)"element.xyz.key5", (Object)"element.abc.val5")).containsEntry((Object)"element.xyz.key6", (Object)"element.abc.val6")).containsEntry((Object)"element.xyz.key7", (Object)"element.abc.val7");
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)"element.first.key1 = element.first.val2 ,element.first.key1 =element.first.val1");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(1)).containsEntry((Object)"element.first.key1", (Object)"element.first.val1");
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)",,, , ,, ,element.first.key1 = element.first.val2 ,element.first.key1 = element.first.val1 , ,,, ,");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(1)).containsEntry((Object)"element.first.key1", (Object)"element.first.val1");
        splitMap = StringUtils.getTrimmedStringCollectionSplitByEquals((String)",, , ,      ,, ,");
        ((MapAssert)Assertions.assertThat((Map)splitMap).describedAs("Map of key value pairs split by equals(=) and comma(,)", new Object[0])).hasSize(0);
    }

    @Test
    public void testStringCollectionSplitByEqualsFailure() throws Exception {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "Trimmed string split by equals does not correctly represent non-empty key-value pairs.", () -> StringUtils.getTrimmedStringCollectionSplitByEquals((String)" = element.abc.val1"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "Trimmed string split by equals does not correctly represent non-empty key-value pairs.", () -> StringUtils.getTrimmedStringCollectionSplitByEquals((String)"element.abc.key1="));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "Trimmed string split by equals does not correctly represent non-empty key-value pairs.", () -> StringUtils.getTrimmedStringCollectionSplitByEquals((String)"="));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "Trimmed string split by equals does not correctly represent non-empty key-value pairs.", () -> StringUtils.getTrimmedStringCollectionSplitByEquals((String)"== = =    ="));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "Trimmed string split by equals does not correctly represent non-empty key-value pairs.", () -> StringUtils.getTrimmedStringCollectionSplitByEquals((String)",="));
    }

    @Test
    public void testForGetStackTrace() {
        Throwable throwable = new Throwable();
        int stackLength = throwable.getStackTrace().length;
        String stackTrace = StringUtils.getStackTrace((Throwable)new Throwable());
        String[] splitTrace = stackTrace.split("\n\t");
        org.junit.jupiter.api.Assertions.assertEquals((int)stackLength, (int)splitTrace.length);
    }
}

