/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.hadoop.util.ShutdownThreadsHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestShutdownThreadsHelper {
    private Runnable sampleRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Thread.sleep(6000L);
            }
            catch (InterruptedException ie) {
                System.out.println("Thread interrupted");
            }
        }
    };

    @Test
    @Timeout(value=3L)
    public void testShutdownThread() {
        Thread thread = new Thread(this.sampleRunnable);
        thread.start();
        boolean ret = ShutdownThreadsHelper.shutdownThread((Thread)thread);
        boolean isTerminated = !thread.isAlive();
        Assertions.assertEquals((Object)ret, (Object)isTerminated, (String)"Incorrect return value");
        Assertions.assertTrue((boolean)isTerminated, (String)"Thread is not shutdown");
    }

    @Test
    public void testShutdownThreadPool() throws InterruptedException {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.execute(this.sampleRunnable);
        boolean ret = ShutdownThreadsHelper.shutdownExecutorService((ExecutorService)executor);
        boolean isTerminated = executor.isTerminated();
        Assertions.assertEquals((Object)ret, (Object)isTerminated, (String)"Incorrect return value");
        Assertions.assertTrue((boolean)isTerminated, (String)"ExecutorService is not shutdown");
    }
}

