/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.LightWeightResizableGSet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLightWeightResizableGSet {
    public static final Logger LOG = LoggerFactory.getLogger(TestLightWeightResizableGSet.class);
    private Random random = new Random();

    private TestElement[] generateElements(int length) {
        TestElement[] elements = new TestElement[length];
        HashSet<Long> keys = new HashSet<Long>();
        long k = 0L;
        for (int i = 0; i < length; ++i) {
            while (keys.contains(k = this.random.nextLong())) {
            }
            elements[i] = new TestElement(k, this.random.nextLong());
            keys.add(k);
        }
        return elements;
    }

    private TestKey[] getKeys(TestElement[] elements) {
        TestKey[] keys = new TestKey[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            keys[i] = new TestKey(elements[i].getKey());
        }
        return keys;
    }

    private TestElement[] generateElements(TestKey[] keys) {
        TestElement[] elements = new TestElement[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            elements[i] = new TestElement(keys[i], this.random.nextLong());
        }
        return elements;
    }

    @Test
    @Timeout(value=60L)
    public void testBasicOperations() {
        Object element;
        int i;
        TestElement element2;
        int i2;
        TestElement[] elements = this.generateElements(65536);
        LightWeightResizableGSet set = new LightWeightResizableGSet();
        Assertions.assertThat((int)set.size()).isZero();
        for (i2 = 0; i2 < elements.length; ++i2) {
            element2 = (TestElement)set.put((Object)elements[i2]);
            Assertions.assertThat((Object)element2).isNull();
        }
        Assertions.assertThat((int)set.size()).isEqualTo(elements.length);
        for (i2 = 0; i2 < elements.length; ++i2) {
            Assertions.assertThat((boolean)set.contains((Object)elements[i2])).isTrue();
            element2 = (TestElement)set.get((Object)elements[i2]);
            Assertions.assertThat((long)elements[i2].getData()).isEqualTo(element2.getData());
        }
        TestKey[] keys = this.getKeys(elements);
        TestElement[] newElements = this.generateElements(keys);
        for (i = 0; i < newElements.length; ++i) {
            element = (TestElement)set.put((Object)newElements[i]);
            Assertions.assertThat((Object)element).isNotNull();
        }
        Assertions.assertThat((int)set.size()).isEqualTo(elements.length);
        for (i = 0; i < keys.length; ++i) {
            Assertions.assertThat((boolean)set.contains((Object)keys[i])).isTrue();
            element = (TestElement)set.get((Object)keys[i]);
            Assertions.assertThat((long)newElements[i].getData()).isEqualTo(((TestElement)element).getData());
        }
        Collection cElements = set.values();
        Assertions.assertThat((int)cElements.size()).isEqualTo(elements.length);
        for (TestElement element3 : cElements) {
            Assertions.assertThat((boolean)set.contains((Object)element3)).isTrue();
        }
        for (int i3 = 0; i3 < keys.length; ++i3) {
            TestElement element3;
            element3 = (TestElement)set.remove((Object)keys[i3]);
            Assertions.assertThat((Object)element3).isNotNull();
            Assertions.assertThat((boolean)set.contains((Object)keys[i3])).isFalse();
        }
        Assertions.assertThat((int)set.size()).isZero();
    }

    @Test
    @Timeout(value=60L)
    public void testRemoveAll() {
        TestElement element;
        int i;
        TestElement[] elements = this.generateElements(65536);
        LightWeightResizableGSet set = new LightWeightResizableGSet();
        Assertions.assertThat((int)set.size()).isZero();
        for (i = 0; i < elements.length; ++i) {
            element = (TestElement)set.put((Object)elements[i]);
            Assertions.assertThat((Object)element).isNull();
        }
        Assertions.assertThat((int)set.size()).isEqualTo(elements.length);
        set.clear();
        Assertions.assertThat((int)set.size()).isZero();
        for (i = 0; i < elements.length; ++i) {
            Assertions.assertThat((boolean)set.contains((Object)elements[i])).isFalse();
        }
        Assertions.assertThat((boolean)set.iterator().hasNext()).isFalse();
        for (i = 0; i < elements.length; ++i) {
            element = (TestElement)set.put((Object)elements[i]);
            Assertions.assertThat((Object)element).isNull();
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            element = (TestElement)iter.next();
            Assertions.assertThat((boolean)set.contains((Object)element)).isTrue();
            iter.remove();
            Assertions.assertThat((boolean)set.contains((Object)element)).isFalse();
        }
        for (int i2 = 0; i2 < elements.length; ++i2) {
            Assertions.assertThat((boolean)set.contains((Object)elements[i2])).isFalse();
        }
        Assertions.assertThat((boolean)set.iterator().hasNext()).isFalse();
        Assertions.assertThat((int)set.size()).isZero();
    }

    private static class TestElement
    extends TestKey
    implements LightWeightGSet.LinkedElement {
        private final long data;
        private LightWeightGSet.LinkedElement next;

        TestElement(long key, long data) {
            super(key);
            this.data = data;
        }

        TestElement(TestKey key, long data) {
            super(key);
            this.data = data;
        }

        long getData() {
            return this.data;
        }

        public void setNext(LightWeightGSet.LinkedElement next) {
            this.next = next;
        }

        public LightWeightGSet.LinkedElement getNext() {
            return this.next;
        }
    }

    private static class TestKey {
        private final long key;

        TestKey(long key) {
            this.key = key;
        }

        TestKey(TestKey other) {
            this.key = other.key;
        }

        long getKey() {
            return this.key;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestKey)) {
                return false;
            }
            TestKey other = (TestKey)o;
            return this.key == other.key;
        }
    }
}

