/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.GSetByHashMap;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.LightWeightResizableGSet;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGSet {
    private static final Random ran = new Random();
    private static final long starttime = Time.now();

    private static void print(Object s) {
        System.out.print(s);
        System.out.flush();
    }

    private static void println(Object s) {
        System.out.println(s);
    }

    @Test
    public void testExceptionCases() {
        this.testExceptionCases(false);
        this.testExceptionCases(true);
    }

    private void testExceptionCases(boolean resizable) {
        LightWeightGSet<Integer, Integer> gset = TestGSet.createGSet(16, resizable);
        try {
            gset.contains(null);
            Assertions.fail();
        }
        catch (NullPointerException e) {
            LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
        }
        gset = TestGSet.createGSet(16, resizable);
        try {
            gset.get(null);
            Assertions.fail();
        }
        catch (NullPointerException e) {
            LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
        }
        gset = TestGSet.createGSet(16, resizable);
        try {
            gset.put(null);
            Assertions.fail();
        }
        catch (NullPointerException e) {
            LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
        }
        try {
            gset.put((Object)1);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
        }
        IntElement[] data = new IntElement[5];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new IntElement(i, i);
        }
        for (int v = 1; v < data.length - 1; ++v) {
            GSet<IntElement, IntElement> gset2 = TestGSet.createGSet(data, resizable);
            for (IntElement i : gset2) {
                if (i.value != v) continue;
                gset2.remove((Object)data[0]);
            }
            try {
                for (IntElement i : gset2) {
                    if (i.value != v) continue;
                    gset2.remove((Object)data[1]);
                }
                Assertions.fail();
            }
            catch (ConcurrentModificationException e) {
                LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
            }
            gset2 = TestGSet.createGSet(data, resizable);
            try {
                for (IntElement i : gset2) {
                    if (i.value != v) continue;
                    gset2.put((Object)data[0]);
                }
                Assertions.fail();
            }
            catch (ConcurrentModificationException e) {
                LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
            }
            gset2 = TestGSet.createGSet(data, resizable);
            try {
                for (IntElement i : gset2) {
                    if (i.value != v) continue;
                    gset2.put((Object)data[3]);
                }
                Assertions.fail();
                continue;
            }
            catch (ConcurrentModificationException e) {
                LightWeightGSet.LOG.info("GOOD: getting " + e, (Throwable)e);
            }
        }
    }

    private static LightWeightGSet<Integer, Integer> createGSet(int size, boolean resizable) {
        return resizable ? new LightWeightResizableGSet(size) : new LightWeightGSet(size);
    }

    private static GSet<IntElement, IntElement> createGSet(IntElement[] data, boolean resizable) {
        LightWeightResizableGSet gset = resizable ? new LightWeightResizableGSet(8) : new LightWeightGSet(8);
        for (int i = 1; i < data.length; ++i) {
            gset.put((Object)data[i]);
        }
        return gset;
    }

    @Test
    public void testGSet() {
        TestGSet.check(new GSetTestCase(1, 16, 65537));
        TestGSet.check(new GSetTestCase(17, 65536, 17));
        TestGSet.check(new GSetTestCase(255, 1024, 65537));
    }

    @Test
    public void testResizableGSet() {
        TestGSet.check(new GSetTestCase(1, 16, 65537, true));
        TestGSet.check(new GSetTestCase(17, 65536, 17, true));
        TestGSet.check(new GSetTestCase(255, 1024, 65537, true));
    }

    public void runMultipleTestGSet() {
        for (int offset = -2; offset <= 2; ++offset) {
            TestGSet.runTestGSet(1, offset, false);
            for (int i = 1; i < 31; ++i) {
                TestGSet.runTestGSet((1 << i) + 1, offset, false);
            }
        }
    }

    public void runMultipleTestResizableGSet() {
        for (int offset = -2; offset <= 2; ++offset) {
            TestGSet.runTestGSet(1, offset, true);
            for (int i = 1; i < 31; ++i) {
                TestGSet.runTestGSet((1 << i) + 1, offset, true);
            }
        }
    }

    private static void runTestGSet(int modulus, int offset, boolean resizable) {
        TestGSet.println("\n\nmodulus=" + modulus + ", offset=" + offset);
        for (int i = 0; i <= 16; i += 4) {
            int tablelength = (1 << i) + offset;
            int upper = i + 2;
            int steps = Math.max(1, upper / 3);
            for (int j = 0; j <= upper; j += steps) {
                int datasize = 1 << j;
                TestGSet.check(new GSetTestCase(tablelength, datasize, modulus, resizable));
            }
        }
    }

    private static void check(GSetTestCase test) {
        int r;
        int i;
        int j;
        int i2;
        TestGSet.print("  check add .................. ");
        for (i2 = 0; i2 < test.data.size() / 2; ++i2) {
            test.put(test.data.get(i2));
        }
        for (i2 = 0; i2 < test.data.size(); ++i2) {
            test.put(test.data.get(i2));
        }
        TestGSet.println("DONE " + test.stat());
        TestGSet.print("  check remove & add ......... ");
        for (j = 0; j < 10; ++j) {
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.remove(test.data.get(r));
            }
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.put(test.data.get(r));
            }
        }
        TestGSet.println("DONE " + test.stat());
        TestGSet.print("  check remove ............... ");
        for (i2 = 0; i2 < test.data.size(); ++i2) {
            test.remove(test.data.get(i2));
        }
        Assertions.assertEquals((int)0, (int)test.gset.size());
        TestGSet.println("DONE " + test.stat());
        TestGSet.print("  check remove & add again ... ");
        for (j = 0; j < 10; ++j) {
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.remove(test.data.get(r));
            }
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.put(test.data.get(r));
            }
        }
        TestGSet.println("DONE " + test.stat());
        long s = (Time.now() - starttime) / 1000L;
        TestGSet.println("total time elapsed=" + s + "s\n");
    }

    @Test
    public void testComputeCapacityNegativePercent() {
        Assertions.assertThrows(HadoopIllegalArgumentException.class, () -> LightWeightGSet.computeCapacity((long)1024L, (double)-1.0, (String)"testMap"));
    }

    @Test
    public void testComputeCapacityInvalidPercent() {
        Assertions.assertThrows(HadoopIllegalArgumentException.class, () -> LightWeightGSet.computeCapacity((long)1024L, (double)101.0, (String)"testMap"));
    }

    @Test
    public void testComputeCapacityInvalidMemory() {
        Assertions.assertThrows(HadoopIllegalArgumentException.class, () -> LightWeightGSet.computeCapacity((long)-1L, (double)50.0, (String)"testMap"));
    }

    private static boolean isPowerOfTwo(int num) {
        return num == 0 || num > 0 && Integer.bitCount(num) == 1;
    }

    private static int getPercent(long total, int capacity) {
        double referenceSize = System.getProperty("sun.arch.data.model").equals("32") ? 4.0 : 8.0;
        return (int)((double)capacity * referenceSize / (double)total * 100.0);
    }

    private static void testCapacity(long maxMemory, double percent) {
        int capacity = LightWeightGSet.computeCapacity((long)maxMemory, (double)percent, (String)"map");
        LightWeightGSet.LOG.info("Validating - total memory " + maxMemory + " percent " + percent + " returned capacity " + capacity);
        Assertions.assertTrue((boolean)TestGSet.isPowerOfTwo(capacity));
        int capacityPercent = TestGSet.getPercent(maxMemory, capacity);
        if ((double)capacityPercent == percent) {
            return;
        }
        if ((double)capacityPercent > percent) {
            Assertions.assertTrue(((double)TestGSet.getPercent(maxMemory, capacity * 2) > percent ? 1 : 0) != 0);
        } else {
            Assertions.assertTrue(((double)TestGSet.getPercent(maxMemory, capacity / 2) < percent ? 1 : 0) != 0);
        }
    }

    @Test
    public void testComputeCapacity() {
        TestGSet.testCapacity(0L, 0.0);
        TestGSet.testCapacity(100L, 0.0);
        TestGSet.testCapacity(0L, 100.0);
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            long maxMemory = r.nextInt(Integer.MAX_VALUE);
            double percent = r.nextInt(101);
            TestGSet.testCapacity(maxMemory, percent);
        }
    }

    private static class IntElement
    implements LightWeightGSet.LinkedElement,
    Comparable<IntElement> {
        private LightWeightGSet.LinkedElement next;
        final int id;
        final int value;

        IntElement(int id, int value) {
            this.id = id;
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntElement && this.value == ((IntElement)obj).value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public int compareTo(IntElement that) {
            return this.value - that.value;
        }

        public String toString() {
            return this.id + "#" + this.value;
        }

        public LightWeightGSet.LinkedElement getNext() {
            return this.next;
        }

        public void setNext(LightWeightGSet.LinkedElement e) {
            this.next = e;
        }
    }

    private static class GSetTestCase
    implements GSet<IntElement, IntElement> {
        final GSet<IntElement, IntElement> expected = new GSetByHashMap(1024, 0.75f);
        final GSet<IntElement, IntElement> gset;
        final IntData data;
        final String info;
        final long starttime = Time.now();
        final int denominator;
        int iterate_count = 0;
        int contain_count = 0;

        GSetTestCase(int tablelength, int datasize, int modulus) {
            this(tablelength, datasize, modulus, false);
        }

        GSetTestCase(int tablelength, int datasize, int modulus, boolean resizable) {
            this.denominator = Math.min((datasize >> 7) + 1, 65536);
            this.info = this.getClass().getSimpleName() + ": tablelength=" + tablelength + ", datasize=" + datasize + ", modulus=" + modulus + ", denominator=" + this.denominator;
            TestGSet.println(this.info);
            this.data = new IntData(datasize, modulus);
            this.gset = resizable ? new LightWeightResizableGSet() : new LightWeightGSet(tablelength);
            Assertions.assertEquals((int)0, (int)this.gset.size());
        }

        private boolean containsTest(IntElement key) {
            boolean e = this.expected.contains((Object)key);
            Assertions.assertEquals((Object)e, (Object)this.gset.contains((Object)key));
            return e;
        }

        public boolean contains(IntElement key) {
            boolean e = this.containsTest(key);
            this.check();
            return e;
        }

        private IntElement getTest(IntElement key) {
            IntElement e = (IntElement)this.expected.get((Object)key);
            Assertions.assertEquals((int)e.id, (int)((IntElement)this.gset.get((Object)key)).id);
            return e;
        }

        public IntElement get(IntElement key) {
            IntElement e = this.getTest(key);
            this.check();
            return e;
        }

        private IntElement putTest(IntElement element) {
            IntElement e = (IntElement)this.expected.put((Object)element);
            if (e == null) {
                Assertions.assertEquals(null, (Object)this.gset.put((Object)element));
            } else {
                Assertions.assertEquals((int)e.id, (int)((IntElement)this.gset.put((Object)element)).id);
            }
            return e;
        }

        public IntElement put(IntElement element) {
            IntElement e = this.putTest(element);
            this.check();
            return e;
        }

        private IntElement removeTest(IntElement key) {
            IntElement e = (IntElement)this.expected.remove((Object)key);
            if (e == null) {
                Assertions.assertEquals(null, (Object)this.gset.remove((Object)key));
            } else {
                Assertions.assertEquals((int)e.id, (int)((IntElement)this.gset.remove((Object)key)).id);
            }
            return e;
        }

        public IntElement remove(IntElement key) {
            IntElement e = this.removeTest(key);
            this.check();
            return e;
        }

        private int sizeTest() {
            int s = this.expected.size();
            Assertions.assertEquals((int)s, (int)this.gset.size());
            return s;
        }

        public int size() {
            int s = this.sizeTest();
            this.check();
            return s;
        }

        public Iterator<IntElement> iterator() {
            throw new UnsupportedOperationException();
        }

        void check() {
            block6: {
                this.sizeTest();
                if (ran.nextInt(this.denominator) == 0) {
                    ++this.iterate_count;
                    for (IntElement[] i : this.gset) {
                        this.getTest((IntElement)i);
                    }
                }
                if (ran.nextInt(this.denominator) != 0) break block6;
                ++this.contain_count;
                int count = Math.min(this.data.size(), 1000);
                if (count == this.data.size()) {
                    for (IntElement i : this.data.integers) {
                        this.containsTest(i);
                    }
                } else {
                    for (int j = 0; j < count; ++j) {
                        this.containsTest(this.data.get(ran.nextInt(this.data.size())));
                    }
                }
            }
        }

        String stat() {
            long t = Time.now() - this.starttime;
            return String.format(" iterate=%5d, contain=%5d, time elapsed=%5d.%03ds", this.iterate_count, this.contain_count, t / 1000L, t % 1000L);
        }

        public void clear() {
            this.expected.clear();
            this.gset.clear();
            Assertions.assertEquals((int)0, (int)this.size());
        }

        public Collection<IntElement> values() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntData {
        final IntElement[] integers;

        IntData(int size, int modulus) {
            this.integers = new IntElement[size];
            for (int i = 0; i < this.integers.length; ++i) {
                this.integers[i] = new IntElement(i, ran.nextInt(modulus));
            }
        }

        IntElement get(int i) {
            return this.integers[i];
        }

        int size() {
            return this.integers.length;
        }
    }
}

