/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Objects;
import java.util.Random;
import java.util.function.ToIntFunction;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L)
public class TestCrcUtil {
    private static final Random RANDOM = new Random();

    @Test
    public void testComposeCrc32() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 512, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 511, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 32768, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, Short.MAX_VALUE, false);
    }

    @Test
    public void testComposeCrc32c() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 512, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 511, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 32768, false);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, Short.MAX_VALUE, false);
    }

    @Test
    public void testComposeCrc32WithMonomial() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 512, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 511, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, 32768, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32, Short.MAX_VALUE, true);
    }

    @Test
    public void testComposeCrc32cWithMonomial() {
        byte[] data = new byte[65536];
        RANDOM.nextBytes(data);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 512, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 511, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, 32768, true);
        TestCrcUtil.doTestComposeCrc(data, DataChecksum.Type.CRC32C, Short.MAX_VALUE, true);
    }

    @Test
    public void testComposeCrc32ZeroLength() {
        TestCrcUtil.doTestComposeCrcZerolength(DataChecksum.Type.CRC32);
    }

    @Test
    public void testComposeCrc32CZeroLength() {
        TestCrcUtil.doTestComposeCrcZerolength(DataChecksum.Type.CRC32C);
    }

    private static void doTestComposeCrc(byte[] data, DataChecksum.Type type, int chunkSize, boolean useMonomial) {
        int partialCrc;
        ToIntFunction mod = DataChecksum.getModFunction((DataChecksum.Type)type);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)Integer.MAX_VALUE);
        Objects.requireNonNull(checksum, "checksum");
        checksum.update(data, 0, data.length);
        int fullCrc = (int)checksum.getValue();
        int compositeCrc = 0;
        int crcMonomial = useMonomial ? CrcUtil.getMonomial((long)chunkSize, (ToIntFunction)mod) : 0;
        int offset = 0;
        while (offset + chunkSize <= data.length) {
            checksum.reset();
            checksum.update(data, offset, chunkSize);
            partialCrc = (int)checksum.getValue();
            compositeCrc = useMonomial ? CrcUtil.composeWithMonomial((int)compositeCrc, (int)partialCrc, (int)crcMonomial, (ToIntFunction)mod) : CrcUtil.compose((int)compositeCrc, (int)partialCrc, (long)chunkSize, (ToIntFunction)mod);
            offset += chunkSize;
        }
        int partialChunkSize = data.length % chunkSize;
        if (partialChunkSize > 0) {
            checksum.reset();
            checksum.update(data, data.length - partialChunkSize, partialChunkSize);
            partialCrc = (int)checksum.getValue();
            compositeCrc = CrcUtil.compose((int)compositeCrc, (int)partialCrc, (long)partialChunkSize, (ToIntFunction)mod);
        }
        Assertions.assertEquals((int)fullCrc, (int)compositeCrc, (String)String.format("Using CRC type '%s' and chunkSize '%d', expected '0x%08x', got '0x%08x'", type, chunkSize, fullCrc, compositeCrc));
    }

    private static void doTestComposeCrcZerolength(DataChecksum.Type type) {
        int crcA = -889274641;
        ToIntFunction mod = DataChecksum.getModFunction((DataChecksum.Type)type);
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)type, (int)Integer.MAX_VALUE);
        Objects.requireNonNull(checksum, "checksum");
        int crcB = (int)checksum.getValue();
        Assertions.assertEquals((int)crcA, (int)CrcUtil.compose((int)crcA, (int)crcB, (long)0L, (ToIntFunction)mod));
        int monomial = CrcUtil.getMonomial((long)0L, (ToIntFunction)mod);
        Assertions.assertEquals((int)crcA, (int)CrcUtil.composeWithMonomial((int)crcA, (int)crcB, (int)monomial, (ToIntFunction)mod));
    }

    @Test
    public void testIntSerialization() {
        byte[] bytes = CrcUtil.intToBytes((int)-889274641);
        Assertions.assertEquals((int)-889274641, (int)CrcUtil.readInt((byte[])bytes, (int)0));
        bytes = new byte[8];
        CrcUtil.writeInt((byte[])bytes, (int)0, (int)-889274641);
        Assertions.assertEquals((int)-889274641, (int)CrcUtil.readInt((byte[])bytes, (int)0));
        CrcUtil.writeInt((byte[])bytes, (int)4, (int)-1412584499);
        Assertions.assertEquals((int)-1412584499, (int)CrcUtil.readInt((byte[])bytes, (int)4));
        Assertions.assertEquals((int)-1091589171, (int)CrcUtil.readInt((byte[])bytes, (int)2));
    }

    @Test
    public void testToSingleCrcStringBadLength() throws Exception {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "length", () -> CrcUtil.toSingleCrcString((byte[])new byte[8]));
    }

    @Test
    public void testToSingleCrcString() {
        byte[] buf = CrcUtil.intToBytes((int)-889274641);
        Assertions.assertEquals((Object)"0xcafebeef", (Object)CrcUtil.toSingleCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringBadLength() throws Exception {
        LambdaTestUtils.intercept(IllegalArgumentException.class, "length", () -> CrcUtil.toMultiCrcString((byte[])new byte[6]));
    }

    @Test
    public void testToMultiCrcStringMultipleElements() {
        byte[] buf = new byte[12];
        CrcUtil.writeInt((byte[])buf, (int)0, (int)-889274641);
        CrcUtil.writeInt((byte[])buf, (int)4, (int)-1414804276);
        CrcUtil.writeInt((byte[])buf, (int)8, (int)-572657681);
        Assertions.assertEquals((Object)"[0xcafebeef, 0xababcccc, 0xddddefef]", (Object)CrcUtil.toMultiCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringSingleElement() {
        byte[] buf = new byte[4];
        CrcUtil.writeInt((byte[])buf, (int)0, (int)-889274641);
        Assertions.assertEquals((Object)"[0xcafebeef]", (Object)CrcUtil.toMultiCrcString((byte[])buf));
    }

    @Test
    public void testToMultiCrcStringNoElements() {
        Assertions.assertEquals((Object)"[]", (Object)CrcUtil.toMultiCrcString((byte[])new byte[0]));
    }

    @Test
    public void testMultiplyMod() {
        TestCrcUtil.runTestMultiplyMod(10000000, DataChecksum.Type.CRC32);
        TestCrcUtil.runTestMultiplyMod(10000000, DataChecksum.Type.CRC32C);
    }

    private static long[] runTestMultiplyMod(int n, DataChecksum.Type type) {
        System.out.printf("Run %s with %d computations%n", type, n);
        int polynomial = TestCrcUtil.getCrcPolynomialForType(type);
        ToIntFunction mod = DataChecksum.getModFunction((DataChecksum.Type)type);
        int[] p = new int[n];
        int[] q = new int[n];
        for (int i = 0; i < n; ++i) {
            p[i] = RANDOM.nextInt();
            q[i] = RANDOM.nextInt();
        }
        int[] expected = new int[n];
        long[] times = new long[2];
        long t0 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            expected[i] = TestCrcUtil.galoisFieldMultiply(p[i], q[i], polynomial);
        }
        times[0] = System.currentTimeMillis() - t0;
        double ops0 = (double)n * 1000.0 / (double)times[0];
        System.out.printf("galoisFieldMultiply: %.3fs (%.2f ops)%n", (double)times[0] / 1000.0, ops0);
        int[] computed = new int[n];
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            computed[i] = CrcUtil.multiplyMod((int)p[i], (int)q[i], (ToIntFunction)mod);
        }
        times[1] = System.currentTimeMillis() - t1;
        double ops1 = (double)n * 1000.0 / (double)times[1];
        System.out.printf("multiplyCrc32      : %.3fs (%.2f ops)%n", (double)times[1] / 1000.0, ops1);
        System.out.printf("multiplyCrc32 is %.2f%% faster%n", (ops1 - ops0) * 100.0 / ops0);
        for (int i = 0; i < n; ++i) {
            if (expected[i] == computed[i]) continue;
            System.out.printf("expected %08X%n", expected[i]);
            System.out.printf("computed %08X%n", computed[i]);
            throw new IllegalStateException();
        }
        return times;
    }

    private static int getCrcPolynomialForType(DataChecksum.Type type) {
        switch (type) {
            case CRC32: {
                return -306674912;
            }
            case CRC32C: {
                return -2097792136;
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    private static int galoisFieldMultiply(int p, int q, int m) {
        int summation = 0;
        int px = p;
        for (int curTerm = Integer.MIN_VALUE; curTerm != 0; curTerm >>>= 1) {
            if ((q & curTerm) != 0) {
                summation ^= px;
            }
            boolean hasMaxDegree = (px & 1) != 0;
            px >>>= 1;
            if (!hasMaxDegree) continue;
            px ^= m;
        }
        return summation;
    }

    public static class Benchmark {
        public static void main(String[] args) throws Exception {
            int m = args.length >= 1 ? Integer.parseInt(args[0]) : 10;
            int n = args.length >= 2 ? Integer.parseInt(args[1]) : 100000000;
            DataChecksum.Type type = args.length >= 3 ? DataChecksum.Type.valueOf((String)args[2]) : DataChecksum.Type.CRC32;
            int warmUpIterations = 2;
            System.out.printf("%nStart warming up with %d iterations ...%n", 2);
            for (int i = 0; i < 2; ++i) {
                TestCrcUtil.runTestMultiplyMod(n, type);
            }
            System.out.printf("%nStart benchmark with %d iterations ...%n", m);
            long[] times = new long[2];
            for (int i = 0; i < m; ++i) {
                System.out.printf("%d) ", i);
                long[] t = TestCrcUtil.runTestMultiplyMod(n, type);
                times[0] = times[0] + t[0];
                times[1] = times[1] + t[1];
            }
            System.out.printf("%nResult) %d x %d computations:%n", m, n);
            double ops0 = (double)n * 1000.0 / (double)times[0];
            System.out.printf("galoisFieldMultiply: %.3fs (%.2f ops)%n", (double)times[0] / 1000.0, ops0);
            double ops1 = (double)n * 1000.0 / (double)times[1];
            System.out.printf("multiplyCrc32      : %.3fs (%.2f ops)%n", (double)times[1] / 1000.0, ops1);
            System.out.printf("multiplyCrc32 is %.2f%% faster%n", (ops1 - ops0) * 100.0 / ops0);
        }
    }
}

