/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.CrcComposer;
import org.apache.hadoop.util.CrcUtil;
import org.apache.hadoop.util.DataChecksum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=10L)
public class TestCrcComposer {
    private final Random rand = new Random(1234L);
    private final DataChecksum.Type type = DataChecksum.Type.CRC32C;
    private final DataChecksum checksum = Objects.requireNonNull(DataChecksum.newDataChecksum((DataChecksum.Type)this.type, (int)Integer.MAX_VALUE));
    private final int dataSize = 75;
    private final byte[] data = new byte[75];
    private final int chunkSize = 10;
    private final int cellSize = 20;
    private int fullCrc;
    private int[] crcsByChunk;
    private byte[] crcBytesByChunk;
    private byte[] crcBytesByCell;

    @BeforeEach
    public void setup() throws IOException {
        this.rand.nextBytes(this.data);
        this.fullCrc = this.getRangeChecksum(this.data, 0, 75);
        this.crcsByChunk = new int[8];
        for (int i = 0; i < 7; ++i) {
            this.crcsByChunk[i] = this.getRangeChecksum(this.data, i * 10, 10);
        }
        this.crcsByChunk[7] = this.getRangeChecksum(this.data, (this.crcsByChunk.length - 1) * 10, 5);
        int[] crcsByCell = new int[4];
        for (int i = 0; i < 3; ++i) {
            crcsByCell[i] = this.getRangeChecksum(this.data, i * 20, 20);
        }
        crcsByCell[3] = this.getRangeChecksum(this.data, (crcsByCell.length - 1) * 20, 15);
        this.crcBytesByChunk = this.intArrayToByteArray(this.crcsByChunk);
        this.crcBytesByCell = this.intArrayToByteArray(crcsByCell);
    }

    private int getRangeChecksum(byte[] buf, int offset, int length) {
        this.checksum.reset();
        this.checksum.update(buf, offset, length);
        return (int)this.checksum.getValue();
    }

    private byte[] intArrayToByteArray(int[] values) {
        byte[] bytes = new byte[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            CrcUtil.writeInt((byte[])bytes, (int)(i * 4), (int)values[i]);
        }
        return bytes;
    }

    @Test
    public void testUnstripedIncorrectChunkSize() {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)10L);
        digester.update(this.crcBytesByChunk, 0, this.crcBytesByChunk.length, 10L);
        byte[] digest = digester.digest();
        Assertions.assertEquals((int)4, (int)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assertions.assertNotEquals((int)this.fullCrc, (int)calculatedCrc);
    }

    @Test
    public void testUnstripedByteArray() {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)10L);
        digester.update(this.crcBytesByChunk, 0, this.crcBytesByChunk.length - 4, 10L);
        digester.update(this.crcBytesByChunk, this.crcBytesByChunk.length - 4, 4, 5L);
        byte[] digest = digester.digest();
        Assertions.assertEquals((int)4, (int)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assertions.assertEquals((int)this.fullCrc, (int)calculatedCrc);
    }

    @Test
    public void testUnstripedDataInputStream() throws IOException {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)10L);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.crcBytesByChunk));
        digester.update(input, (long)(this.crcsByChunk.length - 1), 10L);
        digester.update(input, 1L, 5L);
        byte[] digest = digester.digest();
        Assertions.assertEquals((int)4, (int)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assertions.assertEquals((int)this.fullCrc, (int)calculatedCrc);
    }

    @Test
    public void testUnstripedSingleCrcs() {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)10L);
        for (int i = 0; i < this.crcsByChunk.length - 1; ++i) {
            digester.update(this.crcsByChunk[i], 10L);
        }
        digester.update(this.crcsByChunk[this.crcsByChunk.length - 1], 5L);
        byte[] digest = digester.digest();
        Assertions.assertEquals((int)4, (int)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assertions.assertEquals((int)this.fullCrc, (int)calculatedCrc);
    }

    @Test
    public void testStripedByteArray() {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)10L, (long)20L);
        digester.update(this.crcBytesByChunk, 0, this.crcBytesByChunk.length - 4, 10L);
        digester.update(this.crcBytesByChunk, this.crcBytesByChunk.length - 4, 4, 5L);
        byte[] digest = digester.digest();
        Assertions.assertArrayEquals((byte[])this.crcBytesByCell, (byte[])digest);
    }

    @Test
    public void testStripedDataInputStream() throws IOException {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)10L, (long)20L);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.crcBytesByChunk));
        digester.update(input, (long)(this.crcsByChunk.length - 1), 10L);
        digester.update(input, 1L, 5L);
        byte[] digest = digester.digest();
        Assertions.assertArrayEquals((byte[])this.crcBytesByCell, (byte[])digest);
    }

    @Test
    public void testStripedSingleCrcs() {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)10L, (long)20L);
        for (int i = 0; i < this.crcsByChunk.length - 1; ++i) {
            digester.update(this.crcsByChunk[i], 10L);
        }
        digester.update(this.crcsByChunk[this.crcsByChunk.length - 1], 5L);
        byte[] digest = digester.digest();
        Assertions.assertArrayEquals((byte[])this.crcBytesByCell, (byte[])digest);
    }

    @Test
    public void testMultiStageMixed() throws IOException {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)10L, (long)20L);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.crcBytesByChunk));
        digester.update(input, (long)(this.crcsByChunk.length - 1), 10L);
        digester.update(input, 1L, 5L);
        byte[] digest = digester.digest();
        digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)20L);
        for (int i = 0; i < digest.length - 4; i += 4) {
            int cellCrc = CrcUtil.readInt((byte[])digest, (int)i);
            digester.update(cellCrc, 20L);
        }
        digester.update(digest, digest.length - 4, 4, 15L);
        digest = digester.digest();
        Assertions.assertEquals((int)4, (int)digest.length);
        int calculatedCrc = CrcUtil.readInt((byte[])digest, (int)0);
        Assertions.assertEquals((int)this.fullCrc, (int)calculatedCrc);
    }

    @Test
    public void testUpdateMismatchesStripe() throws Exception {
        CrcComposer digester = CrcComposer.newStripedCrcComposer((DataChecksum.Type)this.type, (long)10L, (long)20L);
        digester.update(this.crcsByChunk[0], 10L);
        LambdaTestUtils.intercept(IllegalStateException.class, "stripe", () -> digester.update(this.crcsByChunk[1], 20L));
    }

    @Test
    public void testUpdateByteArrayLengthUnalignedWithCrcSize() throws Exception {
        CrcComposer digester = CrcComposer.newCrcComposer((DataChecksum.Type)this.type, (long)10L);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "length", () -> digester.update(this.crcBytesByChunk, 0, 6, 10L));
    }
}

