/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import org.apache.hadoop.service.launcher.AbstractServiceLauncherTestBase;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.apache.hadoop.service.launcher.ServiceLauncher;
import org.apache.hadoop.util.ExitCodeProvider;
import org.junit.jupiter.api.Test;

public class TestServiceLauncherCreationFailures
extends AbstractServiceLauncherTestBase {
    public static final String SELF = "org.apache.hadoop.service.launcher.TestServiceLauncherCreationFailures";

    @Test
    public void testNoArgs() throws Throwable {
        try {
            ServiceLauncher.serviceMain((String[])new String[0]);
        }
        catch (ServiceLaunchException e) {
            this.assertExceptionDetails(42, "", (ExitCodeProvider)e);
        }
    }

    @Test
    public void testUnknownClass() throws Throwable {
        this.assertServiceCreationFails("no.such.classname");
    }

    @Test
    public void testNotAService() throws Throwable {
        this.assertServiceCreationFails(SELF);
    }

    @Test
    public void testNoSimpleConstructor() throws Throwable {
        this.assertServiceCreationFails("org.apache.hadoop.service.launcher.FailureTestService");
    }

    @Test
    public void testFailInConstructor() throws Throwable {
        this.assertServiceCreationFails("org.apache.hadoop.service.launcher.testservices.FailInConstructorService");
    }

    @Test
    public void testFailInInit() throws Throwable {
        this.assertLaunchOutcome(-1, "", "org.apache.hadoop.service.launcher.testservices.FailInInitService");
    }

    @Test
    public void testFailInStart() throws Throwable {
        this.assertLaunchOutcome(-2, "", "org.apache.hadoop.service.launcher.testservices.FailInStartService");
    }

    @Test
    public void testFailInStopIsIgnored() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.FailingStopInStartService");
    }
}

