/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.launcher.AbstractServiceLauncherTestBase;
import org.apache.hadoop.service.launcher.ServiceLaunchException;
import org.apache.hadoop.service.launcher.ServiceShutdownHook;
import org.apache.hadoop.service.launcher.testservices.FailingStopInStartService;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Test;

public class TestServiceLauncher
extends AbstractServiceLauncherTestBase {
    @Test
    public void testRunService() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.RunningService");
    }

    @Test
    public void testNullBindService() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.NullBindLaunchableService");
    }

    @Test
    public void testServiceLaunchStringConstructor() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.StringConstructorOnlyService");
    }

    @Test
    public void testStopInStartup() throws Throwable {
        FailingStopInStartService svc = new FailingStopInStartService();
        svc.init(new Configuration());
        svc.start();
        this.assertStopped((Service)svc);
        Throwable cause = svc.getFailureCause();
        TestServiceLauncher.assertNotNull((Object)cause);
        TestServiceLauncher.assertTrue((boolean)(cause instanceof ServiceLaunchException));
        TestServiceLauncher.assertTrue((boolean)svc.waitForServiceToStop(0L));
        ServiceLaunchException e = (ServiceLaunchException)cause;
        TestServiceLauncher.assertEquals((int)-4, (int)e.getExitCode());
    }

    @Test
    public void testEx() throws Throwable {
        this.assertLaunchOutcome(50, "Other exception", "org.apache.hadoop.service.launcher.testservices.ExceptionInExecuteLaunchableService");
    }

    @Test
    public void testServiceLaunchException() throws Throwable {
        this.assertLaunchOutcome(5, "SLE raised in execute()", "org.apache.hadoop.service.launcher.testservices.ExceptionInExecuteLaunchableService", "--SLE");
    }

    @Test
    public void testIOE() throws Throwable {
        this.assertLaunchOutcome(64, "Exit in IOE", "org.apache.hadoop.service.launcher.testservices.ExceptionInExecuteLaunchableService", "--IOE");
    }

    @Test
    public void testThrowable() throws Throwable {
        this.assertLaunchOutcome(50, "java.lang.OutOfMemoryError", "org.apache.hadoop.service.launcher.testservices.ExceptionInExecuteLaunchableService", "--throwable");
    }

    @Test
    public void testBasicExceptionFormatting() throws Throwable {
        ServiceLaunchException ex = new ServiceLaunchException(0, "%03x", new Object[]{32});
        GenericTestUtils.assertExceptionContains("020", ex);
    }

    @Test
    public void testNotEnoughArgsExceptionFormatting() throws Throwable {
        ServiceLaunchException ex = new ServiceLaunchException(0, "%03x");
        GenericTestUtils.assertExceptionContains("%03x", ex);
    }

    @Test
    public void testInnerCause() throws Throwable {
        Exception cause = new Exception("cause");
        ServiceLaunchException ex = new ServiceLaunchException(0, "%03x: %s", new Object[]{32, cause});
        GenericTestUtils.assertExceptionContains("020", ex);
        GenericTestUtils.assertExceptionContains("cause", ex);
        TestServiceLauncher.assertSame((Object)cause, (Object)ex.getCause());
    }

    @Test
    public void testInnerCauseNotInFormat() throws Throwable {
        Exception cause = new Exception("cause");
        ServiceLaunchException ex = new ServiceLaunchException(0, "%03x:", new Object[]{32, cause});
        GenericTestUtils.assertExceptionContains("020", ex);
        TestServiceLauncher.assertFalse((boolean)ex.getMessage().contains("cause"));
        TestServiceLauncher.assertSame((Object)cause, (Object)ex.getCause());
    }

    @Test
    public void testServiceInitInConstructor() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.InitInConstructorLaunchableService");
    }

    @Test
    public void testRunNoArgsAllowedService() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.NoArgsAllowedService");
    }

    @Test
    public void testNoArgsOneArg() throws Throwable {
        this.assertLaunchOutcome(40, "1", "org.apache.hadoop.service.launcher.testservices.NoArgsAllowedService", "one");
    }

    @Test
    public void testNoArgsHasConfsStripped() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.NoArgsAllowedService", "--conf", this.configFile(this.newConf(new String[0])));
    }

    @Test
    public void testRunLaunchableService() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.LaunchableRunningService");
    }

    @Test
    public void testArgBinding() throws Throwable {
        this.assertLaunchOutcome(5, "", "org.apache.hadoop.service.launcher.testservices.LaunchableRunningService", "--failing");
    }

    @Test
    public void testStoppingInStartLaunchableService() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.StoppingInStartLaunchableService");
    }

    @Test
    public void testShutdownHookNullReference() throws Throwable {
        new ServiceShutdownHook(null).run();
    }

    @Test
    public void testShutdownHook() throws Throwable {
        BreakableService service = new BreakableService();
        this.setServiceToTeardown((Service)service);
        ServiceShutdownHook hook = new ServiceShutdownHook((Service)service);
        hook.run();
        this.assertStopped((Service)service);
    }

    @Test
    public void testFailingHookCaught() throws Throwable {
        BreakableService service = new BreakableService(false, false, true);
        this.setServiceToTeardown((Service)service);
        ServiceShutdownHook hook = new ServiceShutdownHook((Service)service);
        hook.run();
        this.assertStopped((Service)service);
    }
}

