/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.launcher.AbstractServiceLauncherTestBase;
import org.apache.hadoop.service.launcher.ExitTrackingServiceLauncher;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class TestServiceConf
extends AbstractServiceLauncherTestBase {
    @Test
    public void testRunService() throws Throwable {
        this.assertRuns("org.apache.hadoop.service.launcher.testservices.LaunchableRunningService");
    }

    @Test
    public void testConfPropagationOverInitBindings() throws Throwable {
        Configuration conf = this.newConf("fail.runnable", "true");
        this.assertLaunchOutcome(-1, "failed", "org.apache.hadoop.service.launcher.testservices.LaunchableRunningService", "--conf", this.configFile(conf));
    }

    @Test
    public void testUnbalancedConfArg() throws Throwable {
        this.assertLaunchOutcome(40, "Failed to parse: ", "org.apache.hadoop.service.launcher.testservices.LaunchableRunningService", "--conf");
    }

    @Test
    public void testConfArgMissingFile() throws Throwable {
        this.assertLaunchOutcome(40, "Failed to parse: ", "org.apache.hadoop.service.launcher.testservices.LaunchableRunningService", "--conf", "no-file.xml");
    }

    @Test
    public void testConfPropagation() throws Throwable {
        Configuration conf = this.newConf("fail.runnable", "true");
        this.assertLaunchOutcome(50, "FAIL_IN_RUN", "org.apache.hadoop.service.launcher.testservices.RunningService", "--conf", this.configFile(conf));
    }

    @Test
    public void testConfExtraction() throws Throwable {
        ExitTrackingServiceLauncher launcher = new ExitTrackingServiceLauncher("org.apache.hadoop.service.launcher.testservices.RunningService");
        launcher.bindCommandOptions();
        Configuration conf = this.newConf("propagated", "true");
        TestServiceConf.assertEquals((Object)"true", (Object)conf.get("propagated", "unset"));
        Configuration extracted = new Configuration(false);
        List<String> argsList = this.asList("Name", "--conf", this.configFile(conf));
        List args = launcher.extractCommandOptions(extracted, argsList);
        if (!args.isEmpty()) {
            TestServiceConf.assertEquals((int)0, (int)args.size(), (String)("args beginning with " + (String)args.get(0)));
        }
        TestServiceConf.assertEquals((Object)"true", (Object)extracted.get("propagated", "unset"));
    }

    @Test
    public void testDualConfArgs() throws Throwable {
        ExitTrackingServiceLauncher launcher = new ExitTrackingServiceLauncher("org.apache.hadoop.service.launcher.testservices.RunningService");
        launcher.bindCommandOptions();
        String key1 = "key1";
        Configuration conf1 = this.newConf(key1, "true");
        String key2 = "file2";
        Configuration conf2 = this.newConf(key2, "7");
        Configuration extracted = new Configuration(false);
        List<String> argsList = this.asList("Name", "--conf", this.configFile(conf1), "--conf", this.configFile(conf2));
        List args = launcher.extractCommandOptions(extracted, argsList);
        if (!args.isEmpty()) {
            TestServiceConf.assertEquals((int)0, (int)args.size(), (String)("args beginning with " + (String)args.get(0)));
        }
        TestServiceConf.assertTrue((boolean)extracted.getBoolean(key1, false));
        TestServiceConf.assertEquals((int)7, (int)extracted.getInt(key2, -1));
    }

    @Test
    public void testConfArgWrongFiletype(TestInfo testInfo) throws Throwable {
        new File("target/launcher/conf").mkdirs();
        File file = new File("target/launcher/conf", testInfo.getDisplayName());
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write("not-a-conf-file");
            fileWriter.close();
        }
        this.assertLaunchOutcome(40, "", "org.apache.hadoop.service.launcher.testservices.RunningService", "--conf", file.getAbsolutePath());
    }
}

