/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.BreakableService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompositeService {
    private static final int NUM_OF_SERVICES = 5;
    private static final int FAILED_SERVICE_SEQ_NUMBER = 2;
    private static final Logger LOG = LoggerFactory.getLogger(TestCompositeService.class);
    private static final boolean STOP_ONLY_STARTED_SERVICES = CompositeServiceImpl.isPolicyToStopOnlyStartedServices();

    @BeforeEach
    public void setup() {
        CompositeServiceImpl.resetCounter();
    }

    @Test
    public void testCallSequence() {
        int i;
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i2 = 0; i2 < 5; ++i2) {
            CompositeServiceImpl service = new CompositeServiceImpl(i2);
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Assertions.assertEquals((int)5, (int)services.length, (String)"Number of registered services ");
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        this.assertInState(Service.STATE.INITED, services);
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)i, (int)services[i].getCallSequenceNumber(), (String)("For " + services[i] + " service, init() call sequence number should have been "));
        }
        this.resetServices(services);
        serviceManager.start();
        this.assertInState(Service.STATE.STARTED, services);
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)i, (int)services[i].getCallSequenceNumber(), (String)("For " + services[i] + " service, start() call sequence number should have been "));
        }
        this.resetServices(services);
        serviceManager.stop();
        this.assertInState(Service.STATE.STOPPED, services);
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)(4 - i), (int)services[i].getCallSequenceNumber(), (String)("For " + services[i] + " service, stop() call sequence number should have been "));
        }
        serviceManager.stop();
        for (i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)(4 - i), (int)services[i].getCallSequenceNumber(), (String)("For " + services[i] + " service, stop() call sequence number should have been "));
        }
    }

    private void resetServices(CompositeServiceImpl[] services) {
        for (int i = 0; i < 5; ++i) {
            services[i].reset();
        }
    }

    @Test
    public void testServiceStartup() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            if (i == 2) {
                service.setThrowExceptionOnStart(true);
            }
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        try {
            serviceManager.start();
            Assertions.fail((String)"Exception should have been thrown due to startup failure of last service");
        }
        catch (ServiceTestRuntimeException e) {
            for (int i = 0; i < 4; ++i) {
                if (i >= 2 && STOP_ONLY_STARTED_SERVICES) {
                    Assertions.assertEquals((Object)Service.STATE.INITED, (Object)services[4].getServiceState(), (String)"Service state should have been ");
                    continue;
                }
                Assertions.assertEquals((Object)Service.STATE.STOPPED, (Object)services[i].getServiceState(), (String)"Service state should have been ");
            }
        }
    }

    @Test
    public void testServiceStop() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            if (i == 2) {
                service.setThrowExceptionOnStop(true);
            }
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        Configuration conf = new Configuration();
        serviceManager.init(conf);
        serviceManager.start();
        try {
            serviceManager.stop();
        }
        catch (ServiceTestRuntimeException serviceTestRuntimeException) {
            // empty catch block
        }
        this.assertInState(Service.STATE.STOPPED, services);
    }

    private void assertInState(Service.STATE expected, CompositeServiceImpl[] services) {
        this.assertInState(expected, services, 0, services.length);
    }

    private void assertInState(Service.STATE expected, CompositeServiceImpl[] services, int start, int finish) {
        for (int i = start; i < finish; ++i) {
            CompositeServiceImpl service = services[i];
            this.assertInState(expected, (Service)service);
        }
    }

    private void assertInState(Service.STATE expected, Service service) {
        Assertions.assertEquals((Object)expected, (Object)service.getServiceState(), (String)("Service state should have been " + expected + " in " + service));
    }

    @Test
    public void testServiceStopFromNotInited() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        serviceManager.stop();
        this.assertInState(Service.STATE.NOTINITED, services);
    }

    @Test
    public void testServiceStopFromInited() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        for (int i = 0; i < 5; ++i) {
            CompositeServiceImpl service = new CompositeServiceImpl(i);
            serviceManager.addTestService(service);
        }
        CompositeServiceImpl[] services = serviceManager.getServices().toArray(new CompositeServiceImpl[0]);
        serviceManager.init(new Configuration());
        serviceManager.stop();
        if (STOP_ONLY_STARTED_SERVICES) {
            this.assertInState(Service.STATE.INITED, services);
        } else {
            this.assertInState(Service.STATE.STOPPED, services);
        }
    }

    @Test
    public void testInitNullConf() throws Throwable {
        ServiceManager serviceManager = new ServiceManager("testInitNullConf");
        CompositeServiceImpl service = new CompositeServiceImpl(0);
        serviceManager.addTestService(service);
        try {
            serviceManager.init(null);
            LOG.warn("Null Configurations are permitted " + serviceManager);
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
    }

    @Test
    public void testServiceLifecycleNoChildren() {
        ServiceManager serviceManager = new ServiceManager("ServiceManager");
        serviceManager.init(new Configuration());
        serviceManager.start();
        serviceManager.stop();
    }

    @Test
    public void testAddServiceInInit() throws Throwable {
        BreakableService child = new BreakableService();
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
        CompositeServiceAddingAChild composite = new CompositeServiceAddingAChild((Service)child);
        composite.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddIfService() {
        CompositeService testService = new CompositeService("TestService"){
            Service service;

            public void serviceInit(Configuration conf) {
                Integer notAService = new Integer(0);
                Assertions.assertFalse((boolean)this.addIfService(notAService), (String)"Added an integer as a service");
                this.service = new AbstractService("Service"){};
                Assertions.assertTrue((boolean)this.addIfService(this.service), (String)"Unable to add a service");
            }
        };
        testService.init(new Configuration());
        Assertions.assertEquals((int)1, (int)testService.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    public void testRemoveService() {
        CompositeService testService = new CompositeService("TestService"){

            public void serviceInit(Configuration conf) {
                Integer notAService = new Integer(0);
                Assertions.assertFalse((boolean)this.addIfService(notAService), (String)"Added an integer as a service");
                AbstractService service1 = new AbstractService("Service1"){};
                this.addIfService(service1);
                AbstractService service2 = new AbstractService("Service2"){};
                this.addIfService(service2);
                AbstractService service3 = new AbstractService("Service3"){};
                this.addIfService(service3);
                this.removeService((Service)service1);
            }
        };
        testService.init(new Configuration());
        Assertions.assertEquals((int)2, (int)testService.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedChildBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        AddSiblingService.addChildToService(parent, (Service)child);
        parent.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)child);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedChildInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        parent.init(new Configuration());
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
        try {
            parent.start();
            Assertions.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedChildInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        parent.init(new Configuration());
        parent.start();
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedChildInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.NOTINITED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedChildBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        AddSiblingService.addChildToService(parent, (Service)child);
        parent.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)child);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedChildInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        parent.init(new Configuration());
        AddSiblingService.addChildToService(parent, (Service)child);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedChildInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        parent.init(new Configuration());
        parent.start();
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.INITED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedChildInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.INITED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedChildBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        AddSiblingService.addChildToService(parent, (Service)child);
        try {
            parent.init(new Configuration());
            Assertions.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedChildInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        parent.init(new Configuration());
        AddSiblingService.addChildToService(parent, (Service)child);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedChildInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        parent.init(new Configuration());
        parent.start();
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.STARTED, (Service)child);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedChildInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        AddSiblingService.addChildToService(parent, (Service)child);
        this.assertInState(Service.STATE.STARTED, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedChildBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        child.stop();
        AddSiblingService.addChildToService(parent, (Service)child);
        try {
            parent.init(new Configuration());
            Assertions.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedChildInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        child.stop();
        parent.init(new Configuration());
        AddSiblingService.addChildToService(parent, (Service)child);
        try {
            parent.start();
            Assertions.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        this.assertInState(Service.STATE.STOPPED, (Service)child);
        parent.stop();
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedChildInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        child.stop();
        parent.init(new Configuration());
        parent.start();
        AddSiblingService.addChildToService(parent, (Service)child);
        parent.stop();
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedChildInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService child = new BreakableService();
        child.init(new Configuration());
        child.start();
        child.stop();
        parent.init(new Configuration());
        parent.start();
        parent.stop();
        AddSiblingService.addChildToService(parent, (Service)child);
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedSiblingBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.NOTINITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        try {
            parent.start();
            Assertions.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedSiblingInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STARTED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddUninitedSiblingInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STOPPED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.NOTINITED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedSiblingBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.NOTINITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.INITED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.INITED, (Service)sibling);
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedSiblingInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STARTED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.INITED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.INITED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddInitedSiblingInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STOPPED));
        parent.init(new Configuration());
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedSiblingBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.NOTINITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedSiblingInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STARTED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStartedSiblingInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STOPPED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STARTED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedSiblingBeforeInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        sibling.stop();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.NOTINITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)1, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedSiblingInInit() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        sibling.stop();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.INITED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        try {
            parent.start();
            Assertions.fail((String)("Expected an exception, got " + parent));
        }
        catch (ServiceStateException serviceStateException) {
            // empty catch block
        }
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedSiblingInStart() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        sibling.stop();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STARTED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    @Test
    @Timeout(value=10L)
    public void testAddStoppedSiblingInStop() throws Throwable {
        CompositeService parent = new CompositeService("parent");
        BreakableService sibling = new BreakableService();
        sibling.init(new Configuration());
        sibling.start();
        sibling.stop();
        parent.addService((Service)new AddSiblingService(parent, (Service)sibling, Service.STATE.STOPPED));
        parent.init(new Configuration());
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        parent.start();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        parent.stop();
        this.assertInState(Service.STATE.STOPPED, (Service)sibling);
        Assertions.assertEquals((int)2, (int)parent.getServices().size(), (String)"Incorrect number of services");
    }

    public static class CompositeServiceImpl
    extends CompositeService {
        private static int counter = -1;
        private int callSequenceNumber = -1;
        private boolean throwExceptionOnStart;
        private boolean throwExceptionOnStop;

        public static boolean isPolicyToStopOnlyStartedServices() {
            return false;
        }

        public CompositeServiceImpl(int sequenceNumber) {
            super(Integer.toString(sequenceNumber));
        }

        protected void serviceInit(Configuration conf) throws Exception {
            this.callSequenceNumber = ++counter;
            super.serviceInit(conf);
        }

        protected void serviceStart() throws Exception {
            if (this.throwExceptionOnStart) {
                throw new ServiceTestRuntimeException("Fake service start exception");
            }
            this.callSequenceNumber = ++counter;
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            this.callSequenceNumber = ++counter;
            if (this.throwExceptionOnStop) {
                throw new ServiceTestRuntimeException("Fake service stop exception");
            }
            super.serviceStop();
        }

        public static int getCounter() {
            return counter;
        }

        public int getCallSequenceNumber() {
            return this.callSequenceNumber;
        }

        public void reset() {
            this.callSequenceNumber = -1;
            counter = -1;
        }

        public static void resetCounter() {
            counter = -1;
        }

        public void setThrowExceptionOnStart(boolean throwExceptionOnStart) {
            this.throwExceptionOnStart = throwExceptionOnStart;
        }

        public void setThrowExceptionOnStop(boolean throwExceptionOnStop) {
            this.throwExceptionOnStop = throwExceptionOnStop;
        }

        public String toString() {
            return "Service " + this.getName();
        }
    }

    public static class ServiceManager
    extends CompositeService {
        public void addTestService(CompositeService service) {
            this.addService((Service)service);
        }

        public ServiceManager(String name) {
            super(name);
        }
    }

    public static class ServiceTestRuntimeException
    extends RuntimeException {
        public ServiceTestRuntimeException(String message) {
            super(message);
        }
    }

    public static class CompositeServiceAddingAChild
    extends CompositeService {
        Service child;

        public CompositeServiceAddingAChild(Service child) {
            super("CompositeServiceAddingAChild");
            this.child = child;
        }

        protected void serviceInit(Configuration conf) throws Exception {
            this.addService(this.child);
            super.serviceInit(conf);
        }
    }

    public static class AddSiblingService
    extends CompositeService {
        private final CompositeService parent;
        private final Service serviceToAdd;
        private Service.STATE triggerState;

        public AddSiblingService(CompositeService parent, Service serviceToAdd, Service.STATE triggerState) {
            super("ParentStateManipulatorService");
            this.parent = parent;
            this.serviceToAdd = serviceToAdd;
            this.triggerState = triggerState;
        }

        private void maybeAddSibling() {
            if (this.getServiceState() == this.triggerState) {
                this.parent.addService(this.serviceToAdd);
            }
        }

        protected void serviceInit(Configuration conf) throws Exception {
            this.maybeAddSibling();
            super.serviceInit(conf);
        }

        protected void serviceStart() throws Exception {
            this.maybeAddSibling();
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            this.maybeAddSibling();
            super.serviceStop();
        }

        public static void addChildToService(CompositeService parent, Service child) {
            parent.addService(child);
        }
    }
}

