/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginContext;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationFilter;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.hadoop.test.GenericTestUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;

public class TestWebDelegationToken {
    private static final String OK_USER = "ok-user";
    private static final String FAIL_USER = "fail-user";
    private static final String FOO_USER = "foo";
    private Server jetty;

    protected Server createJettyServer() {
        try {
            this.jetty = new Server(0);
            ((ServerConnector)this.jetty.getConnectors()[0]).setHost("localhost");
            return this.jetty;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not setup Jetty: " + ex.getMessage(), ex);
        }
    }

    protected String getJettyURL() {
        ServerConnector c = (ServerConnector)this.jetty.getConnectors()[0];
        return "http://" + c.getHost() + ":" + c.getLocalPort();
    }

    @BeforeEach
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.jetty = this.createJettyServer();
        GenericTestUtils.setLogLevel(KerberosAuthenticationHandler.LOG, Level.TRACE);
    }

    @AfterEach
    public void cleanUp() throws Exception {
        this.jetty.stop();
        Configuration conf = new Configuration();
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    protected Server getJetty() {
        return this.jetty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRawHttpCalls() throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(AFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(PingServlet.class), "/bar");
        try {
            jetty.start();
            URL nonAuthURL = new URL(this.getJettyURL() + "/foo/bar");
            URL authURL = new URL(this.getJettyURL() + "/foo/bar?authenticated=foo");
            HttpURLConnection conn = (HttpURLConnection)nonAuthURL.openConnection();
            Assertions.assertEquals((int)401, (int)conn.getResponseCode());
            conn = (HttpURLConnection)authURL.openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            URL url = new URL(nonAuthURL.toExternalForm() + "?op=GETDELEGATIONTOKEN");
            conn = (HttpURLConnection)url.openConnection();
            Assertions.assertEquals((int)401, (int)conn.getResponseCode());
            url = new URL(authURL.toExternalForm() + "&op=GETDELEGATIONTOKEN&renewer=foo");
            conn = (HttpURLConnection)url.openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(conn.getInputStream(), Map.class);
            String dt = (String)((Map)map.get("Token")).get("urlString");
            Assertions.assertNotNull((Object)dt);
            url = new URL(nonAuthURL.toExternalForm() + "?delegation=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            url = new URL(authURL.toExternalForm() + "&delegation=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            url = new URL(nonAuthURL.toExternalForm() + "?op=RENEWDELEGATIONTOKEN&token=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)401, (int)conn.getResponseCode());
            url = new URL(authURL.toExternalForm() + "&op=RENEWDELEGATIONTOKEN&token=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            url = new URL(this.getJettyURL() + "/foo/bar?authenticated=bar&op=RENEWDELEGATIONTOKEN&token=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)403, (int)conn.getResponseCode());
            url = new URL(nonAuthURL.toExternalForm() + "?op=CANCELDELEGATIONTOKEN&token=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            url = new URL(nonAuthURL.toExternalForm() + "?op=CANCELDELEGATIONTOKEN&token=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)404, (int)conn.getResponseCode());
            url = new URL(authURL.toExternalForm() + "&op=GETDELEGATIONTOKEN&renewer=foo");
            conn = (HttpURLConnection)url.openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            mapper = new ObjectMapper();
            map = (Map)mapper.readValue(conn.getInputStream(), Map.class);
            dt = (String)((Map)map.get("Token")).get("urlString");
            Assertions.assertNotNull((Object)dt);
            url = new URL(authURL.toExternalForm() + "&op=CANCELDELEGATIONTOKEN&token=" + dt);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("PUT");
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
        }
        finally {
            jetty.stop();
        }
    }

    @Test
    public void testDelegationTokenAuthenticatorCallsWithHeader() throws Exception {
        this.testDelegationTokenAuthenticatorCalls(false);
    }

    @Test
    public void testDelegationTokenAuthenticatorCallsWithQueryString() throws Exception {
        this.testDelegationTokenAuthenticatorCalls(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDelegationTokenAuthenticatorCalls(final boolean useQS) throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(AFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(PingServlet.class), "/bar");
        try {
            jetty.start();
            final URL nonAuthURL = new URL(this.getJettyURL() + "/foo/bar");
            URL authURL = new URL(this.getJettyURL() + "/foo/bar?authenticated=foo");
            URL authURL2 = new URL(this.getJettyURL() + "/foo/bar?authenticated=bar");
            DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
            final DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
            aUrl.setUseQueryStringForDelegationToken(useQS);
            try {
                aUrl.getDelegationToken(nonAuthURL, token, FOO_USER);
                Assertions.fail();
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getCause().getMessage().contains("401"));
            }
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            Assertions.assertNotNull((Object)token.getDelegationToken());
            Assertions.assertEquals((Object)new Text("token-kind"), (Object)token.getDelegationToken().getKind());
            aUrl.renewDelegationToken(authURL, token);
            try {
                aUrl.renewDelegationToken(nonAuthURL, token);
                Assertions.fail();
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getMessage().contains("401"));
            }
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            try {
                aUrl.renewDelegationToken(authURL2, token);
                Assertions.fail();
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getMessage().contains("403"));
            }
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            aUrl.cancelDelegationToken(authURL, token);
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            aUrl.cancelDelegationToken(nonAuthURL, token);
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            try {
                aUrl.renewDelegationToken(nonAuthURL, token);
            }
            catch (Exception ex) {
                Assertions.assertTrue((boolean)ex.getMessage().contains("401"));
            }
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            ugi.addToken(token.getDelegationToken());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HttpURLConnection conn = aUrl.openConnection(nonAuthURL, new DelegationTokenAuthenticatedURL.Token());
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    if (useQS) {
                        Assertions.assertNull((Object)conn.getHeaderField("UsingHeader"));
                        Assertions.assertNotNull((Object)conn.getHeaderField("UsingQueryString"));
                    } else {
                        Assertions.assertNotNull((Object)conn.getHeaderField("UsingHeader"));
                        Assertions.assertNull((Object)conn.getHeaderField("UsingQueryString"));
                    }
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalDelegationTokenSecretManager() throws Exception {
        DummyDelegationTokenSecretManager secretMgr = new DummyDelegationTokenSecretManager();
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(AFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(PingServlet.class), "/bar");
        try {
            secretMgr.startThreads();
            context.setAttribute("hadoop.http.delegation-token-secret-manager", (Object)secretMgr);
            jetty.start();
            URL authURL = new URL(this.getJettyURL() + "/foo/bar?authenticated=foo");
            DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
            DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
            aUrl.getDelegationToken(authURL, token, FOO_USER);
            Assertions.assertNotNull((Object)token.getDelegationToken());
            Assertions.assertEquals((Object)new Text("fooKind"), (Object)token.getDelegationToken().getKind());
        }
        finally {
            jetty.stop();
            secretMgr.stopThreads();
        }
    }

    @Test
    public void testDelegationTokenAuthenticationURLWithNoDTFilter() throws Exception {
        this.testDelegationTokenAuthenticatedURLWithNoDT(NoDTFilter.class);
    }

    @Test
    public void testDelegationTokenAuthenticationURLWithNoDTHandler() throws Exception {
        this.testDelegationTokenAuthenticatedURLWithNoDT(NoDTHandlerDTAFilter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDelegationTokenAuthenticatedURLWithNoDT(Class<? extends Filter> filterClass) throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(filterClass), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(UserServlet.class), "/bar");
        try {
            jetty.start();
            final URL url = new URL(this.getJettyURL() + "/foo/bar");
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)FOO_USER);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
                    DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
                    HttpURLConnection conn = aUrl.openConnection(url, token);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    List ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)TestWebDelegationToken.FOO_USER, ret.get(0));
                    try {
                        aUrl.getDelegationToken(url, token, TestWebDelegationToken.FOO_USER);
                        Assertions.fail();
                    }
                    catch (AuthenticationException ex) {
                        Assertions.assertTrue((boolean)ex.getMessage().contains("delegation token operation"));
                    }
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackToPseudoDelegationTokenAuthenticator() throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(PseudoDTAFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(UserServlet.class), "/bar");
        try {
            jetty.start();
            final URL url = new URL(this.getJettyURL() + "/foo/bar");
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)FOO_USER);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
                    DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
                    HttpURLConnection conn = aUrl.openConnection(url, token);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    List ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)TestWebDelegationToken.FOO_USER, ret.get(0));
                    aUrl.getDelegationToken(url, token, TestWebDelegationToken.FOO_USER);
                    Assertions.assertNotNull((Object)token.getDelegationToken());
                    Assertions.assertEquals((Object)new Text("token-kind"), (Object)token.getDelegationToken().getKind());
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
        }
    }

    public static <T> T doAsKerberosUser(String principal, String keytab, final Callable<T> callable) throws Exception {
        LoginContext loginContext = null;
        try {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, new KerberosConfiguration(principal, keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Object t = Subject.doAs(subject, new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return callable.call();
                }
            });
            return t;
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }

    @Test
    public void testKerberosDelegationTokenAuthenticator() throws Exception {
        this.testKerberosDelegationTokenAuthenticator(false);
    }

    @Test
    public void testKerberosDelegationTokenAuthenticatorWithDoAs() throws Exception {
        this.testKerberosDelegationTokenAuthenticator(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testKerberosDelegationTokenAuthenticator(final boolean doAs) throws Exception {
        final String doAsUser = doAs ? OK_USER : null;
        File testDir = new File("target/" + UUID.randomUUID().toString());
        Assertions.assertTrue((boolean)testDir.mkdirs());
        MiniKdc kdc = new MiniKdc(MiniKdc.createConf(), testDir);
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(KDTAFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(UserServlet.class), "/bar");
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("java.security.krb5.realm", KerberosTestUtils.getRealm());
        try {
            kdc.start();
            File keytabFile = new File(testDir, "test.keytab");
            kdc.createPrincipal(keytabFile, new String[]{"client", "HTTP/localhost"});
            KDTAFilter.keytabFile = keytabFile.getAbsolutePath();
            jetty.start();
            final DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
            final DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
            final URL url = new URL(this.getJettyURL() + "/foo/bar");
            try {
                aUrl.getDelegationToken(url, token, FOO_USER, doAsUser);
                Assertions.fail();
            }
            catch (AuthenticationException ex) {
                Assertions.assertTrue((boolean)ex.getCause().getMessage().contains("GSSException"));
            }
            TestWebDelegationToken.doAsKerberosUser("client", keytabFile.getAbsolutePath(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    aUrl.getDelegationToken(url, token, doAs ? doAsUser : "client", doAsUser);
                    Assertions.assertNotNull((Object)token.getDelegationToken());
                    Assertions.assertEquals((Object)new Text("token-kind"), (Object)token.getDelegationToken().getKind());
                    ByteArrayInputStream buf = new ByteArrayInputStream(token.getDelegationToken().getIdentifier());
                    DataInputStream dis = new DataInputStream(buf);
                    DelegationTokenIdentifier id = new DelegationTokenIdentifier(new Text("token-kind"));
                    id.readFields((DataInput)dis);
                    dis.close();
                    Assertions.assertEquals((Object)(doAs ? new Text(TestWebDelegationToken.OK_USER) : new Text("client")), (Object)id.getOwner());
                    if (doAs) {
                        Assertions.assertEquals((Object)new Text("client"), (Object)id.getRealUser());
                    }
                    aUrl.renewDelegationToken(url, token, doAsUser);
                    Assertions.assertNotNull((Object)token.getDelegationToken());
                    aUrl.getDelegationToken(url, token, TestWebDelegationToken.FOO_USER, doAsUser);
                    Assertions.assertNotNull((Object)token.getDelegationToken());
                    try {
                        aUrl.renewDelegationToken(url, token, doAsUser);
                        Assertions.fail();
                    }
                    catch (Exception ex) {
                        Assertions.assertTrue((boolean)ex.getMessage().contains("403"));
                    }
                    aUrl.getDelegationToken(url, token, TestWebDelegationToken.FOO_USER, doAsUser);
                    aUrl.cancelDelegationToken(url, token, doAsUser);
                    Assertions.assertNull((Object)token.getDelegationToken());
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
            kdc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyUser() throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(PseudoDTAFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(UserServlet.class), "/bar");
        try {
            jetty.start();
            final URL url = new URL(this.getJettyURL() + "/foo/bar");
            String strUrl = String.format("%s?user.name=%s&doas=%s", url.toExternalForm(), FOO_USER, OK_USER);
            HttpURLConnection conn = (HttpURLConnection)new URL(strUrl).openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            List ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((int)1, (int)ret.size());
            Assertions.assertEquals((Object)OK_USER, ret.get(0));
            strUrl = String.format("%s?user.name=%s&DOAS=%s", url.toExternalForm(), FOO_USER, OK_USER);
            conn = (HttpURLConnection)new URL(strUrl).openConnection();
            Assertions.assertEquals((int)200, (int)conn.getResponseCode());
            ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((int)1, (int)ret.size());
            Assertions.assertEquals((Object)OK_USER, ret.get(0));
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)FOO_USER);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
                    DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
                    HttpURLConnection conn = aUrl.openConnection(url, token, TestWebDelegationToken.OK_USER);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    List ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)TestWebDelegationToken.OK_USER, ret.get(0));
                    conn = aUrl.openConnection(url, token, TestWebDelegationToken.FAIL_USER);
                    Assertions.assertEquals((int)403, (int)conn.getResponseCode());
                    aUrl.getDelegationToken(url, token, TestWebDelegationToken.FOO_USER);
                    UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                    ugi.addToken(token.getDelegationToken());
                    token = new DelegationTokenAuthenticatedURL.Token();
                    conn = aUrl.openConnection(url, token, TestWebDelegationToken.OK_USER);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)TestWebDelegationToken.FOO_USER, ret.get(0));
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpUGI() throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(PseudoDTAFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(UGIServlet.class), "/bar");
        try {
            jetty.start();
            final URL url = new URL(this.getJettyURL() + "/foo/bar");
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)FOO_USER);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
                    DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
                    HttpURLConnection conn = aUrl.openConnection(url, token);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    List ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)"remoteuser=foo:ugi=foo", ret.get(0));
                    conn = aUrl.openConnection(url, token, TestWebDelegationToken.OK_USER);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)"realugi=foo:remoteuser=ok-user:ugi=ok-user", ret.get(0));
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIpaddressCheck() throws Exception {
        Server jetty = this.createJettyServer();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/foo");
        jetty.setHandler((Handler)context);
        context.addFilter(new FilterHolder(IpAddressBasedPseudoDTAFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addServlet(new ServletHolder(UGIServlet.class), "/bar");
        try {
            jetty.start();
            final URL url = new URL(this.getJettyURL() + "/foo/bar");
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)FOO_USER);
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
                    DelegationTokenAuthenticatedURL aUrl = new DelegationTokenAuthenticatedURL();
                    HttpURLConnection conn = aUrl.openConnection(url, token, TestWebDelegationToken.OK_USER);
                    Assertions.assertEquals((int)200, (int)conn.getResponseCode());
                    List ret = IOUtils.readLines((InputStream)conn.getInputStream(), (Charset)StandardCharsets.UTF_8);
                    Assertions.assertEquals((int)1, (int)ret.size());
                    Assertions.assertEquals((Object)"realugi=foo:remoteuser=ok-user:ugi=ok-user", ret.get(0));
                    return null;
                }
            });
        }
        finally {
            jetty.stop();
        }
    }

    public static class AFilter
    extends DelegationTokenAuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
            Properties conf = new Properties();
            conf.setProperty("type", DummyDelegationTokenAuthenticationHandler.class.getName());
            return conf;
        }
    }

    public static class PingServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            resp.getWriter().write("ping");
            if (req.getHeader("X-Hadoop-Delegation-Token") != null) {
                resp.setHeader("UsingHeader", "true");
            }
            if (req.getQueryString() != null && req.getQueryString().contains("delegation=")) {
                resp.setHeader("UsingQueryString", "true");
            }
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            PrintWriter writer = resp.getWriter();
            ((Writer)writer).write("ping: ");
            IOUtils.copy((Reader)req.getReader(), (Writer)writer);
            resp.setStatus(200);
        }
    }

    private static class DummyDelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        public DummyDelegationTokenSecretManager() {
            super(10000L, 10000L, 10000L, 10000L);
        }

        public DelegationTokenIdentifier createIdentifier() {
            return new DelegationTokenIdentifier(new Text("fooKind"));
        }
    }

    public static class NoDTFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
            Properties conf = new Properties();
            conf.setProperty("type", "simple");
            return conf;
        }
    }

    public static class NoDTHandlerDTAFilter
    extends DelegationTokenAuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
            Properties conf = new Properties();
            conf.setProperty("type", "simple");
            return conf;
        }
    }

    public static class UserServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            resp.getWriter().write(req.getUserPrincipal().getName());
        }
    }

    public static class PseudoDTAFilter
    extends DelegationTokenAuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
            Properties conf = new Properties();
            conf.setProperty("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
            conf.setProperty("delegation-token.token-kind", "token-kind");
            return conf;
        }

        protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) throws ServletException {
            Configuration conf = new Configuration(false);
            conf.set("proxyuser.foo.users", TestWebDelegationToken.OK_USER);
            conf.set("proxyuser.foo.hosts", "localhost");
            return conf;
        }
    }

    private static class KerberosConfiguration
    extends javax.security.auth.login.Configuration {
        private String principal;
        private String keytab;

        public KerberosConfiguration(String principal, String keytab) {
            this.principal = principal;
            this.keytab = keytab;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("principal", this.principal);
            options.put("keyTab", this.keytab);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", "true");
            String ticketCache = System.getenv("KRB5CCNAME");
            if (ticketCache != null) {
                options.put("ticketCache", ticketCache);
            }
            options.put("debug", "true");
            return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }

    public static class KDTAFilter
    extends DelegationTokenAuthenticationFilter {
        static String keytabFile;

        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
            Properties conf = new Properties();
            conf.setProperty("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
            conf.setProperty("kerberos.keytab", keytabFile);
            conf.setProperty("kerberos.principal", "HTTP/localhost");
            conf.setProperty("delegation-token.token-kind", "token-kind");
            return conf;
        }

        protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) throws ServletException {
            Configuration conf = new Configuration(false);
            conf.set("proxyuser.client.users", TestWebDelegationToken.OK_USER);
            conf.set("proxyuser.client.hosts", "127.0.0.1");
            return conf;
        }
    }

    public static class UGIServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            UserGroupInformation ugi = HttpUserGroupInformation.get();
            if (ugi != null) {
                String ret = "remoteuser=" + req.getRemoteUser() + ":ugi=" + ugi.getShortUserName();
                if (ugi.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.PROXY) {
                    ret = "realugi=" + ugi.getRealUser().getShortUserName() + ":" + ret;
                }
                resp.setStatus(200);
                resp.getWriter().write(ret);
            } else {
                resp.setStatus(500);
            }
        }
    }

    public static class IpAddressBasedPseudoDTAFilter
    extends PseudoDTAFilter {
        @Override
        protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) throws ServletException {
            Configuration configuration = super.getProxyuserConfiguration(filterConfig);
            configuration.set("proxyuser.foo.hosts", "127.0.0.1");
            return configuration;
        }
    }

    public static class DummyDelegationTokenAuthenticationHandler
    extends DelegationTokenAuthenticationHandler {
        public DummyDelegationTokenAuthenticationHandler() {
            super((AuthenticationHandler)new DummyAuthenticationHandler());
        }

        public void init(Properties config) throws ServletException {
            Properties conf = new Properties(config);
            conf.setProperty("delegation-token.token-kind", "token-kind");
            this.initTokenManager(conf);
        }
    }

    public static class DummyAuthenticationHandler
    implements AuthenticationHandler {
        public String getType() {
            return "dummy";
        }

        public void init(Properties config) throws ServletException {
        }

        public void destroy() {
        }

        public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
            return false;
        }

        public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
            AuthenticationToken token = null;
            if (request.getParameter("authenticated") != null) {
                token = new AuthenticationToken(request.getParameter("authenticated"), "U", "test");
            } else {
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "dummy");
            }
            return token;
        }
    }
}

