/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.security.ssl.DelegatingSSLSocketFactory;
import org.apache.hadoop.util.NativeCodeLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestDelegatingSSLSocketFactory {
    @Test
    public void testOpenSSL() throws IOException {
        Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded(), (String)"Unable to load native libraries");
        Assumptions.assumeTrue((boolean)NativeCodeLoader.buildSupportsOpenssl(), (String)"Build was not compiled with support for OpenSSL");
        DelegatingSSLSocketFactory.initializeDefaultFactory((DelegatingSSLSocketFactory.SSLChannelMode)DelegatingSSLSocketFactory.SSLChannelMode.OpenSSL);
        Assertions.assertThat((String)DelegatingSSLSocketFactory.getDefaultFactory().getProviderName()).contains(new CharSequence[]{"openssl"});
    }

    @Test
    public void testJSEENoGCMJava8() throws IOException {
        Assumptions.assumeTrue((boolean)System.getProperty("java.version").startsWith("1.8"), (String)"Not running on Java 8");
        DelegatingSSLSocketFactory.initializeDefaultFactory((DelegatingSSLSocketFactory.SSLChannelMode)DelegatingSSLSocketFactory.SSLChannelMode.Default_JSSE);
        Assertions.assertThat(Arrays.stream(DelegatingSSLSocketFactory.getDefaultFactory().getSupportedCipherSuites())).noneMatch("GCM"::contains);
    }
}

