/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.http;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.test.MockitoUtil;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRestCsrfPreventionFilter {
    private static final String NON_BROWSER = "java";
    private static final String BROWSER_AGENT = "Mozilla/5.0 (compatible; U; ABrowse 0.6; Syllable) AppleWebKit/420+ (KHTML, like Gecko)";
    private static final String EXPECTED_MESSAGE = "Missing Required Header for CSRF Vulnerability Protection";
    private static final String X_CUSTOM_HEADER = "X-CUSTOM_HEADER";

    @Test
    public void testNoHeaderDefaultConfigBadRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn(null);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)BROWSER_AGENT);
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((HttpServletResponse)Mockito.verify((Object)mockRes, (VerificationMode)Mockito.atLeastOnce())).sendError(400, EXPECTED_MESSAGE);
        MockitoUtil.verifyZeroInteractions(mockChain);
    }

    @Test
    public void testNoHeaderCustomAgentConfigBadRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("browser-useragents-regex")).thenReturn((Object)"^Mozilla.*,^Opera.*,curl");
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)"curl");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((HttpServletResponse)Mockito.verify((Object)mockRes, (VerificationMode)Mockito.atLeastOnce())).sendError(400, EXPECTED_MESSAGE);
        MockitoUtil.verifyZeroInteractions(mockChain);
    }

    @Test
    public void testNoHeaderDefaultConfigNonBrowserGoodRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn(null);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)NON_BROWSER);
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testHeaderPresentDefaultConfigGoodRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn(null);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn((Object)"valueUnimportant");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testHeaderPresentCustomHeaderConfigGoodRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn((Object)X_CUSTOM_HEADER);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn(null);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader(X_CUSTOM_HEADER)).thenReturn((Object)"valueUnimportant");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testMissingHeaderWithCustomHeaderConfigBadRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn((Object)X_CUSTOM_HEADER);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn(null);
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)BROWSER_AGENT);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockChain);
    }

    @Test
    public void testMissingHeaderNoMethodsToIgnoreConfigBadRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn((Object)"");
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)BROWSER_AGENT);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getMethod()).thenReturn((Object)"GET");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockChain);
    }

    @Test
    public void testMissingHeaderIgnoreGETMethodConfigGoodRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn((Object)"GET");
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)BROWSER_AGENT);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getMethod()).thenReturn((Object)"GET");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testMissingHeaderMultipleIgnoreMethodsConfigGoodRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn((Object)"GET,OPTIONS");
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)BROWSER_AGENT);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getMethod()).thenReturn((Object)"OPTIONS");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        ((FilterChain)Mockito.verify((Object)mockChain)).doFilter((ServletRequest)mockReq, (ServletResponse)mockRes);
    }

    @Test
    public void testMissingHeaderMultipleIgnoreMethodsConfigBadRequest() throws ServletException, IOException {
        FilterConfig filterConfig = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)filterConfig.getInitParameter("custom-header")).thenReturn(null);
        Mockito.when((Object)filterConfig.getInitParameter("methods-to-ignore")).thenReturn((Object)"GET,OPTIONS");
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)mockReq.getHeader("User-Agent")).thenReturn((Object)BROWSER_AGENT);
        Mockito.when((Object)mockReq.getHeader("X-XSRF-HEADER")).thenReturn(null);
        Mockito.when((Object)mockReq.getMethod()).thenReturn((Object)"PUT");
        HttpServletResponse mockRes = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain mockChain = (FilterChain)Mockito.mock(FilterChain.class);
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        filter.init(filterConfig);
        filter.doFilter((ServletRequest)mockReq, (ServletResponse)mockRes, mockChain);
        MockitoUtil.verifyZeroInteractions(mockChain);
    }
}

