/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestShellBasedUnixGroupsMapping {
    private static final Logger TESTLOG = LoggerFactory.getLogger(TestShellBasedUnixGroupsMapping.class);
    private final GenericTestUtils.LogCapturer shellMappingLog = GenericTestUtils.LogCapturer.captureLogs(ShellBasedUnixGroupsMapping.LOG);

    @Test
    public void testGetGroupsNonexistentUser() throws Exception {
        TestGroupUserNotExist mapping = new TestGroupUserNotExist();
        List groups = mapping.getGroups("foobarusernotexist");
        Assertions.assertTrue((boolean)groups.isEmpty());
    }

    @Test
    public void testGetGroupsNotResolvable() throws Exception {
        TestGroupNotResolvable mapping = new TestGroupNotResolvable();
        List groups = mapping.getGroups("user");
        Assertions.assertTrue((groups.size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)groups.contains("abc"));
        Assertions.assertTrue((boolean)groups.contains("def"));
    }

    @Test
    public void testGetNumericGroupsResolvable() throws Exception {
        TestNumericGroupResolvable mapping = new TestNumericGroupResolvable();
        List groups = mapping.getGroups("user");
        Assertions.assertTrue((groups.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)groups.contains("23"));
        Assertions.assertTrue((boolean)groups.contains("groupname"));
        Assertions.assertTrue((boolean)groups.contains("zzz"));
    }

    public long getTimeoutInterval(String timeout) {
        Configuration conf = new Configuration();
        String userName = "foobarnonexistinguser";
        conf.set("hadoop.security.groups.shell.command.timeout", timeout);
        TestDelayedGroupCommand mapping = (TestDelayedGroupCommand)((Object)ReflectionUtils.newInstance(TestDelayedGroupCommand.class, (Configuration)conf));
        Shell.ShellCommandExecutor executor = mapping.createGroupExecutor(userName);
        return executor.getTimeoutInterval();
    }

    @Test
    public void testShellTimeOutConf() {
        Assertions.assertEquals((long)1000L, (long)this.getTimeoutInterval("1s"), (String)"Expected the group names executor to carry the configured timeout");
        Assertions.assertEquals((long)60000L, (long)this.getTimeoutInterval("1m"), (String)"Expected the group names executor to carry the configured timeout");
        Assertions.assertEquals((long)1L, (long)this.getTimeoutInterval("1"), (String)"Expected the group names executor to carry the configured timeout");
    }

    @Test
    public void testGetGroupsResolvable() throws Exception {
        TestGroupResolvable mapping = new TestGroupResolvable();
        List groups = mapping.getGroups("user");
        Assertions.assertTrue((groups.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)groups.contains("abc"));
        Assertions.assertTrue((boolean)groups.contains("def"));
        Assertions.assertTrue((boolean)groups.contains("hij"));
    }

    @Test
    @Timeout(value=4L)
    public void testFiniteGroupResolutionTime() throws Exception {
        Configuration conf = new Configuration();
        String userName = "foobarnonexistinguser";
        String commandTimeoutMessage = "ran longer than the configured timeout limit";
        long testTimeout = 500L;
        conf.setLong("hadoop.security.groups.shell.command.timeout", testTimeout);
        TestDelayedGroupCommand mapping = (TestDelayedGroupCommand)((Object)ReflectionUtils.newInstance(TestDelayedGroupCommand.class, (Configuration)conf));
        Shell.ShellCommandExecutor executor = mapping.createGroupExecutor(userName);
        Assertions.assertEquals((long)testTimeout, (long)executor.getTimeoutInterval(), (String)"Expected the group names executor to carry the configured timeout");
        executor = mapping.createGroupIDExecutor(userName);
        Assertions.assertEquals((long)testTimeout, (long)executor.getTimeoutInterval(), (String)"Expected the group ID executor to carry the configured timeout");
        Assertions.assertEquals((int)0, (int)mapping.getGroups(userName).size(), (String)"Expected no groups to be returned given a shell command timeout");
        Assertions.assertTrue((boolean)this.shellMappingLog.getOutput().contains(commandTimeoutMessage), (String)("Expected the logs to carry a message about command timeout but was: " + this.shellMappingLog.getOutput()));
        this.shellMappingLog.clearOutput();
        conf.setClass("hadoop.security.group.mapping", TestDelayedGroupCommand.class, GroupMappingServiceProvider.class);
        Groups groups = new Groups(conf);
        try {
            groups.getGroups(userName);
            Assertions.fail((String)"The groups framework call should have failed with a command timeout");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)this.shellMappingLog.getOutput().contains(commandTimeoutMessage), (String)("Expected the logs to carry a message about command timeout but was: " + this.shellMappingLog.getOutput()));
        }
        this.shellMappingLog.clearOutput();
        conf = new Configuration();
        long defaultTimeout = 0L;
        mapping = (TestDelayedGroupCommand)((Object)ReflectionUtils.newInstance(TestDelayedGroupCommand.class, (Configuration)conf));
        executor = mapping.createGroupExecutor(userName);
        Assertions.assertEquals((long)defaultTimeout, (long)executor.getTimeoutInterval(), (String)"Expected the group names executor to carry the default timeout");
        executor = mapping.createGroupIDExecutor(userName);
        Assertions.assertEquals((long)defaultTimeout, (long)executor.getTimeoutInterval(), (String)"Expected the group ID executor to carry the default timeout");
        mapping.getGroups(userName);
        Assertions.assertFalse((boolean)this.shellMappingLog.getOutput().contains(commandTimeoutMessage), (String)("Didn't expect a timeout of command in execution but logs carry it: " + this.shellMappingLog.getOutput()));
    }

    private class TestGroupUserNotExist
    extends ShellBasedUnixGroupsMapping {
        private TestGroupUserNotExist() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doThrow((Throwable[])new Throwable[]{new Shell.ExitCodeException(1, "id: foobarusernotexist: No such user")}).when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"");
            }
            catch (IOException e) {
                TESTLOG.warn(e.getMessage());
            }
            return executor;
        }
    }

    private class TestGroupNotResolvable
    extends ShellBasedUnixGroupsMapping {
        private TestGroupNotResolvable() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doThrow((Throwable[])new Throwable[]{new Shell.ExitCodeException(1, "cannot find name for group ID 9999")}).when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"9999\n9999 abc def");
            }
            catch (IOException e) {
                TESTLOG.warn(e.getMessage());
            }
            return executor;
        }

        protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            Mockito.when((Object)executor.getOutput()).thenReturn((Object)"9999\n9999 1 2");
            return executor;
        }
    }

    private class TestNumericGroupResolvable
    extends ShellBasedUnixGroupsMapping {
        private TestNumericGroupResolvable() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"23\n23 groupname zzz");
            }
            catch (IOException e) {
                TESTLOG.warn(e.getMessage());
            }
            return executor;
        }

        protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"111\n111 112 113");
            }
            catch (IOException e) {
                TESTLOG.warn(e.getMessage());
            }
            return executor;
        }
    }

    private static class TestDelayedGroupCommand
    extends ShellBasedUnixGroupsMapping {
        private Long timeoutSecs = 1L;

        TestDelayedGroupCommand() {
        }

        protected String[] getGroupsForUserCommand(String userName) {
            if (Shell.WINDOWS) {
                return new String[]{"timeout", this.timeoutSecs.toString()};
            }
            return new String[]{"sleep", this.timeoutSecs.toString()};
        }

        protected String[] getGroupsIDForUserCommand(String userName) {
            return this.getGroupsForUserCommand(userName);
        }
    }

    private class TestGroupResolvable
    extends ShellBasedUnixGroupsMapping {
        private TestGroupResolvable() {
        }

        protected Shell.ShellCommandExecutor createGroupExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"abc\ndef abc hij");
            }
            catch (IOException e) {
                TESTLOG.warn(e.getMessage());
            }
            return executor;
        }

        protected Shell.ShellCommandExecutor createGroupIDExecutor(String userName) {
            Shell.ShellCommandExecutor executor = (Shell.ShellCommandExecutor)Mockito.mock(Shell.ShellCommandExecutor.class);
            try {
                ((Shell.ShellCommandExecutor)Mockito.doNothing().when((Object)executor)).execute();
                Mockito.when((Object)executor.getOutput()).thenReturn((Object)"1\n1 2 3");
            }
            catch (IOException e) {
                TESTLOG.warn(e.getMessage());
            }
            return executor;
        }
    }
}

