/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.CommunicationException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.LdapGroupsMapping;
import org.apache.hadoop.security.TestLdapGroupsMappingBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestLdapGroupsMappingWithFailover
extends TestLdapGroupsMappingBase {
    private static final String TEST_USER_NAME = "some_user";

    @Test
    public void testDoesNotFailoverWhenDisabled() throws Exception {
        int numAttempts = 3;
        Configuration conf = this.getBaseConf();
        conf.setStrings("hadoop.security.group.mapping.ldap.url", new String[]{"ldap://test", "ldap://test1", "ldap://test2"});
        TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedLdapUrl("ldap://test");
        conf.setInt("hadoop.security.group.mapping.ldap.num.attempts", 3);
        conf.setInt("hadoop.security.group.mapping.ldap.num.attempts.before.failover", 3);
        Mockito.when(this.getContext().search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class))).thenThrow(new Throwable[]{new CommunicationException()});
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups(TEST_USER_NAME);
        Assertions.assertTrue((boolean)groups.isEmpty());
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)3))).search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class));
    }

    @Test
    public void testFailover() throws Exception {
        final LinkedList<String> ldapUrls = new LinkedList<String>();
        ldapUrls.add("ldap://test");
        ldapUrls.add("ldap://test1");
        ldapUrls.add("ldap://test2");
        int numAttempts = 12;
        int numAttemptsBeforeFailover = 2;
        Configuration conf = this.getBaseConf();
        conf.setStrings("hadoop.security.group.mapping.ldap.url", new String[]{"ldap://test", "ldap://test1", "ldap://test2"});
        conf.setInt("hadoop.security.group.mapping.ldap.num.attempts", 12);
        conf.setInt("hadoop.security.group.mapping.ldap.num.attempts.before.failover", 2);
        String nextLdapUrl = (String)ldapUrls.remove();
        TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedLdapUrl(nextLdapUrl);
        ldapUrls.add(nextLdapUrl);
        final AtomicInteger serverAttempts = new AtomicInteger(2);
        Mockito.when(this.getContext().search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                if (serverAttempts.get() == 1) {
                    String nextLdapUrl = (String)ldapUrls.remove();
                    ldapUrls.add(nextLdapUrl);
                    TestLdapGroupsMappingBase.DummyLdapCtxFactory.setExpectedLdapUrl(nextLdapUrl);
                    serverAttempts.set(2);
                } else {
                    serverAttempts.decrementAndGet();
                }
                throw new CommunicationException();
            }
        });
        LdapGroupsMapping groupsMapping = this.getGroupsMapping();
        groupsMapping.setConf(conf);
        List groups = groupsMapping.getGroups(TEST_USER_NAME);
        Assertions.assertTrue((boolean)groups.isEmpty());
        ((DirContext)Mockito.verify((Object)this.getContext(), (VerificationMode)Mockito.times((int)12))).search(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Object[])ArgumentMatchers.any(Object[].class), (SearchControls)ArgumentMatchers.any(SearchControls.class));
    }
}

