/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.security.JniBasedUnixGroupsMapping;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestJNIGroupsMapping {
    @BeforeEach
    public void isNativeCodeLoaded() {
        Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
    }

    @Test
    public void testJNIGroupsMapping() throws Exception {
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        this.testForUser(user);
        this.testForUser("fooBarBaz1234DoesNotExist");
    }

    private void testForUser(String user) throws Exception {
        ShellBasedUnixGroupsMapping g = new ShellBasedUnixGroupsMapping();
        List shellBasedGroups = g.getGroups(user);
        g = new JniBasedUnixGroupsMapping();
        List jniBasedGroups = g.getGroups(user);
        Object[] shellBasedGroupsArray = shellBasedGroups.toArray(new String[0]);
        Arrays.sort(shellBasedGroupsArray);
        Object[] jniBasedGroupsArray = jniBasedGroups.toArray(new String[0]);
        Arrays.sort(jniBasedGroupsArray);
        if (!Arrays.equals(shellBasedGroupsArray, jniBasedGroupsArray)) {
            Assertions.fail((String)("Groups returned by " + ShellBasedUnixGroupsMapping.class.getCanonicalName() + " and " + JniBasedUnixGroupsMapping.class.getCanonicalName() + " didn't match for " + user));
        }
    }
}

