/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.CompositeGroupsMapping;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompositeGroupMapping {
    public static final Logger LOG = LoggerFactory.getLogger(TestCompositeGroupMapping.class);
    private static Configuration conf = new Configuration();
    private static TestUser john = new TestUser("John", "user-group");
    private static TestUser hdfs = new TestUser("hdfs", "supergroup");
    private static TestUser jack = new TestUser("Jack", "user-group", "dev-group-1");
    private static final String PROVIDER_SPECIFIC_CONF = ".test.prop";
    private static final String PROVIDER_SPECIFIC_CONF_KEY = "hadoop.security.group.mapping.test.prop";
    private static final String PROVIDER_SPECIFIC_CONF_VALUE_FOR_USER = "value-for-user";
    private static final String PROVIDER_SPECIFIC_CONF_VALUE_FOR_CLUSTER = "value-for-cluster";

    @Test
    public void TestMultipleGroupsMapping() throws Exception {
        Groups groups = new Groups(conf);
        Assertions.assertTrue((boolean)((String)groups.getGroups(TestCompositeGroupMapping.john.name).get(0)).equals(TestCompositeGroupMapping.john.group));
        Assertions.assertTrue((boolean)((String)groups.getGroups(TestCompositeGroupMapping.hdfs.name).get(0)).equals(TestCompositeGroupMapping.hdfs.group));
    }

    @Test
    public void TestMultipleGroupsMappingWithCombined() throws Exception {
        conf.set("hadoop.security.group.mapping.providers.combined", "true");
        Groups groups = new Groups(conf);
        Assertions.assertTrue((groups.getGroups(TestCompositeGroupMapping.jack.name).size() == 2 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)groups.getGroups(TestCompositeGroupMapping.jack.name).contains(TestCompositeGroupMapping.jack.group));
        Assertions.assertTrue((boolean)groups.getGroups(TestCompositeGroupMapping.jack.name).contains(TestCompositeGroupMapping.jack.group2));
    }

    @Test
    public void TestMultipleGroupsMappingWithoutCombined() throws Exception {
        conf.set("hadoop.security.group.mapping.providers.combined", "false");
        Groups groups = new Groups(conf);
        Assertions.assertTrue((groups.getGroups(TestCompositeGroupMapping.jack.name).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)((String)groups.getGroups(TestCompositeGroupMapping.jack.name).get(0)).equals(TestCompositeGroupMapping.jack.group));
    }

    static {
        conf.setClass("hadoop.security.group.mapping", CompositeGroupsMapping.class, GroupMappingServiceProvider.class);
        conf.set("hadoop.security.group.mapping.providers", "userProvider,clusterProvider");
        conf.setClass("hadoop.security.group.mapping.provider.userProvider", UserProvider.class, GroupMappingServiceProvider.class);
        conf.setClass("hadoop.security.group.mapping.provider.clusterProvider", ClusterProvider.class, GroupMappingServiceProvider.class);
        conf.set("hadoop.security.group.mapping.provider.clusterProvider.test.prop", PROVIDER_SPECIFIC_CONF_VALUE_FOR_CLUSTER);
        conf.set("hadoop.security.group.mapping.provider.userProvider.test.prop", PROVIDER_SPECIFIC_CONF_VALUE_FOR_USER);
    }

    private static class TestUser {
        String name;
        String group;
        String group2;

        public TestUser(String name, String group) {
            this.name = name;
            this.group = group;
        }

        public TestUser(String name, String group, String group2) {
            this(name, group);
            this.group2 = group2;
        }
    }

    private static class UserProvider
    extends GroupMappingProviderBase {
        private UserProvider() {
        }

        public List<String> getGroups(String user) throws IOException {
            return this.toList(this.getGroupInternal(user));
        }

        public Set<String> getGroupsSet(String user) throws IOException {
            return this.toSet(this.getGroupInternal(user));
        }

        private String getGroupInternal(String user) throws IOException {
            this.checkTestConf(TestCompositeGroupMapping.PROVIDER_SPECIFIC_CONF_VALUE_FOR_USER);
            String group = null;
            if (user.equals(TestCompositeGroupMapping.john.name)) {
                group = TestCompositeGroupMapping.john.group;
            } else if (user.equals(TestCompositeGroupMapping.jack.name)) {
                group = TestCompositeGroupMapping.jack.group;
            }
            return group;
        }
    }

    private static class ClusterProvider
    extends GroupMappingProviderBase {
        private ClusterProvider() {
        }

        public List<String> getGroups(String user) throws IOException {
            return this.toList(this.getGroupsInternal(user));
        }

        public Set<String> getGroupsSet(String user) throws IOException {
            return this.toSet(this.getGroupsInternal(user));
        }

        private String getGroupsInternal(String user) throws IOException {
            this.checkTestConf(TestCompositeGroupMapping.PROVIDER_SPECIFIC_CONF_VALUE_FOR_CLUSTER);
            String group = null;
            if (user.equals(TestCompositeGroupMapping.hdfs.name)) {
                group = TestCompositeGroupMapping.hdfs.group;
            } else if (user.equals(TestCompositeGroupMapping.jack.name)) {
                group = TestCompositeGroupMapping.jack.group2;
            }
            return group;
        }
    }

    private static abstract class GroupMappingProviderBase
    implements GroupMappingServiceProvider,
    Configurable {
        private Configuration conf;

        private GroupMappingProviderBase() {
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void cacheGroupsRefresh() throws IOException {
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
        }

        protected List<String> toList(String group) {
            if (group != null) {
                return Arrays.asList(group);
            }
            return new ArrayList<String>();
        }

        protected Set<String> toSet(String group) {
            if (group != null) {
                HashSet<String> result = new HashSet<String>();
                result.add(group);
                return result;
            }
            return new HashSet<String>();
        }

        protected void checkTestConf(String expectedValue) {
            String configValue = this.getConf().get(TestCompositeGroupMapping.PROVIDER_SPECIFIC_CONF_KEY);
            if (configValue == null || !configValue.equals(expectedValue)) {
                throw new RuntimeException("Failed to find mandatory configuration of hadoop.security.group.mapping.test.prop");
            }
        }
    }
}

