/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import org.apache.hadoop.security.AuthorizationContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAuthorizationContext {
    @Test
    public void testSetAndGetAuthorizationHeader() {
        byte[] header = "my-auth-header".getBytes();
        AuthorizationContext.setCurrentAuthorizationHeader((byte[])header);
        Assertions.assertArrayEquals((byte[])header, (byte[])AuthorizationContext.getCurrentAuthorizationHeader());
        AuthorizationContext.clear();
    }

    @Test
    public void testClearAuthorizationHeader() {
        byte[] header = "clear-me".getBytes();
        AuthorizationContext.setCurrentAuthorizationHeader((byte[])header);
        AuthorizationContext.clear();
        Assertions.assertNull((Object)AuthorizationContext.getCurrentAuthorizationHeader());
    }

    @Test
    public void testThreadLocalIsolation() throws Exception {
        byte[] mainHeader = "main-thread".getBytes();
        AuthorizationContext.setCurrentAuthorizationHeader((byte[])mainHeader);
        Thread t = new Thread(() -> {
            Assertions.assertNull((Object)AuthorizationContext.getCurrentAuthorizationHeader());
            byte[] threadHeader = "other-thread".getBytes();
            AuthorizationContext.setCurrentAuthorizationHeader((byte[])threadHeader);
            Assertions.assertArrayEquals((byte[])threadHeader, (byte[])AuthorizationContext.getCurrentAuthorizationHeader());
            AuthorizationContext.clear();
            Assertions.assertNull((Object)AuthorizationContext.getCurrentAuthorizationHeader());
        });
        t.start();
        t.join();
        Assertions.assertArrayEquals((byte[])mainHeader, (byte[])AuthorizationContext.getCurrentAuthorizationHeader());
        AuthorizationContext.clear();
    }

    @Test
    public void testNullAndEmptyHeader() {
        AuthorizationContext.setCurrentAuthorizationHeader(null);
        Assertions.assertNull((Object)AuthorizationContext.getCurrentAuthorizationHeader());
        byte[] empty = new byte[]{};
        AuthorizationContext.setCurrentAuthorizationHeader((byte[])empty);
        Assertions.assertArrayEquals((byte[])empty, (byte[])AuthorizationContext.getCurrentAuthorizationHeader());
        AuthorizationContext.clear();
    }
}

