/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCredentialsSys {
    @Test
    public void testReadWrite() {
        CredentialsSys credential = new CredentialsSys();
        credential.setUID(0);
        credential.setGID(1);
        credential.setStamp(1234);
        XDR xdr = new XDR();
        credential.write(xdr);
        CredentialsSys newCredential = new CredentialsSys();
        newCredential.read(xdr.asReadOnlyWrap());
        Assertions.assertEquals((int)0, (int)newCredential.getUID());
        Assertions.assertEquals((int)1, (int)newCredential.getGID());
        Assertions.assertEquals((int)1234, (int)newCredential.getStamp());
    }

    @Test
    public void testHostNameNotMultipleOf4() {
        CredentialsSys credential = new CredentialsSys();
        credential.setUID(0);
        credential.setGID(1);
        credential.setStamp(1234);
        credential.setHostName("hadoop-nfs");
        XDR xdr = new XDR();
        credential.write(xdr);
        CredentialsSys newCredential = new CredentialsSys();
        newCredential.read(xdr.asReadOnlyWrap());
        Assertions.assertEquals((int)0, (int)newCredential.getUID());
        Assertions.assertEquals((int)1, (int)newCredential.getGID());
        Assertions.assertEquals((int)1234, (int)newCredential.getStamp());
        Assertions.assertEquals((int)32, (int)newCredential.getCredentialLength());
    }

    @Test
    public void testHostNameMultipleOf4() {
        CredentialsSys credential = new CredentialsSys();
        credential.setUID(0);
        credential.setGID(1);
        credential.setStamp(1234);
        credential.setHostName("apachehadoop");
        XDR xdr = new XDR();
        credential.write(xdr);
        CredentialsSys newCredential = new CredentialsSys();
        newCredential.read(xdr.asReadOnlyWrap());
        Assertions.assertEquals((int)0, (int)newCredential.getUID());
        Assertions.assertEquals((int)1, (int)newCredential.getGID());
        Assertions.assertEquals((int)1234, (int)newCredential.getStamp());
        Assertions.assertEquals((int)32, (int)newCredential.getCredentialLength());
    }
}

