/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcReply {
    @Test
    public void testReplyStateFromValue() {
        Assertions.assertEquals((Object)RpcReply.ReplyState.MSG_ACCEPTED, (Object)RpcReply.ReplyState.fromValue((int)0));
        Assertions.assertEquals((Object)RpcReply.ReplyState.MSG_DENIED, (Object)RpcReply.ReplyState.fromValue((int)1));
    }

    @Test
    public void testReplyStateFromInvalidValue1() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> RpcReply.ReplyState.fromValue((int)2));
    }

    @Test
    public void testRpcReply() {
        RpcReply reply = new RpcReply(0, RpcReply.ReplyState.MSG_ACCEPTED, (Verifier)new VerifierNone()){

            public XDR write(XDR xdr) {
                return null;
            }
        };
        Assertions.assertEquals((int)0, (int)reply.getXid());
        Assertions.assertEquals((Object)RpcMessage.Type.RPC_REPLY, (Object)reply.getMessageType());
        Assertions.assertEquals((Object)RpcReply.ReplyState.MSG_ACCEPTED, (Object)reply.getState());
    }
}

