/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.oncrpc.RpcCallCache;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestRpcCallCache {
    @Test
    public void testRpcCallCacheConstructorIllegalArgument0() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RpcCallCache("test", 0));
    }

    @Test
    public void testRpcCallCacheConstructorIllegalArgumentNegative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RpcCallCache("test", -1));
    }

    @Test
    public void testRpcCallCacheConstructor() {
        RpcCallCache cache = new RpcCallCache("test", 100);
        Assertions.assertEquals((Object)"test", (Object)cache.getProgram());
    }

    @Test
    public void testAddRemoveEntries() throws UnknownHostException {
        RpcCallCache cache = new RpcCallCache("test", 100);
        InetAddress clientIp = InetAddress.getByName("1.1.1.1");
        int xid = 100;
        RpcCallCache.CacheEntry e = cache.checkOrAddToCache(clientIp, xid);
        Assertions.assertNull((Object)e);
        e = cache.checkOrAddToCache(clientIp, xid);
        this.validateInprogressCacheEntry(e);
        RpcResponse response = (RpcResponse)Mockito.mock(RpcResponse.class);
        cache.callCompleted(clientIp, xid, response);
        e = cache.checkOrAddToCache(clientIp, xid);
        this.validateCompletedCacheEntry(e, response);
    }

    private void validateInprogressCacheEntry(RpcCallCache.CacheEntry c) {
        Assertions.assertTrue((boolean)c.isInProgress());
        Assertions.assertFalse((boolean)c.isCompleted());
        Assertions.assertNull((Object)c.getResponse());
    }

    private void validateCompletedCacheEntry(RpcCallCache.CacheEntry c, RpcResponse response) {
        Assertions.assertFalse((boolean)c.isInProgress());
        Assertions.assertTrue((boolean)c.isCompleted());
        Assertions.assertEquals((Object)response, (Object)c.getResponse());
    }

    @Test
    public void testCacheEntry() {
        RpcCallCache.CacheEntry c = new RpcCallCache.CacheEntry();
        this.validateInprogressCacheEntry(c);
        Assertions.assertTrue((boolean)c.isInProgress());
        Assertions.assertFalse((boolean)c.isCompleted());
        Assertions.assertNull((Object)c.getResponse());
        RpcResponse response = (RpcResponse)Mockito.mock(RpcResponse.class);
        c.setResponse(response);
        this.validateCompletedCacheEntry(c, response);
    }

    @Test
    public void testCacheFunctionality() throws UnknownHostException {
        RpcCallCache cache = new RpcCallCache("Test", 10);
        int size = 0;
        for (int clientId = 0; clientId < 20; ++clientId) {
            int i;
            InetAddress clientIp = InetAddress.getByName("1.1.1." + clientId);
            System.out.println("Adding " + clientIp);
            cache.checkOrAddToCache(clientIp, 0);
            ++size;
            size = Math.min(size, 10);
            System.out.println("Cache size " + cache.size());
            Assertions.assertEquals((int)size, (int)cache.size());
            int startEntry = Math.max(clientId - 10 + 1, 0);
            Iterator iterator = cache.iterator();
            for (i = 0; i < size; ++i) {
                RpcCallCache.ClientRequest key = (RpcCallCache.ClientRequest)((Map.Entry)iterator.next()).getKey();
                System.out.println("Entry " + key.getClientId());
                Assertions.assertEquals((Object)InetAddress.getByName("1.1.1." + (startEntry + i)), (Object)key.getClientId());
            }
            for (i = 0; i < size; ++i) {
                RpcCallCache.CacheEntry e = cache.checkOrAddToCache(InetAddress.getByName("1.1.1." + (startEntry + i)), 0);
                Assertions.assertNotNull((Object)e);
                Assertions.assertTrue((boolean)e.isInProgress());
                Assertions.assertFalse((boolean)e.isCompleted());
            }
        }
    }
}

