/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcCall {
    @Test
    public void testConstructor() {
        CredentialsNone credential = new CredentialsNone();
        VerifierNone verifier = new VerifierNone();
        int rpcVersion = 2;
        int program = 2;
        int version = 3;
        int procedure = 4;
        RpcCall call = new RpcCall(0, RpcMessage.Type.RPC_CALL, rpcVersion, program, version, procedure, (Credentials)credential, (Verifier)verifier);
        Assertions.assertEquals((int)0, (int)call.getXid());
        Assertions.assertEquals((Object)RpcMessage.Type.RPC_CALL, (Object)call.getMessageType());
        Assertions.assertEquals((int)rpcVersion, (int)call.getRpcVersion());
        Assertions.assertEquals((int)program, (int)call.getProgram());
        Assertions.assertEquals((int)version, (int)call.getVersion());
        Assertions.assertEquals((int)procedure, (int)call.getProcedure());
        Assertions.assertEquals((Object)credential, (Object)call.getCredential());
        Assertions.assertEquals((Object)verifier, (Object)call.getVerifier());
    }

    @Test
    public void testInvalidRpcVersion() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            int invalidRpcVersion = 3;
            new RpcCall(0, RpcMessage.Type.RPC_CALL, invalidRpcVersion, 2, 3, 4, null, null);
        });
    }

    @Test
    public void testInvalidRpcMessageType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            RpcMessage.Type invalidMessageType = RpcMessage.Type.RPC_REPLY;
            new RpcCall(0, invalidMessageType, 2, 2, 3, 4, null, null);
        });
    }
}

