/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleTcpClient;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.event.Level;

public class TestFrameDecoder {
    private static int resultSize;

    static void testRequest(XDR request, int serverPort) {
        resultSize = 0;
        SimpleTcpClient tcpClient = new SimpleTcpClient("localhost", serverPort, request, Boolean.valueOf(true));
        tcpClient.run();
    }

    @Test
    public void testSingleFrame() {
        RpcUtil.RpcFrameDecoder decoder = new RpcUtil.RpcFrameDecoder();
        ByteBuf buf = Unpooled.directBuffer((int)1);
        ArrayList outputBufs = new ArrayList();
        decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), buf, outputBufs);
        Assertions.assertTrue((boolean)outputBufs.isEmpty());
        decoder = new RpcUtil.RpcFrameDecoder();
        byte[] fragment = new byte[13];
        fragment[0] = -128;
        fragment[1] = 0;
        fragment[2] = 0;
        fragment[3] = 10;
        Assertions.assertTrue((boolean)XDR.isLastFragment((byte[])fragment));
        Assertions.assertTrue((XDR.fragmentSize((byte[])fragment) == 10 ? 1 : 0) != 0);
        buf.release();
        buf = Unpooled.directBuffer((int)13);
        buf.writeBytes(fragment);
        outputBufs = new ArrayList();
        decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), buf, outputBufs);
        Assertions.assertTrue((boolean)decoder.isLast());
        buf.release();
    }

    @Test
    public void testMultipleFrames() {
        RpcUtil.RpcFrameDecoder decoder = new RpcUtil.RpcFrameDecoder();
        byte[] fragment1 = new byte[14];
        fragment1[0] = 0;
        fragment1[1] = 0;
        fragment1[2] = 0;
        fragment1[3] = 10;
        Assertions.assertFalse((boolean)XDR.isLastFragment((byte[])fragment1));
        Assertions.assertTrue((XDR.fragmentSize((byte[])fragment1) == 10 ? 1 : 0) != 0);
        ArrayList outputBufs = new ArrayList();
        ByteBuf buf = Unpooled.directBuffer((int)14, (int)14);
        buf.writeBytes(fragment1);
        decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), buf, outputBufs);
        byte[] fragment2 = new byte[14];
        fragment2[0] = -128;
        fragment2[1] = 0;
        fragment2[2] = 0;
        fragment2[3] = 10;
        Assertions.assertTrue((boolean)XDR.isLastFragment((byte[])fragment2));
        Assertions.assertTrue((XDR.fragmentSize((byte[])fragment2) == 10 ? 1 : 0) != 0);
        buf.release();
        buf = Unpooled.directBuffer((int)14, (int)14);
        buf.writeBytes(fragment2);
        decoder.decode((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), buf, outputBufs);
        decoder.isLast();
        Assertions.assertEquals((int)2, (int)outputBufs.size());
        outputBufs.forEach(b -> Assertions.assertEquals((int)((ByteBuf)b).readableBytes(), (int)10));
        buf.release();
    }

    @Test
    public void testFrames() throws InterruptedException {
        int serverPort = TestFrameDecoder.startRpcServer(true);
        XDR xdrOut = TestFrameDecoder.createGetportMount();
        int headerSize = xdrOut.size();
        int bufsize = 0x200000;
        byte[] buffer = new byte[bufsize];
        xdrOut.writeFixedOpaque(buffer);
        int requestSize = xdrOut.size() - headerSize;
        TestFrameDecoder.testRequest(xdrOut, serverPort);
        Assertions.assertEquals((int)requestSize, (int)resultSize);
    }

    @Test
    public void testUnprivilegedPort() throws InterruptedException {
        int serverPort = TestFrameDecoder.startRpcServer(false);
        XDR xdrOut = TestFrameDecoder.createGetportMount();
        int bufsize = 0x200000;
        byte[] buffer = new byte[bufsize];
        xdrOut.writeFixedOpaque(buffer);
        TestFrameDecoder.testRequest(xdrOut, serverPort);
        Assertions.assertEquals((int)0, (int)resultSize);
        xdrOut = new XDR();
        TestFrameDecoder.createPortmapXDRheader(xdrOut, 0);
        int headerSize = xdrOut.size();
        buffer = new byte[bufsize];
        xdrOut.writeFixedOpaque(buffer);
        int requestSize = xdrOut.size() - headerSize;
        TestFrameDecoder.testRequest(xdrOut, serverPort);
        Assertions.assertEquals((int)requestSize, (int)resultSize);
    }

    private static int startRpcServer(boolean allowInsecurePorts) throws InterruptedException {
        Random rand = new Random();
        int serverPort = 30000 + rand.nextInt(10000);
        int retries = 10;
        while (true) {
            SimpleTcpServer tcpServer = null;
            try {
                TestRpcProgram program = new TestRpcProgram("TestRpcProgram", "localhost", serverPort, 100000, 1, 2, allowInsecurePorts);
                tcpServer = new SimpleTcpServer(serverPort, (RpcProgram)program, 1);
                tcpServer.run();
            }
            catch (ChannelException | InterruptedException e) {
                if (tcpServer != null) {
                    tcpServer.shutdown();
                }
                if (retries-- > 0) {
                    serverPort += rand.nextInt(20);
                    continue;
                }
                throw e;
            }
            break;
        }
        return serverPort;
    }

    static void createPortmapXDRheader(XDR xdr_out, int procedure) {
        RpcCall.getInstance((int)0, (int)100000, (int)2, (int)procedure, (Credentials)new CredentialsNone(), (Verifier)new VerifierNone()).write(xdr_out);
    }

    static XDR createGetportMount() {
        XDR xdr_out = new XDR();
        TestFrameDecoder.createPortmapXDRheader(xdr_out, 3);
        return xdr_out;
    }

    static {
        GenericTestUtils.setLogLevel(RpcProgram.LOG, Level.TRACE);
    }

    @ChannelHandler.Sharable
    static class TestRpcProgram
    extends RpcProgram {
        protected TestRpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion, boolean allowInsecurePorts) {
            super(program, host, port, progNumber, lowProgVersion, highProgVersion, null, allowInsecurePorts);
        }

        protected void handleInternal(ChannelHandlerContext ctx, RpcInfo info) {
            boolean portMonitorSuccess;
            RpcCall rpcCall = (RpcCall)info.header();
            int procedure = rpcCall.getProcedure();
            if (procedure != 0 && !(portMonitorSuccess = this.doPortMonitoring(info.remoteAddress()))) {
                TestRpcProgram.sendRejectedReply((RpcCall)rpcCall, (SocketAddress)info.remoteAddress(), (ChannelHandlerContext)ctx);
                return;
            }
            resultSize = info.data().readableBytes();
            RpcAcceptedReply reply = RpcAcceptedReply.getAcceptInstance((int)1234, (Verifier)new VerifierNone());
            XDR out = new XDR();
            reply.write(out);
            ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
            RpcResponse rsp = new RpcResponse(b, info.remoteAddress());
            RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
        }

        protected boolean isIdempotent(RpcCall call) {
            return false;
        }
    }
}

