/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.util.MetricsCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMetricsCache {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetricsCache.class);

    @Test
    public void testUpdate() {
        MetricsCache cache = new MetricsCache();
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv")), Arrays.asList(this.makeMetric("m", 0), this.makeMetric("m1", 1)));
        MetricsCache.Record cr = cache.update(mr);
        ((MetricsRecord)Mockito.verify((Object)mr)).name();
        ((MetricsRecord)Mockito.verify((Object)mr)).tags();
        ((MetricsRecord)Mockito.verify((Object)mr)).metrics();
        Assertions.assertEquals((int)cr.metrics().size(), (int)((Collection)mr.metrics()).size(), (String)"same record size");
        Assertions.assertEquals((Object)0, (Object)cr.getMetric("m"), (String)"same metric value");
        MetricsRecord mr2 = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv")), Arrays.asList(this.makeMetric("m", 2), this.makeMetric("m2", 42)));
        cr = cache.update(mr2);
        Assertions.assertEquals((int)3, (int)cr.metrics().size(), (String)"contains 3 metric");
        this.checkMetricValue("updated metric value", cr, "m", 2);
        this.checkMetricValue("old metric value", cr, "m1", 1);
        this.checkMetricValue("new metric value", cr, "m2", 42);
        MetricsRecord mr3 = this.makeRecord("r", Arrays.asList(this.makeTag("t", "tv3")), Arrays.asList(this.makeMetric("m3", 3)));
        cr = cache.update(mr3);
        Assertions.assertEquals((int)1, (int)cr.metrics().size(), (String)"contains 1 metric");
        this.checkMetricValue("updated metric value", cr, "m3", 3);
        Assertions.assertEquals((int)0, (int)cr.tags().size(), (String)"no tags");
        cr = cache.update(mr3, true);
        Assertions.assertEquals((int)1, (int)cr.tags().size(), (String)"Got 1 tag");
        Assertions.assertEquals((Object)"tv3", (Object)cr.getTag("t"), (String)"Tag value");
        this.checkMetricValue("Metric value", cr, "m3", 3);
    }

    @Test
    public void testGet() {
        MetricsCache cache = new MetricsCache();
        Assertions.assertNull((Object)cache.get("r", Arrays.asList(this.makeTag("t", "t"))), (String)"empty");
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", "t")), Arrays.asList(this.makeMetric("m", 1)));
        cache.update(mr);
        MetricsCache.Record cr = cache.get("r", mr.tags());
        LOG.debug("tags=" + mr.tags() + " cr=" + cr);
        Assertions.assertNotNull((Object)cr, (String)"Got record");
        Assertions.assertEquals((int)1, (int)cr.metrics().size(), (String)"contains 1 metric");
        this.checkMetricValue("new metric value", cr, "m", 1);
    }

    @Test
    public void testNullTag() {
        MetricsCache cache = new MetricsCache();
        MetricsRecord mr = this.makeRecord("r", Arrays.asList(this.makeTag("t", null)), Arrays.asList(this.makeMetric("m", 0), this.makeMetric("m1", 1)));
        MetricsCache.Record cr = cache.update(mr);
        Assertions.assertTrue((null == cr.getTag("t") ? 1 : 0) != 0, (String)"t value should be null");
    }

    @Test
    public void testOverflow() {
        MetricsCache cache = new MetricsCache();
        List<MetricsTag> t0 = Arrays.asList(this.makeTag("t0", "0"));
        for (int i = 0; i < 1001; ++i) {
            MetricsCache.Record cr = cache.update(this.makeRecord("r", Arrays.asList(this.makeTag("t" + i, "" + i)), Arrays.asList(this.makeMetric("m", i))));
            this.checkMetricValue("new metric value", cr, "m", i);
            if (i >= 1000) continue;
            Assertions.assertNotNull((Object)cache.get("r", t0), (String)"t0 is still there");
        }
        Assertions.assertNull((Object)cache.get("r", t0), (String)"t0 is gone");
    }

    private void checkMetricValue(String description, MetricsCache.Record cr, String key, Number val) {
        Assertions.assertEquals((Object)val, (Object)cr.getMetric(key), (String)description);
        Assertions.assertNotNull((Object)cr.getMetricInstance(key), (String)"metric not null");
        Assertions.assertEquals((Object)val, (Object)cr.getMetricInstance(key).value(), (String)description);
    }

    private MetricsRecord makeRecord(String name, Collection<MetricsTag> tags, Collection<AbstractMetric> metrics) {
        MetricsRecord mr = (MetricsRecord)Mockito.mock(MetricsRecord.class);
        Mockito.when((Object)mr.name()).thenReturn((Object)name);
        Mockito.when((Object)mr.tags()).thenReturn(tags);
        Mockito.when((Object)mr.metrics()).thenReturn(metrics);
        return mr;
    }

    private MetricsTag makeTag(String name, String value) {
        return new MetricsTag(Interns.info((String)name, (String)""), value);
    }

    private AbstractMetric makeMetric(String name, Number value) {
        AbstractMetric metric = (AbstractMetric)Mockito.mock(AbstractMetric.class);
        Mockito.when((Object)metric.name()).thenReturn((Object)name);
        Mockito.when((Object)metric.value()).thenReturn((Object)value);
        return metric;
    }
}

