/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.metrics2.util.DummyMXBean;
import org.apache.hadoop.metrics2.util.MBeans;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMBeans
implements DummyMXBean {
    private int counter = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testRegister() throws Exception {
        ObjectName objectName = null;
        try {
            this.counter = 23;
            objectName = MBeans.register((String)"UnitTest", (String)"RegisterTest", (Object)this);
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            int jmxCounter = (Integer)platformMBeanServer.getAttribute(objectName, "Counter");
            Assertions.assertEquals((int)this.counter, (int)jmxCounter);
            if (objectName == null) return;
        }
        catch (Throwable throwable) {
            if (objectName == null) throw throwable;
            MBeans.unregister(objectName);
            throw throwable;
        }
        MBeans.unregister((ObjectName)objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testRegisterWithAdditionalProperties() throws Exception {
        ObjectName objectName = null;
        try {
            this.counter = 42;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("flavour", "server");
            objectName = MBeans.register((String)"UnitTest", (String)"RegisterTest", properties, (Object)this);
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            int jmxCounter = (Integer)platformMBeanServer.getAttribute(objectName, "Counter");
            Assertions.assertEquals((int)this.counter, (int)jmxCounter);
            if (objectName == null) return;
        }
        catch (Throwable throwable) {
            if (objectName == null) throw throwable;
            MBeans.unregister(objectName);
            throw throwable;
        }
        MBeans.unregister((ObjectName)objectName);
    }

    @Test
    public void testGetMbeanNameName() {
        HashMap<String, String> properties = new HashMap<String, String>();
        ObjectName mBeanName = MBeans.getMBeanName((String)"Service", (String)"Name", properties);
        Assertions.assertEquals((Object)"Service", (Object)MBeans.getMbeanNameService((ObjectName)mBeanName));
        properties.put("key", "value");
        mBeanName = MBeans.getMBeanName((String)"Service", (String)"Name", properties);
        Assertions.assertEquals((Object)"Service", (Object)MBeans.getMbeanNameService((ObjectName)mBeanName));
    }

    @Override
    public int getCounter() {
        return this.counter;
    }
}

