/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.source;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.metrics2.source.JvmMetricsInfo;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.GcTimeMonitor;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=30L)
public class TestJvmMetrics {
    private JvmPauseMonitor pauseMonitor;
    private GcTimeMonitor gcTimeMonitor;

    @AfterEach
    public void teardown() {
        ServiceOperations.stop((Service)this.pauseMonitor);
        if (this.gcTimeMonitor != null) {
            this.gcTimeMonitor.shutdown();
        }
    }

    @Test
    public void testJvmPauseMonitorPresence() {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        JvmMetrics jvmMetrics = new JvmMetrics("test", "test", false);
        jvmMetrics.setPauseMonitor(this.pauseMonitor);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)jvmMetrics);
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.ProcessName, "test");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.SessionId, "test");
        for (JvmMetricsInfo info : JvmMetricsInfo.values()) {
            if (info.name().startsWith("Mem")) {
                ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyFloat());
                continue;
            }
            if (!info.name().startsWith("Threads")) continue;
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyInt());
        }
    }

    @Test
    public void testGcTimeMonitorPresence() {
        this.gcTimeMonitor = new GcTimeMonitor(60000L, 1000L, 70, null);
        this.gcTimeMonitor.start();
        JvmMetrics jvmMetrics = new JvmMetrics("test", "test", false);
        jvmMetrics.setGcTimeMonitor(this.gcTimeMonitor);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)jvmMetrics);
        MetricsCollector mc = rb.parent();
        ((MetricsCollector)Mockito.verify((Object)mc)).addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics);
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.ProcessName, "test");
        ((MetricsRecordBuilder)Mockito.verify((Object)rb)).tag((MetricsInfo)MsInfo.SessionId, "test");
        for (JvmMetricsInfo info : JvmMetricsInfo.values()) {
            if (!info.name().equals("GcTimePercentage")) continue;
            ((MetricsRecordBuilder)Mockito.verify((Object)rb)).addGauge((MetricsInfo)Mockito.eq((Object)info), Mockito.anyInt());
        }
    }

    @Test
    public void testDoubleStop() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        this.pauseMonitor.stop();
        this.pauseMonitor.stop();
    }

    @Test
    public void testDoubleStart() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        this.pauseMonitor.init(new Configuration());
        this.pauseMonitor.start();
        this.pauseMonitor.start();
        this.pauseMonitor.stop();
    }

    @Test
    public void testStopBeforeStart() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        try {
            this.pauseMonitor.init(new Configuration());
            this.pauseMonitor.stop();
            this.pauseMonitor.start();
            Assertions.fail((String)("Expected an exception, got " + this.pauseMonitor));
        }
        catch (ServiceStateException e) {
            GenericTestUtils.assertExceptionContains("cannot enter state", e);
        }
    }

    @Test
    public void testStopBeforeInit() throws Throwable {
        this.pauseMonitor = new JvmPauseMonitor();
        try {
            this.pauseMonitor.stop();
            this.pauseMonitor.init(new Configuration());
            Assertions.fail((String)("Expected an exception, got " + this.pauseMonitor));
        }
        catch (ServiceStateException e) {
            GenericTestUtils.assertExceptionContains("cannot enter state", e);
        }
    }

    @Test
    public void testGcTimeMonitor() {
        class Alerter
        implements GcTimeMonitor.GcTimeAlertHandler {
            private volatile int numAlerts;
            private volatile int maxGcTimePercentage;

            Alerter() {
            }

            public void alert(GcTimeMonitor.GcData gcData) {
                ++this.numAlerts;
                if (gcData.getGcTimePercentage() > this.maxGcTimePercentage) {
                    this.maxGcTimePercentage = gcData.getGcTimePercentage();
                }
            }
        }
        Alerter alerter = new Alerter();
        int alertGcPerc = 10;
        this.gcTimeMonitor = new GcTimeMonitor(60000L, 100L, alertGcPerc, (GcTimeMonitor.GcTimeAlertHandler)alerter);
        this.gcTimeMonitor.start();
        int maxGcTimePercentage = 0;
        long gcCount = 0L;
        ArrayList<CallSite> garbageStrings = new ArrayList<CallSite>();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 1000L) {
            for (int j = 0; j < 100000; ++j) {
                garbageStrings.add((CallSite)((Object)("Long string prefix just to fill memory with garbage " + j)));
            }
            garbageStrings.clear();
            System.gc();
            GcTimeMonitor.GcData gcData = this.gcTimeMonitor.getLatestGcData();
            int gcTimePercentage = gcData.getGcTimePercentage();
            if (gcTimePercentage > maxGcTimePercentage) {
                maxGcTimePercentage = gcTimePercentage;
            }
            gcCount = gcData.getAccumulatedGcCount();
        }
        Assertions.assertTrue((maxGcTimePercentage > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((gcCount > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((alerter.numAlerts > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((alerter.maxGcTimePercentage >= alertGcPerc ? 1 : 0) != 0);
    }

    @Test
    public void testJvmMetricsSingletonWithSameProcessName() {
        JvmMetrics jvmMetrics1 = JvmMetrics.initSingleton((String)"test", null);
        JvmMetrics jvmMetrics2 = JvmMetrics.initSingleton((String)"test", null);
        Assertions.assertEquals((Object)jvmMetrics1, (Object)jvmMetrics2, (String)"initSingleton should return the singleton instance");
    }

    @Test
    public void testJvmMetricsSingletonWithDifferentProcessNames() {
        String process1Name = "process1";
        JvmMetrics jvmMetrics1 = JvmMetrics.initSingleton((String)"process1", null);
        String process2Name = "process2";
        JvmMetrics jvmMetrics2 = JvmMetrics.initSingleton((String)"process2", null);
        Assertions.assertEquals((Object)jvmMetrics1, (Object)jvmMetrics2, (String)"initSingleton should return the singleton instance");
        Assertions.assertEquals((Object)"process1", (Object)jvmMetrics1.processName, (String)"unexpected process name of the singleton instance");
        Assertions.assertEquals((Object)"process1", (Object)jvmMetrics2.processName, (String)"unexpected process name of the singleton instance");
    }

    @Test
    public void testGetMetricsPerf() {
        JvmMetrics jvmMetricsUseMXBean = new JvmMetrics("test", "test", true);
        JvmMetrics jvmMetrics = new JvmMetrics("test", "test", false);
        MetricsCollectorImpl collector = new MetricsCollectorImpl();
        jvmMetrics.getMetrics((MetricsCollector)collector, true);
        jvmMetricsUseMXBean.getMetrics((MetricsCollector)collector, true);
        int[] numThreadsCases = new int[]{100, 200, 500, 1000, 2000, 3000};
        ArrayList<TestThread> threads = new ArrayList<TestThread>();
        for (int numThreads : numThreadsCases) {
            TestJvmMetrics.updateThreadsAndWait(threads, numThreads);
            long startNs = System.nanoTime();
            jvmMetricsUseMXBean.getMetrics((MetricsCollector)collector, true);
            long processingNsFromMXBean = System.nanoTime() - startNs;
            startNs = System.nanoTime();
            jvmMetrics.getMetrics((MetricsCollector)collector, true);
            long processingNsFromGroup = System.nanoTime() - startNs;
            System.out.println("#Threads=" + numThreads + ", ThreadMXBean=" + processingNsFromMXBean + " ns, ThreadGroup=" + processingNsFromGroup + " ns, ratio: " + processingNsFromMXBean / processingNsFromGroup);
        }
        TestJvmMetrics.updateThreadsAndWait(threads, 0);
    }

    private static void updateThreadsAndWait(List<TestThread> threads, int expectedNumThreads) {
        int addNum = expectedNumThreads - threads.size();
        if (addNum > 0) {
            for (int i = 0; i < addNum; ++i) {
                TestThread testThread = new TestThread();
                testThread.start();
                threads.add(testThread);
            }
        } else if (addNum < 0) {
            for (int i = 0; i < Math.abs(addNum); ++i) {
                threads.get((int)i).exit = true;
            }
        } else {
            return;
        }
        while (true) {
            Iterator<TestThread> it = threads.iterator();
            while (it.hasNext()) {
                if (!it.next().exited) continue;
                it.remove();
            }
            if (threads.size() == expectedNumThreads) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static class TestThread
    extends Thread {
        private volatile boolean exit = false;
        private boolean exited = false;

        TestThread() {
        }

        @Override
        public void run() {
            while (!this.exit) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.exited = true;
        }
    }
}

