/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.File;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSinkTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRollingFileSystemSinkWithLocal
extends RollingFileSystemSinkTestBase {
    @Test
    public void testWrite() throws Exception {
        String path = methodDir.toURI().toString();
        MetricsSystem ms = this.initMetricsSystem(path, false, false);
        this.assertMetricsContents(this.doWriteTest(ms, path, 1));
    }

    @Test
    public void testSilentWrite() throws Exception {
        String path = methodDir.toURI().toString();
        MetricsSystem ms = this.initMetricsSystem(path, true, false);
        this.assertMetricsContents(this.doWriteTest(ms, path, 1));
    }

    @Test
    public void testExistingWrite() throws Exception {
        String path = methodDir.toURI().toString();
        this.assertMetricsContents(this.doAppendTest(path, false, false, 2));
    }

    @Test
    public void testExistingWrite2() throws Exception {
        String path = methodDir.toURI().toString();
        MetricsSystem ms = this.initMetricsSystem(path, false, false);
        this.preCreateLogFile(path, 2);
        this.assertMetricsContents(this.doWriteTest(ms, path, 3));
    }

    @Test
    public void testSilentExistingWrite() throws Exception {
        String path = methodDir.toURI().toString();
        this.assertMetricsContents(this.doAppendTest(path, false, false, 2));
    }

    @Test
    public void testFailedWrite() {
        String path = methodDir.toURI().toString();
        MetricsSystem ms = this.initMetricsSystem(path, false, false);
        new RollingFileSystemSinkTestBase.MyMetrics1(this).registerWith(ms);
        Assertions.assertTrue((boolean)FileUtil.setWritable((File)methodDir, (boolean)false));
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        try {
            ms.publishMetricsNow();
            Assertions.assertTrue((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"No exception was generated while writing metrics even though the target directory was not writable");
            ms.stop();
            ms.shutdown();
        }
        finally {
            methodDir.setWritable(true);
        }
    }

    @Test
    public void testSilentFailedWrite() {
        String path = methodDir.toURI().toString();
        MetricsSystem ms = this.initMetricsSystem(path, true, false);
        new RollingFileSystemSinkTestBase.MyMetrics1(this).registerWith(ms);
        Assertions.assertTrue((boolean)FileUtil.setWritable((File)methodDir, (boolean)false));
        RollingFileSystemSinkTestBase.MockSink.errored = false;
        try {
            ms.publishMetricsNow();
            Assertions.assertFalse((boolean)RollingFileSystemSinkTestBase.MockSink.errored, (String)"An exception was generated while writing metrics when the target directory was not writable, even though the sink is set to ignore errors");
            ms.stop();
            ms.shutdown();
        }
        finally {
            methodDir.setWritable(true);
        }
    }
}

