/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.filter.TestPatternFilter;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordBuilderImpl;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetricsCollectorImpl {
    @Test
    public void recordBuilderShouldNoOpIfFiltered() {
        SubsetConfiguration fc = new ConfigBuilder().add("p.exclude", "foo").subset("p");
        MetricsCollectorImpl mb = new MetricsCollectorImpl();
        mb.setRecordFilter((MetricsFilter)TestPatternFilter.newGlobFilter(fc));
        MetricsRecordBuilderImpl rb = mb.addRecord("foo");
        rb.tag(Interns.info((String)"foo", (String)""), "value").addGauge(Interns.info((String)"g0", (String)""), 1);
        Assertions.assertEquals((int)0, (int)rb.tags().size(), (String)"no tags");
        Assertions.assertEquals((int)0, (int)rb.metrics().size(), (String)"no metrics");
        Assertions.assertNull((Object)rb.getRecord(), (String)"null record");
        Assertions.assertEquals((int)0, (int)mb.getRecords().size(), (String)"no records");
    }

    @Test
    public void testPerMetricFiltering() {
        SubsetConfiguration fc = new ConfigBuilder().add("p.exclude", "foo").subset("p");
        MetricsCollectorImpl mb = new MetricsCollectorImpl();
        mb.setMetricFilter((MetricsFilter)TestPatternFilter.newGlobFilter(fc));
        MetricsRecordBuilderImpl rb = mb.addRecord("foo");
        rb.tag(Interns.info((String)"foo", (String)""), "").addCounter(Interns.info((String)"c0", (String)""), 0).addGauge(Interns.info((String)"foo", (String)""), 1);
        Assertions.assertEquals((int)1, (int)rb.tags().size(), (String)"1 tag");
        Assertions.assertEquals((int)1, (int)rb.metrics().size(), (String)"1 metric");
        Assertions.assertEquals((Object)"foo", (Object)((MetricsTag)rb.tags().get(0)).name(), (String)"expect foo tag");
        Assertions.assertEquals((Object)"c0", (Object)((AbstractMetric)rb.metrics().get(0)).name(), (String)"expect c0");
    }
}

