/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.junit.jupiter.api.Assertions;

public class MetricsRecords {
    public static void assertTag(MetricsRecord record, String tagName, String expectedValue) {
        MetricsTag processIdTag = MetricsRecords.getFirstTagByName(record, tagName);
        Assertions.assertNotNull((Object)processIdTag);
        Assertions.assertEquals((Object)expectedValue, (Object)processIdTag.value());
    }

    public static void assertMetric(MetricsRecord record, String metricName, Number expectedValue) {
        AbstractMetric resourceLimitMetric = MetricsRecords.getFirstMetricByName(record, metricName);
        Assertions.assertNotNull((Object)resourceLimitMetric);
        Assertions.assertEquals((Object)expectedValue, (Object)resourceLimitMetric.value());
    }

    public static Number getMetricValueByName(MetricsRecord record, String metricName) {
        AbstractMetric resourceLimitMetric = MetricsRecords.getFirstMetricByName(record, metricName);
        Assertions.assertNotNull((Object)resourceLimitMetric);
        return resourceLimitMetric.value();
    }

    public static void assertMetricNotNull(MetricsRecord record, String metricName) {
        AbstractMetric resourceLimitMetric = MetricsRecords.getFirstMetricByName(record, metricName);
        Assertions.assertNotNull((Object)resourceLimitMetric, (String)("Metric " + metricName + " doesn't exist"));
    }

    private static MetricsTag getFirstTagByName(MetricsRecord record, String name) {
        if (record.tags() == null) {
            return null;
        }
        return record.tags().stream().filter(new MetricsTagPredicate(name)).findFirst().orElse(null);
    }

    private static AbstractMetric getFirstMetricByName(MetricsRecord record, String name) {
        if (record.metrics() == null) {
            return null;
        }
        return StreamSupport.stream(record.metrics().spliterator(), false).filter(new AbstractMetricPredicate(name)).findFirst().orElse(null);
    }

    private static class MetricsTagPredicate
    implements Predicate<MetricsTag> {
        private String tagName;

        public MetricsTagPredicate(String tagName) {
            this.tagName = tagName;
        }

        @Override
        public boolean test(MetricsTag input) {
            return input.name().equals(this.tagName);
        }
    }

    private static class AbstractMetricPredicate
    implements Predicate<AbstractMetric> {
        private String metricName;

        public AbstractMetricPredicate(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public boolean test(AbstractMetric input) {
            return input.name().equals(this.metricName);
        }
    }
}

