/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.WeightedRoundRobinMultiplexer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWeightedRoundRobinMultiplexer {
    public static final Logger LOG = LoggerFactory.getLogger(TestWeightedRoundRobinMultiplexer.class);
    private WeightedRoundRobinMultiplexer mux;

    @Test
    public void testInstantiateNegativeMux() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            this.mux = new WeightedRoundRobinMultiplexer(-1, "", new Configuration());
        });
    }

    @Test
    public void testInstantiateZeroMux() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            this.mux = new WeightedRoundRobinMultiplexer(0, "", new Configuration());
        });
    }

    @Test
    public void testInstantiateIllegalMux() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Configuration conf = new Configuration();
            conf.setStrings("namespace.faircallqueue.multiplexer.weights", new String[]{"1", "2", "3"});
            this.mux = new WeightedRoundRobinMultiplexer(2, "namespace", conf);
        });
    }

    @Test
    public void testLegalInstantiation() {
        Configuration conf = new Configuration();
        conf.setStrings("namespace.faircallqueue.multiplexer.weights", new String[]{"1", "2", "3"});
        this.mux = new WeightedRoundRobinMultiplexer(3, "namespace.", conf);
    }

    @Test
    public void testDefaultPattern() {
        this.mux = new WeightedRoundRobinMultiplexer(1, "", new Configuration());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        }
        this.mux = new WeightedRoundRobinMultiplexer(2, "", new Configuration());
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        this.mux = new WeightedRoundRobinMultiplexer(3, "", new Configuration());
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isEqualTo(2);
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        this.mux = new WeightedRoundRobinMultiplexer(4, "", new Configuration());
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isEqualTo(2);
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isEqualTo(2);
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isEqualTo(3);
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
    }

    @Test
    public void testCustomPattern() {
        Configuration conf = new Configuration();
        conf.setStrings("test.custom.faircallqueue.multiplexer.weights", new String[]{"1", "1"});
        this.mux = new WeightedRoundRobinMultiplexer(2, "test.custom", conf);
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
        Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
        conf.setStrings("test.custom.faircallqueue.multiplexer.weights", new String[]{"1", "3", "2"});
        this.mux = new WeightedRoundRobinMultiplexer(3, "test.custom", conf);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isZero();
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isOne();
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isEqualTo(2);
            Assertions.assertThat((int)this.mux.getAndAdvanceCurrentIndex()).isEqualTo(2);
        }
    }
}

