/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.IpcException;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientException;
import org.apache.hadoop.ipc.RpcServerException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.test.MockitoUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TestServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBind() throws Exception {
        Configuration conf = new Configuration();
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        socket.bind(address);
        try {
            int min = socket.getLocalPort();
            int max = min + 100;
            conf.set("TestRange", min + "-" + max);
            ServerSocket socket2 = new ServerSocket();
            InetSocketAddress address2 = new InetSocketAddress("0.0.0.0", 0);
            Server.bind((ServerSocket)socket2, (InetSocketAddress)address2, (int)10, (Configuration)conf, (String)"TestRange");
            try {
                Assertions.assertTrue((boolean)socket2.isBound());
                Assertions.assertTrue((socket2.getLocalPort() > min ? 1 : 0) != 0);
                Assertions.assertTrue((socket2.getLocalPort() <= max ? 1 : 0) != 0);
            }
            finally {
                socket2.close();
            }
        }
        finally {
            socket.close();
        }
    }

    @Test
    public void testBindSimple() throws Exception {
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        Server.bind((ServerSocket)socket, (InetSocketAddress)address, (int)10);
        try {
            Assertions.assertTrue((boolean)socket.isBound());
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("TestRange", "");
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        try (ServerSocket socket = new ServerSocket();){
            Server.bind((ServerSocket)socket, (InetSocketAddress)address, (int)10, (Configuration)conf, (String)"TestRange");
            Assertions.assertTrue((boolean)socket.isBound());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindError() throws Exception {
        Configuration conf = new Configuration();
        ServerSocket socket = new ServerSocket();
        InetSocketAddress address = new InetSocketAddress("0.0.0.0", 0);
        socket.bind(address);
        try {
            int min = socket.getLocalPort();
            conf.set("TestRange", min + "-" + min);
            ServerSocket socket2 = new ServerSocket();
            InetSocketAddress address2 = new InetSocketAddress("0.0.0.0", 0);
            boolean caught = false;
            try {
                Server.bind((ServerSocket)socket2, (InetSocketAddress)address2, (int)10, (Configuration)conf, (String)"TestRange");
            }
            catch (BindException e) {
                caught = true;
            }
            finally {
                socket2.close();
            }
            Assertions.assertTrue((boolean)caught, (String)"Failed to catch the expected bind exception");
        }
        finally {
            socket.close();
        }
    }

    @Test
    @Timeout(value=300L)
    public void testLogExceptions() throws Exception {
        Configuration conf = new Configuration();
        Server.Call dummyCall = new Server.Call(0, 0, null, null);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Server server = new Server("0.0.0.0", 0, LongWritable.class, 1, conf){

            public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws Exception {
                return null;
            }
        };
        server.addSuppressedLoggingExceptions(new Class[]{TestException1.class});
        server.addTerseExceptions(new Class[]{TestException2.class});
        server.logException(logger, (Throwable)new TestException1(), dummyCall);
        MockitoUtil.verifyZeroInteractions(logger);
        server.logException(logger, (Throwable)new TestException2(), dummyCall);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).info((String)Mockito.any());
        TestException3 te3 = new TestException3();
        server.logException(logger, (Throwable)te3, dummyCall);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).info((String)Mockito.any(), (Throwable)Mockito.eq((Object)te3));
    }

    @Test
    public void testExceptionsHandlerTerse() {
        Server.ExceptionsHandler handler = new Server.ExceptionsHandler();
        handler.addTerseLoggingExceptions(new Class[]{IOException.class});
        handler.addTerseLoggingExceptions(new Class[]{RpcServerException.class, IpcException.class});
        Assertions.assertTrue((boolean)handler.isTerseLog(IOException.class));
        Assertions.assertTrue((boolean)handler.isTerseLog(RpcServerException.class));
        Assertions.assertTrue((boolean)handler.isTerseLog(IpcException.class));
        Assertions.assertFalse((boolean)handler.isTerseLog(RpcClientException.class));
    }

    @Test
    public void testExceptionsHandlerSuppressed() {
        Server.ExceptionsHandler handler = new Server.ExceptionsHandler();
        handler.addSuppressedLoggingExceptions(new Class[]{IOException.class});
        handler.addSuppressedLoggingExceptions(new Class[]{RpcServerException.class, IpcException.class});
        Assertions.assertTrue((boolean)handler.isSuppressedLog(IOException.class));
        Assertions.assertTrue((boolean)handler.isSuppressedLog(RpcServerException.class));
        Assertions.assertTrue((boolean)handler.isSuppressedLog(IpcException.class));
        Assertions.assertFalse((boolean)handler.isSuppressedLog(RpcClientException.class));
    }

    @Test
    @Timeout(value=300L)
    public void testPurgeIntervalNanosConf() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("ipc.server.purge.interval", 3);
        Server server = new Server("0.0.0.0", 0, LongWritable.class, 1, conf){

            public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws Exception {
                return null;
            }
        };
        long purgeInterval = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.MINUTES);
        Assertions.assertEquals((long)server.getPurgeIntervalNanos(), (long)purgeInterval);
    }

    static class TestException1
    extends Exception {
        TestException1() {
        }
    }

    static class TestException2
    extends Exception {
        TestException2() {
        }
    }

    static class TestException3
    extends Exception {
        TestException3() {
        }
    }
}

