/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RpcWritable;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.thirdparty.protobuf.Message;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRpcWritable {
    static Writable writable = new LongWritable(Time.now());
    static Message message1 = TestProtos.EchoRequestProto.newBuilder().setMessage("testing1").build();
    static Message message2 = TestProtos.EchoRequestProto.newBuilder().setMessage("testing2").build();

    @Test
    public void testWritableWrapper() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writable.write((DataOutput)new DataOutputStream(baos));
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        LongWritable actual = (LongWritable)RpcWritable.wrap((Object)new LongWritable()).readFrom(bb);
        Assertions.assertEquals((Object)writable, (Object)actual);
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testProtobufWrapper() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        message1.writeDelimitedTo((OutputStream)baos);
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        Message actual = (Message)RpcWritable.wrap((Object)TestProtos.EchoRequestProto.getDefaultInstance()).readFrom(bb);
        Assertions.assertEquals((Object)message1, (Object)actual);
        Assertions.assertEquals((int)0, (int)bb.remaining());
    }

    @Test
    public void testBufferWrapper() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        message1.writeDelimitedTo((OutputStream)dos);
        message2.writeDelimitedTo((OutputStream)dos);
        writable.write((DataOutput)dos);
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        RpcWritable.Buffer buf = RpcWritable.Buffer.wrap((ByteBuffer)bb);
        Assertions.assertEquals((int)baos.size(), (int)bb.remaining());
        Assertions.assertEquals((int)baos.size(), (int)buf.remaining());
        Object actual = buf.getValue((Object)TestProtos.EchoRequestProto.getDefaultInstance());
        Assertions.assertEquals((Object)message1, (Object)actual);
        Assertions.assertTrue((bb.remaining() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)bb.remaining(), (int)buf.remaining());
        actual = buf.getValue((Object)TestProtos.EchoRequestProto.getDefaultInstance());
        Assertions.assertEquals((Object)message2, (Object)actual);
        Assertions.assertTrue((bb.remaining() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)bb.remaining(), (int)buf.remaining());
        actual = buf.newInstance(LongWritable.class, null);
        Assertions.assertEquals((Object)writable, (Object)actual);
        Assertions.assertEquals((int)0, (int)bb.remaining());
        Assertions.assertEquals((int)0, (int)buf.remaining());
    }

    @Test
    public void testBufferWrapperNested() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        writable.write((DataOutput)dos);
        message1.writeDelimitedTo((OutputStream)dos);
        message2.writeDelimitedTo((OutputStream)dos);
        ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
        RpcWritable.Buffer buf1 = RpcWritable.Buffer.wrap((ByteBuffer)bb);
        Assertions.assertEquals((int)baos.size(), (int)bb.remaining());
        Assertions.assertEquals((int)baos.size(), (int)buf1.remaining());
        Object actual = buf1.newInstance(LongWritable.class, null);
        Assertions.assertEquals((Object)writable, (Object)actual);
        int left = bb.remaining();
        Assertions.assertTrue((left > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)left, (int)buf1.remaining());
        RpcWritable.Buffer buf2 = (RpcWritable.Buffer)buf1.newInstance(RpcWritable.Buffer.class, null);
        Assertions.assertEquals((int)0, (int)bb.remaining());
        Assertions.assertEquals((int)0, (int)buf1.remaining());
        Assertions.assertEquals((int)left, (int)buf2.remaining());
        actual = buf2.getValue((Object)TestProtos.EchoRequestProto.getDefaultInstance());
        Assertions.assertEquals((Object)message1, (Object)actual);
        Assertions.assertTrue((buf2.remaining() > 0 ? 1 : 0) != 0);
        actual = buf2.getValue((Object)TestProtos.EchoRequestProto.getDefaultInstance());
        Assertions.assertEquals((Object)message2, (Object)actual);
        Assertions.assertEquals((int)0, (int)buf2.remaining());
    }
}

