/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.ipc.ResponseBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResponseBuffer {
    @Test
    public void testBuffer() throws IOException {
        int startSize = 8;
        String empty = "";
        ResponseBuffer buf = new ResponseBuffer(8);
        Assertions.assertEquals((int)8, (int)buf.capacity());
        this.checkBuffer(buf, "");
        buf.writeBytes("");
        this.checkBuffer(buf, "");
        String s1 = "testing123";
        buf.writeBytes(s1);
        this.checkBuffer(buf, s1);
        String s2 = "456!";
        buf.writeBytes(s2);
        this.checkBuffer(buf, s1 + s2);
        int length = buf.capacity();
        buf.reset();
        Assertions.assertEquals((int)length, (int)buf.capacity());
        this.checkBuffer(buf, "");
        buf.setCapacity(8);
        Assertions.assertEquals((int)8, (int)buf.capacity());
        this.checkBuffer(buf, "");
        buf.writeBytes(s1);
        this.checkBuffer(buf, s1);
        buf.writeBytes(s2);
        this.checkBuffer(buf, s1 + s2);
    }

    private void checkBuffer(ResponseBuffer buf, String expected) throws IOException {
        int expectedLength = expected.getBytes().length;
        Assertions.assertEquals((int)expectedLength, (int)buf.size());
        byte[] framed = buf.toByteArray();
        Assertions.assertEquals((int)(expectedLength + 4), (int)framed.length);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(framed));
        Assertions.assertEquals((int)expectedLength, (int)dis.readInt());
        Assertions.assertEquals((int)expectedLength, (int)dis.available());
        byte[] payload = new byte[expectedLength];
        dis.readFully(payload);
        Assertions.assertEquals((Object)expected, (Object)new String(payload));
    }
}

