/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CostProvider;
import org.apache.hadoop.ipc.DecayRpcScheduler;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.WeightedTimeCostProvider;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestDecayRpcScheduler {
    private DecayRpcScheduler scheduler;

    private Schedulable mockCall(String id) {
        Schedulable mockCall = (Schedulable)Mockito.mock(Schedulable.class);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)id);
        Mockito.when((Object)mockCall.getUserGroupInformation()).thenReturn((Object)ugi);
        return mockCall;
    }

    @Test
    public void testNegativeScheduler() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            this.scheduler = new DecayRpcScheduler(-1, "", new Configuration());
        });
    }

    @Test
    public void testZeroScheduler() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            this.scheduler = new DecayRpcScheduler(0, "", new Configuration());
        });
    }

    @Test
    public void testParsePeriod() {
        this.scheduler = new DecayRpcScheduler(1, "ipc.1", new Configuration());
        Assertions.assertEquals((long)5000L, (long)this.scheduler.getDecayPeriodMillis());
        Configuration conf = new Configuration();
        conf.setLong("ipc.2.faircallqueue.decay-scheduler.period-ms", 1058L);
        this.scheduler = new DecayRpcScheduler(1, "ipc.2", conf);
        Assertions.assertEquals((long)1058L, (long)this.scheduler.getDecayPeriodMillis());
    }

    @Test
    public void testParsePeriodWithPortLessIdentityProvider() {
        this.scheduler = new DecayRpcScheduler(1, "ipc.50", new Configuration());
        Assertions.assertEquals((long)5000L, (long)this.scheduler.getDecayPeriodMillis());
        Configuration conf = new Configuration();
        conf.setLong("ipc.51.faircallqueue.decay-scheduler.period-ms", 1058L);
        conf.unset("ipc.51.identity-provider.impl");
        conf.set("ipc.identity-provider.impl", "org.apache.hadoop.ipc.TestDecayRpcScheduler$TestIdentityProvider");
        this.scheduler = new DecayRpcScheduler(1, "ipc.51", conf);
        Assertions.assertEquals((long)1058L, (long)this.scheduler.getDecayPeriodMillis());
    }

    @Test
    public void testParsePeriodWithPortLessCostProvider() {
        this.scheduler = new DecayRpcScheduler(1, "ipc.52", new Configuration());
        Assertions.assertEquals((long)5000L, (long)this.scheduler.getDecayPeriodMillis());
        Configuration conf = new Configuration();
        conf.setLong("ipc.52.faircallqueue.decay-scheduler.period-ms", 1058L);
        conf.unset("ipc.52.cost-provider.impl");
        conf.set("ipc.cost-provider.impl", "org.apache.hadoop.ipc.TestDecayRpcScheduler$TestCostProvider");
        this.scheduler = new DecayRpcScheduler(1, "ipc.52", conf);
        Assertions.assertEquals((long)1058L, (long)this.scheduler.getDecayPeriodMillis());
    }

    @Test
    public void testParseFactor() {
        this.scheduler = new DecayRpcScheduler(1, "ipc.3", new Configuration());
        Assertions.assertEquals((double)0.5, (double)this.scheduler.getDecayFactor(), (double)1.0E-5);
        Configuration conf = new Configuration();
        conf.set("ipc.4.faircallqueue.decay-scheduler.decay-factor", "0.125");
        this.scheduler = new DecayRpcScheduler(1, "ipc.4", conf);
        Assertions.assertEquals((double)0.125, (double)this.scheduler.getDecayFactor(), (double)1.0E-5);
    }

    public void assertEqualDecimalArrays(double[] a, double[] b) {
        Assertions.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            Assertions.assertEquals((double)a[i], (double)b[i], (double)1.0E-5);
        }
    }

    @Test
    public void testParseThresholds() {
        Configuration conf = new Configuration();
        this.scheduler = new DecayRpcScheduler(1, "ipc.5", conf);
        this.assertEqualDecimalArrays(new double[0], this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(2, "ipc.6", conf);
        this.assertEqualDecimalArrays(new double[]{0.5}, this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(3, "ipc.7", conf);
        this.assertEqualDecimalArrays(new double[]{0.25, 0.5}, this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(4, "ipc.8", conf);
        this.assertEqualDecimalArrays(new double[]{0.125, 0.25, 0.5}, this.scheduler.getThresholds());
        conf = new Configuration();
        conf.set("ipc.9.faircallqueue.decay-scheduler.thresholds", "1, 10, 20, 50, 85");
        this.scheduler = new DecayRpcScheduler(6, "ipc.9", conf);
        this.assertEqualDecimalArrays(new double[]{0.01, 0.1, 0.2, 0.5, 0.85}, this.scheduler.getThresholds());
    }

    @Test
    public void testAccumulate() {
        Configuration conf = new Configuration();
        conf.set("ipc.10.faircallqueue.decay-scheduler.period-ms", "99999999");
        this.scheduler = new DecayRpcScheduler(1, "ipc.10", conf);
        Assertions.assertEquals((int)0, (int)this.scheduler.getCallCostSnapshot().size());
        this.getPriorityIncrementCallCount("A");
        Assertions.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        this.getPriorityIncrementCallCount("A");
        this.getPriorityIncrementCallCount("B");
        this.getPriorityIncrementCallCount("A");
        Assertions.assertEquals((long)3L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
    }

    @Test
    public void testDecay() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.setLong("ipc.11.decay-scheduler.period-ms", 999999999L);
        conf.setDouble("ipc.11.decay-scheduler.decay-factor", 0.5);
        this.scheduler = new DecayRpcScheduler(1, "ipc.11", conf);
        Assertions.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        for (i = 0; i < 4; ++i) {
            this.getPriorityIncrementCallCount("A");
        }
        Thread.sleep(1000L);
        for (i = 0; i < 8; ++i) {
            this.getPriorityIncrementCallCount("B");
        }
        Assertions.assertEquals((long)12L, (long)this.scheduler.getTotalCallSnapshot());
        Assertions.assertEquals((long)4L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals((long)8L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assertions.assertEquals((long)6L, (long)this.scheduler.getTotalCallSnapshot());
        Assertions.assertEquals((long)2L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals((long)4L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assertions.assertEquals((long)3L, (long)this.scheduler.getTotalCallSnapshot());
        Assertions.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals((long)2L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assertions.assertEquals((long)1L, (long)this.scheduler.getTotalCallSnapshot());
        Assertions.assertEquals(null, (Long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assertions.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        Assertions.assertEquals(null, (Long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assertions.assertEquals(null, (Long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
    }

    @Test
    public void testPriority() throws Exception {
        Configuration conf = new Configuration();
        String namespace = "ipc.12";
        conf.set("ipc.12.faircallqueue.decay-scheduler.period-ms", "99999999");
        conf.set("ipc.12.faircallqueue.decay-scheduler.thresholds", "25, 50, 75");
        this.scheduler = new DecayRpcScheduler(4, "ipc.12", conf);
        Assertions.assertEquals((int)0, (int)this.getPriorityIncrementCallCount("A"));
        Assertions.assertEquals((int)3, (int)this.getPriorityIncrementCallCount("A"));
        Assertions.assertEquals((int)0, (int)this.getPriorityIncrementCallCount("B"));
        Assertions.assertEquals((int)1, (int)this.getPriorityIncrementCallCount("B"));
        Assertions.assertEquals((int)0, (int)this.getPriorityIncrementCallCount("C"));
        Assertions.assertEquals((int)0, (int)this.getPriorityIncrementCallCount("C"));
        Assertions.assertEquals((int)1, (int)this.getPriorityIncrementCallCount("A"));
        Assertions.assertEquals((int)1, (int)this.getPriorityIncrementCallCount("A"));
        Assertions.assertEquals((int)2, (int)this.getPriorityIncrementCallCount("A"));
        Assertions.assertEquals((int)2, (int)this.getPriorityIncrementCallCount("A"));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=ipc.12,name=DecayRpcScheduler");
        String cvs1 = (String)mbs.getAttribute(mxbeanName, "CallVolumeSummary");
        Assertions.assertTrue((boolean)cvs1.equals("{\"A\":6,\"B\":2,\"C\":2}"), (String)"Get expected JMX of CallVolumeSummary before decay");
        this.scheduler.forceDecay();
        String cvs2 = (String)mbs.getAttribute(mxbeanName, "CallVolumeSummary");
        Assertions.assertTrue((boolean)cvs2.equals("{\"A\":3,\"B\":1,\"C\":1}"), (String)"Get expected JMX for CallVolumeSummary after decay");
    }

    @Test
    @Timeout(value=2L)
    public void testPeriodic() throws InterruptedException {
        Configuration conf = new Configuration();
        conf.set("ipc.13.faircallqueue.decay-scheduler.period-ms", "10");
        conf.set("ipc.13.faircallqueue.decay-scheduler.decay-factor", "0.5");
        this.scheduler = new DecayRpcScheduler(1, "ipc.13", conf);
        Assertions.assertEquals((long)10L, (long)this.scheduler.getDecayPeriodMillis());
        Assertions.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        for (int i = 0; i < 64; ++i) {
            this.getPriorityIncrementCallCount("A");
        }
        while (this.scheduler.getTotalCallSnapshot() > 0L) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testNPEatInitialization() throws InterruptedException {
        PrintStream output = System.out;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            DefaultMetricsSystem.initialize((String)"NameNode");
            Configuration conf = new Configuration();
            this.scheduler = new DecayRpcScheduler(1, "ipc.14", conf);
            Assertions.assertFalse((boolean)bytes.toString().contains("NullPointerException"));
        }
        finally {
            System.setOut(output);
        }
    }

    @Test
    public void testUsingWeightedTimeCostProvider() {
        this.scheduler = TestDecayRpcScheduler.getSchedulerWithWeightedTimeCostProvider(3, "ipc.15");
        ProcessingDetails callDetailsLow = new ProcessingDetails(TimeUnit.MILLISECONDS);
        callDetailsLow.set(ProcessingDetails.Timing.LOCKFREE, 1L);
        ProcessingDetails callDetailsMedium = new ProcessingDetails(TimeUnit.MILLISECONDS);
        callDetailsMedium.set(ProcessingDetails.Timing.LOCKSHARED, 500L);
        ProcessingDetails callDetailsHigh = new ProcessingDetails(TimeUnit.MILLISECONDS);
        callDetailsHigh.set(ProcessingDetails.Timing.LOCKEXCLUSIVE, 100L);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.addResponseTime("ignored", this.mockCall("LOW"), callDetailsLow);
        }
        this.scheduler.addResponseTime("ignored", this.mockCall("MED"), callDetailsMedium);
        this.scheduler.addResponseTime("ignored", this.mockCall("HIGH"), callDetailsHigh);
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("LOW")));
        Assertions.assertEquals((int)1, (int)this.scheduler.getPriorityLevel(this.mockCall("MED")));
        Assertions.assertEquals((int)2, (int)this.scheduler.getPriorityLevel(this.mockCall("HIGH")));
        Assertions.assertEquals((int)3, (int)this.scheduler.getUniqueIdentityCount());
        long totalCallInitial = this.scheduler.getTotalRawCallVolume();
        Assertions.assertEquals((long)totalCallInitial, (long)this.scheduler.getTotalCallVolume());
        this.scheduler.forceDecay();
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("LOW")));
        Assertions.assertEquals((int)1, (int)this.scheduler.getPriorityLevel(this.mockCall("MED")));
        Assertions.assertEquals((int)2, (int)this.scheduler.getPriorityLevel(this.mockCall("HIGH")));
        Assertions.assertEquals((int)3, (int)this.scheduler.getUniqueIdentityCount());
        Assertions.assertEquals((long)totalCallInitial, (long)this.scheduler.getTotalRawCallVolume());
        Assertions.assertTrue((this.scheduler.getTotalCallVolume() < totalCallInitial ? 1 : 0) != 0);
        for (int i = 0; i < 100; ++i) {
            this.scheduler.forceDecay();
        }
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("LOW")));
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("MED")));
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("HIGH")));
    }

    @Test
    public void testUsingWeightedTimeCostProviderWithZeroCostCalls() {
        this.scheduler = TestDecayRpcScheduler.getSchedulerWithWeightedTimeCostProvider(2, "ipc.16");
        ProcessingDetails emptyDetails = new ProcessingDetails(TimeUnit.MILLISECONDS);
        for (int i = 0; i < 1000; ++i) {
            this.scheduler.addResponseTime("ignored", this.mockCall("MANY"), emptyDetails);
        }
        this.scheduler.addResponseTime("ignored", this.mockCall("FEW"), emptyDetails);
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("MANY")));
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("FEW")));
    }

    @Test
    public void testUsingWeightedTimeCostProviderNoRequests() {
        this.scheduler = TestDecayRpcScheduler.getSchedulerWithWeightedTimeCostProvider(2, "ipc.18");
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("A")));
    }

    private static DecayRpcScheduler getSchedulerWithWeightedTimeCostProvider(int priorityLevels, String ns) {
        Configuration conf = new Configuration();
        conf.setClass(ns + ".cost-provider.impl", WeightedTimeCostProvider.class, CostProvider.class);
        conf.setLong(ns + ".decay-scheduler.period-ms", 999999L);
        return new DecayRpcScheduler(priorityLevels, ns, conf);
    }

    private int getPriorityIncrementCallCount(String callId) {
        Schedulable mockCall = this.mockCall(callId);
        int priority = this.scheduler.getPriorityLevel(mockCall);
        ProcessingDetails emptyProcessingDetails = new ProcessingDetails(TimeUnit.MILLISECONDS);
        this.scheduler.addResponseTime("ignored", mockCall, emptyProcessingDetails);
        return priority;
    }

    @Test
    public void testServiceUsersCase1() {
        Configuration conf = new Configuration();
        conf.setLong("ipc.19.decay-scheduler.period-ms", 999999L);
        conf.set("ipc.19.decay-scheduler.service-users", "service1,service2");
        this.scheduler = new DecayRpcScheduler(4, "ipc.19", conf);
        Assertions.assertTrue((boolean)this.scheduler.getServiceUserNames().contains("service1"));
        Assertions.assertTrue((boolean)this.scheduler.getServiceUserNames().contains("service2"));
        for (int i = 0; i < 10; ++i) {
            this.getPriorityIncrementCallCount("user1");
            this.getPriorityIncrementCallCount("service1");
            this.getPriorityIncrementCallCount("service2");
        }
        Assertions.assertNotEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("user1")));
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("service1")));
        Assertions.assertEquals((int)0, (int)this.scheduler.getPriorityLevel(this.mockCall("service2")));
        this.scheduler.forceDecay();
        String summary = this.scheduler.getSchedulingDecisionSummary();
        Map summaryMap = (Map)JSON.parse((String)summary);
        Assertions.assertNotEquals((Object)0L, summaryMap.get("user1"));
        Assertions.assertEquals((Object)0L, summaryMap.get("service1"));
        Assertions.assertEquals((Object)0L, summaryMap.get("service2"));
    }

    @Test
    public void testServiceUsersCase2() {
        int i;
        int level = 4;
        Configuration conf = new Configuration();
        conf.setLong("ipc.20.decay-scheduler.period-ms", 999999L);
        conf.set("ipc.20.decay-scheduler.service-users", "service");
        conf.set("decay-scheduler.thresholds", "0.125,0.25,0.5");
        this.scheduler = new DecayRpcScheduler(4, "ipc.20", conf);
        for (i = 0; i < 10; ++i) {
            this.getPriorityIncrementCallCount("user1");
        }
        for (i = 0; i < 50; ++i) {
            this.getPriorityIncrementCallCount("service");
        }
        Assertions.assertEquals((long)10L, (long)this.scheduler.getTotalCallVolume());
        Assertions.assertEquals((long)10L, (long)this.scheduler.getTotalRawCallVolume());
        Assertions.assertEquals((long)50L, (long)this.scheduler.getTotalServiceUserCallVolume());
        Assertions.assertEquals((long)50L, (long)this.scheduler.getTotalServiceUserRawCallVolume());
        Assertions.assertEquals((int)3, (int)this.scheduler.getPriorityLevel(this.mockCall("user1")));
        this.scheduler.forceDecay();
        Assertions.assertEquals((long)5L, (long)this.scheduler.getTotalCallVolume());
        Assertions.assertEquals((long)10L, (long)this.scheduler.getTotalRawCallVolume());
        Assertions.assertEquals((long)25L, (long)this.scheduler.getTotalServiceUserCallVolume());
        Assertions.assertEquals((long)50L, (long)this.scheduler.getTotalServiceUserRawCallVolume());
        Assertions.assertEquals((int)3, (int)this.scheduler.getPriorityLevel(this.mockCall("user1")));
        for (i = 0; i < 10; ++i) {
            this.getPriorityIncrementCallCount("user1");
        }
        for (i = 0; i < 50; ++i) {
            this.getPriorityIncrementCallCount("service");
        }
        Assertions.assertEquals((long)15L, (long)this.scheduler.getTotalCallVolume());
        Assertions.assertEquals((long)20L, (long)this.scheduler.getTotalRawCallVolume());
        Assertions.assertEquals((long)75L, (long)this.scheduler.getTotalServiceUserCallVolume());
        Assertions.assertEquals((long)100L, (long)this.scheduler.getTotalServiceUserRawCallVolume());
        Assertions.assertEquals((int)3, (int)this.scheduler.getPriorityLevel(this.mockCall("user1")));
    }

    private static class TestCostProvider
    implements CostProvider {
        private TestCostProvider() {
        }

        public void init(String namespace, Configuration conf) {
        }

        public long getCost(ProcessingDetails details) {
            return 1L;
        }
    }

    private static class TestIdentityProvider
    implements IdentityProvider {
        private TestIdentityProvider() {
        }

        public String makeIdentity(Schedulable obj) {
            UserGroupInformation ugi = obj.getUserGroupInformation();
            if (ugi == null) {
                return null;
            }
            return ugi.getShortUserName();
        }
    }
}

