/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.apache.hadoop.io.erasurecode.rawcoder.DecodingValidator;
import org.apache.hadoop.io.erasurecode.rawcoder.InvalidDecodingException;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeXORRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.TestRawCoderBase;
import org.apache.hadoop.io.erasurecode.rawcoder.XORRawErasureCoderFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestDecodingValidator
extends TestRawCoderBase {
    private DecodingValidator validator;

    public static Collection<Object[]> data() {
        return Arrays.asList({RSRawErasureCoderFactory.class, 6, 3, new int[]{1}, new int[0]}, {RSRawErasureCoderFactory.class, 6, 3, new int[]{3}, new int[]{0}}, {RSRawErasureCoderFactory.class, 6, 3, new int[]{2, 4}, new int[]{1}}, {NativeRSRawErasureCoderFactory.class, 6, 3, new int[]{0}, new int[0]}, {XORRawErasureCoderFactory.class, 10, 1, new int[]{0}, new int[0]}, {NativeXORRawErasureCoderFactory.class, 10, 1, new int[]{0}, new int[0]});
    }

    public void initTestDecodingValidator(Class<? extends RawErasureCoderFactory> factoryClass, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) {
        this.encoderFactoryClass = factoryClass;
        this.decoderFactoryClass = factoryClass;
        this.numDataUnits = numDataUnits;
        this.numParityUnits = numParityUnits;
        this.erasedDataIndexes = erasedDataIndexes;
        this.erasedParityIndexes = erasedParityIndexes;
        this.setup();
    }

    public void setup() {
        if (this.encoderFactoryClass == NativeRSRawErasureCoderFactory.class || this.encoderFactoryClass == NativeXORRawErasureCoderFactory.class) {
            Assumptions.assumeTrue((boolean)ErasureCodeNative.isNativeCodeLoaded());
        }
        this.setAllowDump(false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testValidate(Class<? extends RawErasureCoderFactory> factoryClass, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) {
        this.initTestDecodingValidator(factoryClass, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes);
        this.prepare(null, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes);
        this.testValidate(true);
        this.testValidate(false);
    }

    protected void testValidate(boolean usingDirectBuffer) {
        this.usingDirectBuffer = usingDirectBuffer;
        this.prepareCoders(false);
        this.prepareValidator(false);
        this.performTestValidate(this.baseChunkSize);
        this.performTestValidate(this.baseChunkSize - 17);
        this.performTestValidate(this.baseChunkSize + 18);
    }

    protected void prepareValidator(boolean recreate) {
        if (this.validator == null || recreate) {
            this.validator = new DecodingValidator(this.decoder);
        }
    }

    protected void performTestValidate(int chunkSize) {
        this.setChunkSize(chunkSize);
        this.prepareBufferAllocator(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (Exception e) {
            Assertions.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        Object[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.markChunks((ECChunk[])inputChunks);
        this.ensureOnlyLeastRequiredChunks((ECChunk[])inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        int[] erasedIndexes = this.getErasedIndexesForDecoding();
        try {
            this.decoder.decode((ECChunk[])inputChunks, erasedIndexes, recoveredChunks);
        }
        catch (Exception e) {
            Assertions.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.restoreChunksFromMark((ECChunk[])inputChunks);
        ECChunk[] clonedInputChunks = this.cloneChunksWithData((ECChunk[])inputChunks);
        ECChunk[] clonedRecoveredChunks = this.cloneChunksWithData(recoveredChunks);
        int[] clonedErasedIndexes = (int[])erasedIndexes.clone();
        try {
            this.validator.validate(clonedInputChunks, clonedErasedIndexes, clonedRecoveredChunks);
        }
        catch (Exception e) {
            Assertions.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.verifyBufferPositionAtEnd(clonedInputChunks);
        this.verifyChunksEqual(recoveredChunks, clonedRecoveredChunks);
        Assertions.assertArrayEquals((int[])erasedIndexes, (int[])clonedErasedIndexes, (String)"Erased indexes should not be changed");
        List validIndexesList = IntStream.of(CoderUtil.getValidIndexes((Object[])inputChunks)).boxed().collect(Collectors.toList());
        List newValidIndexesList = IntStream.of(this.validator.getNewValidIndexes()).boxed().collect(Collectors.toList());
        List erasedIndexesList = IntStream.of(erasedIndexes).boxed().collect(Collectors.toList());
        int newErasedIndex = this.validator.getNewErasedIndex();
        Assertions.assertTrue((boolean)newValidIndexesList.containsAll(erasedIndexesList), (String)"Valid indexes for validation should contain erased indexes for decoding");
        Assertions.assertTrue((boolean)validIndexesList.contains(newErasedIndex), (String)"An erased index for validation should be contained in valid indexes for decoding");
        Assertions.assertFalse((boolean)newValidIndexesList.contains(newErasedIndex), (String)"An erased index for validation should not be contained in valid indexes for validation");
    }

    private void verifyChunksEqual(ECChunk[] chunks1, ECChunk[] chunks2) {
        boolean result = Arrays.deepEquals((Object[])this.toArrays(chunks1), (Object[])this.toArrays(chunks2));
        Assertions.assertTrue((boolean)result, (String)"Recovered chunks should not be changed");
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testValidateWithBadDecoding(Class<? extends RawErasureCoderFactory> factoryClass, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) throws IOException {
        this.initTestDecodingValidator(factoryClass, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes);
        this.prepare(null, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes);
        this.usingDirectBuffer = true;
        this.prepareCoders(true);
        this.prepareValidator(true);
        this.prepareBufferAllocator(false);
        ECChunk[] dataChunks = this.prepareDataChunksForEncoding();
        ECChunk[] parityChunks = this.prepareParityChunksForEncoding();
        ECChunk[] clonedDataChunks = this.cloneChunksWithData(dataChunks);
        try {
            this.encoder.encode(dataChunks, parityChunks);
        }
        catch (Exception e) {
            Assertions.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.backupAndEraseChunks(clonedDataChunks, parityChunks);
        ECChunk[] inputChunks = this.prepareInputChunksForDecoding(clonedDataChunks, parityChunks);
        this.markChunks(inputChunks);
        this.ensureOnlyLeastRequiredChunks(inputChunks);
        ECChunk[] recoveredChunks = this.prepareOutputChunksForDecoding();
        int[] erasedIndexes = this.getErasedIndexesForDecoding();
        try {
            this.decoder.decode(inputChunks, erasedIndexes, recoveredChunks);
        }
        catch (Exception e) {
            Assertions.fail((String)("Should not get Exception: " + e.getMessage()));
        }
        this.restoreChunksFromMark(inputChunks);
        this.polluteSomeChunk(recoveredChunks);
        try {
            this.validator.validate(inputChunks, erasedIndexes, recoveredChunks);
            Assertions.fail((String)"Validation should fail due to bad decoding");
        }
        catch (InvalidDecodingException e) {
            String expected = "Failed to validate decoding";
            GenericTestUtils.assertExceptionContains(expected, e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testIdempotentReleases(Class<? extends RawErasureCoderFactory> factoryClass, int numDataUnits, int numParityUnits, int[] erasedDataIndexes, int[] erasedParityIndexes) {
        this.initTestDecodingValidator(factoryClass, numDataUnits, numParityUnits, erasedDataIndexes, erasedParityIndexes);
        this.prepareCoders(true);
        for (int i = 0; i < 3; ++i) {
            this.encoder.release();
            this.decoder.release();
        }
    }

    @Override
    @Test
    public void testIdempotentReleases() {
    }
}

