/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.erasurecode.CodecUtil;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestErasureCodingEncodeAndDecode {
    private static final int CHUNCK = 1024;
    private static final int DATAB_LOCKS = 6;
    private static final int PARITY_BLOCKS = 3;
    private static final int TOTAL_BLOCKS = 9;

    @Test
    public void testEncodeAndDecode() throws Exception {
        int i;
        Configuration conf = new Configuration();
        int totalBytes = 6144;
        Random random = new Random();
        byte[] tmpBytes = new byte[totalBytes];
        random.nextBytes(tmpBytes);
        byte[][] data = new byte[6][1024];
        for (int i2 = 0; i2 < 6; ++i2) {
            System.arraycopy(tmpBytes, i2 * 1024, data[i2], 0, 1024);
        }
        ErasureCoderOptions coderOptions = new ErasureCoderOptions(6, 3);
        RawErasureEncoder encoder = CodecUtil.createRawEncoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        byte[][] parity = new byte[3][1024];
        encoder.encode(data, parity);
        byte[][] all = new byte[9][1024];
        for (i = 0; i < 6; ++i) {
            System.arraycopy(data[i], 0, all[i], 0, 1024);
        }
        for (i = 0; i < 3; ++i) {
            System.arraycopy(parity[i], 0, all[i + 6], 0, 1024);
        }
        RawErasureDecoder rawDecoder = CodecUtil.createRawDecoder((Configuration)conf, (String)"rs", (ErasureCoderOptions)coderOptions);
        byte[][] backup = new byte[3][1024];
        for (int i3 = 0; i3 < 9; ++i3) {
            for (int j = 0; j < 9; ++j) {
                for (int k = 0; k < 9; ++k) {
                    int[] erasedIndexes;
                    if (i3 == j && j == k) {
                        erasedIndexes = new int[]{i3};
                        backup[0] = all[i3];
                        all[i3] = null;
                    } else if (i3 == j) {
                        erasedIndexes = new int[]{i3, k};
                        backup[0] = all[i3];
                        backup[1] = all[k];
                        all[i3] = null;
                        all[k] = null;
                    } else if (i3 == k || j == k) {
                        erasedIndexes = new int[]{i3, j};
                        backup[0] = all[i3];
                        backup[1] = all[j];
                        all[i3] = null;
                        all[j] = null;
                    } else {
                        erasedIndexes = new int[]{i3, j, k};
                        backup[0] = all[i3];
                        backup[1] = all[j];
                        backup[2] = all[k];
                        all[i3] = null;
                        all[j] = null;
                        all[k] = null;
                    }
                    byte[][] decoded = new byte[erasedIndexes.length][1024];
                    rawDecoder.decode(all, erasedIndexes, decoded);
                    for (int l = 0; l < erasedIndexes.length; ++l) {
                        Assertions.assertArrayEquals((byte[])backup[l], (byte[])decoded[l]);
                        all[erasedIndexes[l]] = backup[l];
                    }
                }
            }
        }
    }
}

