/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.io.erasurecode.CodecRegistry;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeRSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.NativeXORRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RSLegacyRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RSRawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureEncoder;
import org.apache.hadoop.io.erasurecode.rawcoder.XORRawErasureCoderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCodecRegistry {
    @Test
    public void testGetCodecs() {
        Set codecs = CodecRegistry.getInstance().getCodecNames();
        Assertions.assertEquals((int)3, (int)codecs.size());
        Assertions.assertTrue((boolean)codecs.contains("rs"));
        Assertions.assertTrue((boolean)codecs.contains("rs-legacy"));
        Assertions.assertTrue((boolean)codecs.contains("xor"));
    }

    @Test
    public void testGetCoders() {
        List coders = CodecRegistry.getInstance().getCoders("rs");
        Assertions.assertEquals((int)2, (int)coders.size());
        Assertions.assertTrue((boolean)(coders.get(0) instanceof NativeRSRawErasureCoderFactory));
        Assertions.assertTrue((boolean)(coders.get(1) instanceof RSRawErasureCoderFactory));
        coders = CodecRegistry.getInstance().getCoders("rs-legacy");
        Assertions.assertEquals((int)1, (int)coders.size());
        Assertions.assertTrue((boolean)(coders.get(0) instanceof RSLegacyRawErasureCoderFactory));
        coders = CodecRegistry.getInstance().getCoders("xor");
        Assertions.assertEquals((int)2, (int)coders.size());
        Assertions.assertTrue((boolean)(coders.get(0) instanceof NativeXORRawErasureCoderFactory));
        Assertions.assertTrue((boolean)(coders.get(1) instanceof XORRawErasureCoderFactory));
    }

    @Test
    public void testGetCodersWrong() {
        List coders = CodecRegistry.getInstance().getCoders("WRONG_CODEC");
        Assertions.assertNull((Object)coders);
    }

    @Test
    public void testGetCoderNames() {
        String[] coderNames = CodecRegistry.getInstance().getCoderNames("rs");
        Assertions.assertEquals((int)2, (int)coderNames.length);
        Assertions.assertEquals((Object)"rs_native", (Object)coderNames[0]);
        Assertions.assertEquals((Object)"rs_java", (Object)coderNames[1]);
        coderNames = CodecRegistry.getInstance().getCoderNames("rs-legacy");
        Assertions.assertEquals((int)1, (int)coderNames.length);
        Assertions.assertEquals((Object)"rs-legacy_java", (Object)coderNames[0]);
        coderNames = CodecRegistry.getInstance().getCoderNames("xor");
        Assertions.assertEquals((int)2, (int)coderNames.length);
        Assertions.assertEquals((Object)"xor_native", (Object)coderNames[0]);
        Assertions.assertEquals((Object)"xor_java", (Object)coderNames[1]);
    }

    @Test
    public void testGetCoderByName() {
        RawErasureCoderFactory coder = CodecRegistry.getInstance().getCoderByName("rs", "rs_java");
        Assertions.assertTrue((boolean)(coder instanceof RSRawErasureCoderFactory));
        coder = CodecRegistry.getInstance().getCoderByName("rs", "rs_native");
        Assertions.assertTrue((boolean)(coder instanceof NativeRSRawErasureCoderFactory));
        coder = CodecRegistry.getInstance().getCoderByName("rs-legacy", "rs-legacy_java");
        Assertions.assertTrue((boolean)(coder instanceof RSLegacyRawErasureCoderFactory));
        coder = CodecRegistry.getInstance().getCoderByName("xor", "xor_java");
        Assertions.assertTrue((boolean)(coder instanceof XORRawErasureCoderFactory));
        coder = CodecRegistry.getInstance().getCoderByName("xor", "xor_native");
        Assertions.assertTrue((boolean)(coder instanceof NativeXORRawErasureCoderFactory));
    }

    @Test
    public void testGetCoderByNameWrong() {
        RawErasureCoderFactory coder = CodecRegistry.getInstance().getCoderByName("rs", "WRONG_RS");
        Assertions.assertNull((Object)coder);
    }

    @Test
    public void testUpdateCoders() {
        ArrayList<RSUserDefinedIncorrectFactory> userDefinedFactories = new ArrayList<RSUserDefinedIncorrectFactory>();
        class RSUserDefinedIncorrectFactory
        implements RawErasureCoderFactory {
            RSUserDefinedIncorrectFactory() {
            }

            public RawErasureEncoder createEncoder(ErasureCoderOptions coderOptions) {
                return null;
            }

            public RawErasureDecoder createDecoder(ErasureCoderOptions coderOptions) {
                return null;
            }

            public String getCoderName() {
                return "rs_java";
            }

            public String getCodecName() {
                return "rs";
            }
        }
        userDefinedFactories.add(new RSUserDefinedIncorrectFactory());
        CodecRegistry.getInstance().updateCoders(userDefinedFactories);
        List rsCoders = CodecRegistry.getInstance().getCoders("rs");
        Assertions.assertEquals((int)2, (int)rsCoders.size());
        Assertions.assertTrue((boolean)(rsCoders.get(0) instanceof NativeRSRawErasureCoderFactory));
        Assertions.assertTrue((boolean)(rsCoders.get(1) instanceof RSRawErasureCoderFactory));
        String[] rsCoderNames = CodecRegistry.getInstance().getCoderNames("rs");
        Assertions.assertEquals((int)2, (int)rsCoderNames.length);
        Assertions.assertEquals((Object)"rs_native", (Object)rsCoderNames[0]);
        Assertions.assertEquals((Object)"rs_java", (Object)rsCoderNames[1]);
    }
}

