/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.zlib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.zip.DeflaterOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.compress.CompressDecompressTester;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestZlibCompressorDecompressor {
    private static final Random random = new Random(12345L);

    @BeforeEach
    public void before() {
        Assumptions.assumeTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)new Configuration()));
    }

    @Test
    public void testZlibCompressorDecompressor() {
        try {
            int SIZE = 45056;
            byte[] rawData = TestZlibCompressorDecompressor.generate(SIZE);
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new ZlibCompressor(), new ZlibDecompressor()).withTestCases((ImmutableSet<CompressDecompressTester.CompressionTestStrategy>)ImmutableSet.of((Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM))).test();
        }
        catch (Exception ex) {
            Assertions.fail((String)("testCompressorDecompressor error !!!" + ex));
        }
    }

    @Test
    public void testCompressorDecompressorWithExeedBufferLimit() {
        int BYTE_SIZE = 102400;
        byte[] rawData = TestZlibCompressorDecompressor.generate(BYTE_SIZE);
        try {
            CompressDecompressTester.of(rawData).withCompressDecompressPair(new ZlibCompressor(ZlibCompressor.CompressionLevel.BEST_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.DEFAULT_HEADER, BYTE_SIZE), new ZlibDecompressor(ZlibDecompressor.CompressionHeader.DEFAULT_HEADER, BYTE_SIZE)).withTestCases((ImmutableSet<CompressDecompressTester.CompressionTestStrategy>)ImmutableSet.of((Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_SINGLE_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_BLOCK), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_ERRORS), (Object)((Object)CompressDecompressTester.CompressionTestStrategy.COMPRESS_DECOMPRESS_WITH_EMPTY_STREAM))).test();
        }
        catch (Exception ex) {
            Assertions.fail((String)("testCompressorDecompressorWithExeedBufferLimit error !!!" + ex));
        }
    }

    @Test
    public void testZlibCompressorDecompressorWithConfiguration() {
        Configuration conf = new Configuration();
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            int tryNumber = 5;
            int BYTE_SIZE = 10240;
            Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)conf);
            Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
            byte[] rawData = TestZlibCompressorDecompressor.generate(BYTE_SIZE);
            try {
                for (int i = 0; i < tryNumber; ++i) {
                    this.compressDecompressZlib(rawData, (ZlibCompressor)zlibCompressor, (ZlibDecompressor)zlibDecompressor);
                }
                zlibCompressor.reinit(conf);
            }
            catch (Exception ex) {
                Assertions.fail((String)("testZlibCompressorDecompressorWithConfiguration ex error " + ex));
            }
        } else {
            Assertions.assertTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf), (String)"ZlibFactory is using native libs against request");
        }
    }

    @Test
    public void testZlibCompressorDecompressorWithCompressionLevels() {
        Configuration conf = new Configuration();
        conf.set("zlib.compress.level", "FOUR");
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            int tryNumber = 5;
            int BYTE_SIZE = 10240;
            Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)conf);
            Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
            byte[] rawData = TestZlibCompressorDecompressor.generate(BYTE_SIZE);
            try {
                for (int i = 0; i < tryNumber; ++i) {
                    this.compressDecompressZlib(rawData, (ZlibCompressor)zlibCompressor, (ZlibDecompressor)zlibDecompressor);
                }
                zlibCompressor.reinit(conf);
            }
            catch (Exception ex) {
                Assertions.fail((String)("testZlibCompressorDecompressorWithConfiguration ex error " + ex));
            }
        } else {
            Assertions.assertTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf), (String)"ZlibFactory is using native libs against request");
        }
    }

    @Test
    public void testZlibCompressDecompress() {
        byte[] rawData = null;
        int rawDataSize = 0;
        rawDataSize = 65536;
        rawData = TestZlibCompressorDecompressor.generate(rawDataSize);
        try {
            ZlibCompressor compressor = new ZlibCompressor();
            ZlibDecompressor decompressor = new ZlibDecompressor();
            Assertions.assertFalse((boolean)compressor.finished(), (String)"testZlibCompressDecompress finished error");
            compressor.setInput(rawData, 0, rawData.length);
            Assertions.assertTrue((compressor.getBytesRead() == 0L ? 1 : 0) != 0, (String)"testZlibCompressDecompress getBytesRead before error");
            compressor.finish();
            byte[] compressedResult = new byte[rawDataSize];
            int cSize = compressor.compress(compressedResult, 0, rawDataSize);
            Assertions.assertTrue((compressor.getBytesRead() == (long)rawDataSize ? 1 : 0) != 0, (String)"testZlibCompressDecompress getBytesRead ather error");
            Assertions.assertTrue((cSize < rawDataSize ? 1 : 0) != 0, (String)"testZlibCompressDecompress compressed size no less then original size");
            decompressor.setInput(compressedResult, 0, cSize);
            byte[] decompressedBytes = new byte[rawDataSize];
            decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
            Assertions.assertArrayEquals((byte[])rawData, (byte[])decompressedBytes, (String)"testZlibCompressDecompress arrays not equals ");
            compressor.reset();
            decompressor.reset();
        }
        catch (IOException ex) {
            Assertions.fail((String)("testZlibCompressDecompress ex !!!" + ex));
        }
    }

    private void compressDecompressLoop(int rawDataSize) throws IOException {
        byte[] rawData = null;
        rawData = TestZlibCompressorDecompressor.generate(rawDataSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(rawDataSize + 12);
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        dos.write(rawData);
        dos.flush();
        dos.close();
        byte[] compressedResult = baos.toByteArray();
        int compressedSize = compressedResult.length;
        ZlibDecompressor.ZlibDirectDecompressor decompressor = new ZlibDecompressor.ZlibDirectDecompressor();
        ByteBuffer inBuf = ByteBuffer.allocateDirect(compressedSize);
        ByteBuffer outBuf = ByteBuffer.allocateDirect(rawDataSize);
        inBuf.put(compressedResult, 0, compressedSize);
        inBuf.flip();
        ByteBuffer expected = ByteBuffer.wrap(rawData);
        outBuf.clear();
        while (!decompressor.finished()) {
            decompressor.decompress(inBuf, outBuf);
            if (outBuf.remaining() != 0) continue;
            outBuf.flip();
            while (outBuf.remaining() > 0) {
                Assertions.assertEquals((byte)expected.get(), (byte)outBuf.get());
            }
            outBuf.clear();
        }
        outBuf.flip();
        while (outBuf.remaining() > 0) {
            Assertions.assertEquals((byte)expected.get(), (byte)outBuf.get());
        }
        outBuf.clear();
        Assertions.assertEquals((int)0, (int)expected.remaining());
    }

    @Test
    public void testZlibDirectCompressDecompress() {
        int[] size = new int[]{1, 4, 16, 4096, 65536, 131072, 0x100000};
        Assumptions.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        try {
            for (int i = 0; i < size.length; ++i) {
                this.compressDecompressLoop(size[i]);
            }
        }
        catch (IOException ex) {
            Assertions.fail((String)("testZlibDirectCompressDecompress ex !!!" + ex));
        }
    }

    @Test
    public void testZlibCompressorDecompressorSetDictionary() {
        Configuration conf = new Configuration();
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)conf);
            Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
            this.checkSetDictionaryNullPointerException(zlibCompressor);
            this.checkSetDictionaryNullPointerException(zlibDecompressor);
            this.checkSetDictionaryArrayIndexOutOfBoundsException(zlibDecompressor);
            this.checkSetDictionaryArrayIndexOutOfBoundsException(zlibCompressor);
        } else {
            Assertions.assertTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf), (String)"ZlibFactory is using native libs against request");
        }
    }

    @Test
    public void testZlibFactory() {
        Configuration cfg = new Configuration();
        Assertions.assertTrue((ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION == ZlibFactory.getCompressionLevel((Configuration)cfg) ? 1 : 0) != 0, (String)"testZlibFactory compression level error !!!");
        Assertions.assertTrue((ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY == ZlibFactory.getCompressionStrategy((Configuration)cfg) ? 1 : 0) != 0, (String)"testZlibFactory compression strategy error !!!");
        ZlibFactory.setCompressionLevel((Configuration)cfg, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        Assertions.assertTrue((ZlibCompressor.CompressionLevel.BEST_COMPRESSION == ZlibFactory.getCompressionLevel((Configuration)cfg) ? 1 : 0) != 0, (String)"testZlibFactory compression strategy error !!!");
        ZlibFactory.setCompressionStrategy((Configuration)cfg, (ZlibCompressor.CompressionStrategy)ZlibCompressor.CompressionStrategy.FILTERED);
        Assertions.assertTrue((ZlibCompressor.CompressionStrategy.FILTERED == ZlibFactory.getCompressionStrategy((Configuration)cfg) ? 1 : 0) != 0, (String)"testZlibFactory compression strategy error !!!");
    }

    private boolean checkSetDictionaryNullPointerException(Decompressor decompressor) {
        try {
            decompressor.setDictionary(null, 0, 1);
        }
        catch (NullPointerException ex) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkSetDictionaryNullPointerException(Compressor compressor) {
        try {
            compressor.setDictionary(null, 0, 1);
        }
        catch (NullPointerException ex) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkSetDictionaryArrayIndexOutOfBoundsException(Compressor compressor) {
        try {
            compressor.setDictionary(new byte[]{0}, 0, -1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkSetDictionaryArrayIndexOutOfBoundsException(Decompressor decompressor) {
        try {
            decompressor.setDictionary(new byte[]{0}, 0, -1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private byte[] compressDecompressZlib(byte[] rawData, ZlibCompressor zlibCompressor, ZlibDecompressor zlibDecompressor) throws IOException {
        int cSize = 0;
        byte[] compressedByte = new byte[rawData.length];
        byte[] decompressedRawData = new byte[rawData.length];
        zlibCompressor.setInput(rawData, 0, rawData.length);
        zlibCompressor.finish();
        while (!zlibCompressor.finished()) {
            cSize = zlibCompressor.compress(compressedByte, 0, compressedByte.length);
        }
        zlibCompressor.reset();
        Assertions.assertTrue((zlibDecompressor.getBytesWritten() == 0L ? 1 : 0) != 0);
        Assertions.assertTrue((zlibDecompressor.getBytesRead() == 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)zlibDecompressor.needsInput());
        zlibDecompressor.setInput(compressedByte, 0, cSize);
        Assertions.assertFalse((boolean)zlibDecompressor.needsInput());
        while (!zlibDecompressor.finished()) {
            zlibDecompressor.decompress(decompressedRawData, 0, decompressedRawData.length);
        }
        Assertions.assertTrue((zlibDecompressor.getBytesWritten() == (long)rawData.length ? 1 : 0) != 0);
        Assertions.assertTrue((zlibDecompressor.getBytesRead() == (long)cSize ? 1 : 0) != 0);
        zlibDecompressor.reset();
        Assertions.assertTrue((zlibDecompressor.getRemaining() == 0 ? 1 : 0) != 0);
        Assertions.assertArrayEquals((byte[])rawData, (byte[])decompressedRawData, (String)"testZlibCompressorDecompressorWithConfiguration array equals error");
        return decompressedRawData;
    }

    @Test
    public void testBuiltInGzipDecompressorExceptions() {
        DataInputBuffer gzbuf;
        BuiltInGzipDecompressor decompressor;
        byte[] buffer;
        int buffSize2;
        BuiltInGzipDecompressor decompresser = new BuiltInGzipDecompressor();
        try {
            decompresser.setInput(null, 0, 1);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("testBuiltInGzipDecompressorExceptions npe error " + ex));
        }
        try {
            decompresser.setInput(new byte[]{0}, 0, -1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("testBuiltInGzipDecompressorExceptions aioob error" + ex));
        }
        Assertions.assertTrue((decompresser.getBytesRead() == 0L ? 1 : 0) != 0, (String)"decompresser.getBytesRead error");
        Assertions.assertTrue((decompresser.getRemaining() == 0 ? 1 : 0) != 0, (String)"decompresser.getRemaining error");
        decompresser.reset();
        decompresser.end();
        DecompressorStream decompStream = null;
        try {
            buffSize2 = 1024;
            buffer = new byte[buffSize2];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream((InputStream)gzbuf, (Decompressor)decompressor);
            gzbuf.reset(new byte[]{0, 0, 1, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException buffSize2) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("invalid 0 and 1 byte in gzip stream" + ex));
        }
        try {
            buffSize2 = 1024;
            buffer = new byte[buffSize2];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream((InputStream)gzbuf, (Decompressor)decompressor);
            gzbuf.reset(new byte[]{31, -117, 7, 1, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException buffSize3) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("invalid 2 byte in gzip stream" + ex));
        }
        try {
            int buffSize4 = 1024;
            buffer = new byte[buffSize4];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream((InputStream)gzbuf, (Decompressor)decompressor);
            gzbuf.reset(new byte[]{31, -117, 8, -32, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException buffSize4) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("invalid 3 byte in gzip stream" + ex));
        }
        try {
            int buffSize5 = 1024;
            buffer = new byte[buffSize5];
            decompressor = new BuiltInGzipDecompressor();
            gzbuf = new DataInputBuffer();
            decompStream = new DecompressorStream((InputStream)gzbuf, (Decompressor)decompressor);
            gzbuf.reset(new byte[]{31, -117, 8, 4, 1, 1, 1, 11, 1, 1, 1, 1}, 11);
            decompStream.read(buffer);
        }
        catch (IOException buffSize5) {
        }
        catch (Exception ex) {
            Assertions.fail((String)("invalid 3 byte make hasExtraField" + ex));
        }
    }

    public static byte[] generate(int size) {
        byte[] data = new byte[size];
        for (int i = 0; i < size; ++i) {
            data[i] = (byte)random.nextInt(16);
        }
        return data;
    }

    @Test
    public void testZlibCompressDecompressInMultiThreads() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 10; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    TestZlibCompressorDecompressor.this.testZlibCompressDecompress();
                }
            });
        }
        ctx.startThreads();
        ctx.waitFor(60000L);
    }
}

