/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.hadoop.io.AvroTestUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Bytes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestText {
    private static final int NUM_ITERATIONS = 100;
    private static final Random RANDOM = new Random(1L);
    private static final int RAND_LEN = -1;

    private static String getTestString(int len) throws Exception {
        int length;
        StringBuilder buffer = new StringBuilder();
        int n = length = len == -1 ? RANDOM.nextInt(1000) : len;
        while (buffer.length() < length) {
            int codePoint = RANDOM.nextInt(0x10FFFF);
            char[] tmpStr = new char[2];
            if (!Character.isDefined(codePoint) || codePoint >= 65536 || Character.isHighSurrogate((char)codePoint) || Character.isLowSurrogate((char)codePoint)) continue;
            Character.toChars(codePoint, tmpStr, 0);
            buffer.append(tmpStr);
        }
        return buffer.toString();
    }

    public static String getTestString() throws Exception {
        return TestText.getTestString(-1);
    }

    public static String getLongString() throws Exception {
        String str = TestText.getTestString();
        int length = Short.MAX_VALUE + str.length();
        StringBuilder buffer = new StringBuilder();
        while (buffer.length() < length) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    @Test
    public void testWritable() throws Exception {
        for (int i = 0; i < 100; ++i) {
            String str = i == 0 ? TestText.getLongString() : TestText.getTestString();
            TestWritable.testWritable((Writable)new Text(str));
        }
    }

    @Test
    public void testCoding() throws Exception {
        String before = "Bad \t encoding \t testcase";
        Text text = new Text(before);
        String after = text.toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)before.equals(after));
        for (int i = 0; i < 100; ++i) {
            before = i == 0 ? TestText.getLongString() : TestText.getTestString();
            ByteBuffer bb = Text.encode((String)before);
            byte[] utf8Text = bb.array();
            byte[] utf8Java = before.getBytes(StandardCharsets.UTF_8);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)WritableComparator.compareBytes((byte[])utf8Text, (int)0, (int)bb.limit(), (byte[])utf8Java, (int)0, (int)utf8Java.length));
            after = Text.decode((byte[])utf8Java);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)before.equals(after));
        }
    }

    @Test
    public void testIO() throws Exception {
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        for (int i = 0; i < 100; ++i) {
            String before = i == 0 ? TestText.getLongString() : TestText.getTestString();
            out.reset();
            Text.writeString((DataOutput)out, (String)before);
            in.reset(out.getData(), out.getLength());
            String after = Text.readString((DataInput)in);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)before.equals(after));
            int strLenSize = WritableUtils.getVIntSize((long)Text.utf8Length((String)before));
            String after2 = new String(out.getData(), strLenSize, out.getLength() - strLenSize, "UTF-8");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)before.equals(after2));
        }
    }

    public void doTestLimitedIO(String str, int len) throws IOException {
        String after;
        DataOutputBuffer out = new DataOutputBuffer();
        DataInputBuffer in = new DataInputBuffer();
        out.reset();
        try {
            Text.writeString((DataOutput)out, (String)str, (int)len);
            org.junit.jupiter.api.Assertions.fail((String)("expected writeString to fail when told to write a string that was too long!  The string was '" + str + "'"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Text.writeString((DataOutput)out, (String)str, (int)(len + 1));
        in.reset(out.getData(), out.getLength());
        in.mark(len);
        try {
            after = Text.readString((DataInput)in, (int)len);
            org.junit.jupiter.api.Assertions.fail((String)("expected readString to fail when told to read a string that was too long!  The string was '" + str + "'"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        in.reset();
        after = Text.readString((DataInput)in, (int)(len + 1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)str.equals(after));
    }

    @Test
    public void testLimitedIO() throws Exception {
        this.doTestLimitedIO("abcd", 3);
        this.doTestLimitedIO("foo bar baz", 10);
        this.doTestLimitedIO("1", 0);
    }

    @Test
    public void testCompare() throws Exception {
        DataOutputBuffer out1 = new DataOutputBuffer();
        DataOutputBuffer out2 = new DataOutputBuffer();
        DataOutputBuffer out3 = new DataOutputBuffer();
        Text.Comparator comparator = new Text.Comparator();
        for (int i = 0; i < 100; ++i) {
            out1.reset();
            out2.reset();
            out3.reset();
            String str1 = TestText.getTestString();
            String str2 = TestText.getTestString();
            if (i == 0) {
                str1 = TestText.getLongString();
                str2 = TestText.getLongString();
            } else {
                str1 = TestText.getTestString();
                str2 = TestText.getTestString();
            }
            Text txt1 = new Text(str1);
            Text txt2 = new Text(str2);
            Text txt3 = new Text(str1);
            txt1.write((DataOutput)out1);
            txt2.write((DataOutput)out2);
            txt3.write((DataOutput)out3);
            int ret1 = comparator.compare(out1.getData(), 0, out1.getLength(), out2.getData(), 0, out2.getLength());
            int ret2 = txt1.compareTo((BinaryComparable)txt2);
            org.junit.jupiter.api.Assertions.assertEquals((int)ret1, (int)ret2);
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)txt1.compareTo((BinaryComparable)txt3), (String)"Equivalence of different txt objects, same content");
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)comparator.compare(out1.getData(), 0, out3.getLength(), out3.getData(), 0, out3.getLength()), (String)"Equvalence of data output buffers");
        }
    }

    @Test
    public void testFind() throws Exception {
        Text text = new Text("abcd\u20acbdcd\u20ac");
        Assertions.assertThat((int)text.find("abd")).isEqualTo(-1);
        Assertions.assertThat((int)text.find("ac")).isEqualTo(-1);
        Assertions.assertThat((int)text.find("\u20ac")).isEqualTo(4);
        Assertions.assertThat((int)text.find("\u20ac", 5)).isEqualTo(11);
    }

    @Test
    public void testFindAfterUpdatingContents() throws Exception {
        Text text = new Text("abcd");
        text.set("a".getBytes());
        org.junit.jupiter.api.Assertions.assertEquals((int)text.getLength(), (int)1);
        org.junit.jupiter.api.Assertions.assertEquals((int)text.find("a"), (int)0);
        org.junit.jupiter.api.Assertions.assertEquals((int)text.find("b"), (int)-1);
    }

    @Test
    public void testValidate() throws Exception {
        Text text = new Text("abcd\u20acbdcd\u20ac");
        byte[] utf8 = text.getBytes();
        int length = text.getLength();
        Text.validateUTF8((byte[])utf8, (int)0, (int)length);
    }

    @Test
    public void testClear() throws Exception {
        Text text = new Text();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)text.toString(), (String)"Actual string on an empty text object must be an empty string");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)text.getBytes().length, (String)"Underlying byte array length must be zero");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)text.getLength(), (String)"String's length must be zero");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)text.getTextLength(), (String)"String's text length must be zero");
        text = new Text("abcd\u20acbdcd\u20ac");
        int len = text.getLength();
        text.clear();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)text.toString(), (String)"String must be empty after clear()");
        org.junit.jupiter.api.Assertions.assertTrue((text.getBytes().length >= len ? 1 : 0) != 0, (String)"Length of the byte array must not decrease after clear()");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)text.getLength(), (String)"Length of the string must be reset to 0 after clear()");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)text.getTextLength(), (String)"Text length of the string must be reset to 0 after clear()");
    }

    @Test
    public void testTextText() throws CharacterCodingException {
        Text a = new Text("abc");
        Text b = new Text("a");
        b.set(a);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)b.toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)a.getTextLength());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)b.getTextLength());
        a.append("xdefgxxx".getBytes(), 1, 4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abc", (Object)b.toString(), (String)"modified aliased string");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"abcdefg", (Object)a.toString(), (String)"appended string incorrectly");
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)a.getTextLength(), (String)"This should reflect in the lenght");
        a.append(new byte[]{100}, 0, 1);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)a.getBytes().length);
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)a.copyBytes().length);
    }

    @Test
    public void testConcurrentEncodeDecode() throws Exception {
        ConcurrentEncodeDecodeThread thread1 = new ConcurrentEncodeDecodeThread("apache");
        ConcurrentEncodeDecodeThread thread2 = new ConcurrentEncodeDecodeThread("hadoop");
        thread1.start();
        thread2.start();
        thread2.join();
        thread2.join();
    }

    @Test
    public void testAvroReflect() throws Exception {
        System.setProperty("org.apache.avro.SERIALIZABLE_PACKAGES", "org.apache.hadoop.io");
        AvroTestUtil.testReflect(new Text("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.io.Text\"}");
    }

    @Test
    public void testCharAt() {
        String line = "adsawseeeeegqewgasddga";
        Text text = new Text(line);
        for (int i = 0; i < line.length(); ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((text.charAt(i) == line.charAt(i) ? 1 : 0) != 0, (String)"testCharAt error1 !!!");
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)text.charAt(-1), (String)"testCharAt error2 !!!");
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)text.charAt(100), (String)"testCharAt error3 !!!");
    }

    @Test
    public void testReadWriteOperations() {
        String line = "adsawseeeeegqewgasddga";
        byte[] inputBytes = line.getBytes();
        inputBytes = Bytes.concat((byte[][])new byte[][]{{22}, inputBytes});
        DataInputBuffer in = new DataInputBuffer();
        DataOutputBuffer out = new DataOutputBuffer();
        Text text = new Text(line);
        try {
            in.reset(inputBytes, inputBytes.length);
            text.readFields((DataInput)in);
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail((String)"testReadFields error !!!");
        }
        try {
            text.write((DataOutput)out);
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail((String)"testReadWriteOperations error !!!");
        }
    }

    @Test
    public void testReadWithKnownLength() throws IOException {
        String line = "hello world";
        byte[] inputBytes = line.getBytes(StandardCharsets.UTF_8);
        DataInputBuffer in = new DataInputBuffer();
        Text text = new Text();
        in.reset(inputBytes, inputBytes.length);
        text.readWithKnownLength((DataInput)in, 5);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)text.toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)text.getTextLength());
        in.reset(inputBytes, inputBytes.length);
        text.readWithKnownLength((DataInput)in, 7);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello w", (Object)text.toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)text.getTextLength());
        in.reset(inputBytes, inputBytes.length);
        text.readWithKnownLength((DataInput)in, 2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"he", (Object)text.toString());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)text.getTextLength());
    }

    @Test
    public void testBytesToCodePoint() {
        try {
            ByteBuffer bytes = ByteBuffer.wrap(new byte[]{-2, 45, 23, 12, 76, 89});
            Text.bytesToCodePoint((ByteBuffer)bytes);
            org.junit.jupiter.api.Assertions.assertTrue((bytes.position() == 6 ? 1 : 0) != 0, (String)"testBytesToCodePoint error !!!");
        }
        catch (BufferUnderflowException ex) {
            org.junit.jupiter.api.Assertions.fail((String)"testBytesToCodePoint unexp exception");
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testBytesToCodePoint unexp exception");
        }
    }

    @Test
    public void testbytesToCodePointWithInvalidUTF() {
        try {
            Text.bytesToCodePoint((ByteBuffer)ByteBuffer.wrap(new byte[]{-2}));
            org.junit.jupiter.api.Assertions.fail((String)"testbytesToCodePointWithInvalidUTF error unexp exception !!!");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"testbytesToCodePointWithInvalidUTF error unexp exception !!!");
        }
    }

    @Test
    public void testUtf8Length() {
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Text.utf8Length((String)new String(new char[]{'\u0001'})), (String)"testUtf8Length1 error !!!");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)Text.utf8Length((String)new String(new char[]{'\u007f'})), (String)"testUtf8Length127 error !!!");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)Text.utf8Length((String)new String(new char[]{'\u0080'})), (String)"testUtf8Length128 error !!!");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)Text.utf8Length((String)new String(new char[]{'\u00c1'})), (String)"testUtf8Length193 error !!!");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)Text.utf8Length((String)new String(new char[]{'\u00e1'})), (String)"testUtf8Length225 error !!!");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)Text.utf8Length((String)new String(new char[]{'\u00fe'})), (String)"testUtf8Length254 error !!!");
    }

    @Test
    public void testSetBytes() {
        Text a = new Text(new byte[100]);
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)a.getLength(), (String)"testSetBytes100 getLength error !");
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)a.getBytes().length, (String)"testSetBytes100 getBytes.length error !");
        org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)a.getTextLength(), (String)"testSetBytes100 getTextLength error !");
        a.set(new byte[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)a.getLength(), (String)"testSetBytes0 getLength error !");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)a.getBytes().length, (String)"testSetBytes0 getBytes.length error !");
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)a.getTextLength(), (String)"testSetBytes0 getTextLength error !");
    }

    private class ConcurrentEncodeDecodeThread
    extends Thread {
        public ConcurrentEncodeDecodeThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            String name = this.getName();
            DataOutputBuffer out = new DataOutputBuffer();
            DataInputBuffer in = new DataInputBuffer();
            for (int i = 0; i < 1000; ++i) {
                try {
                    out.reset();
                    WritableUtils.writeString((DataOutput)out, (String)name);
                    in.reset(out.getData(), out.getLength());
                    String s = WritableUtils.readString((DataInput)in);
                    org.junit.jupiter.api.Assertions.assertEquals((Object)name, (Object)s, (String)("input buffer reset contents = " + name));
                    continue;
                }
                catch (Exception ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }
}

