/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.Map;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSortedMapWritable {
    @Test
    public void testSortedMapWritable() {
        Text[] keys = new Text[]{new Text("key1"), new Text("key2"), new Text("key3")};
        BytesWritable[] values = new BytesWritable[]{new BytesWritable("value1".getBytes()), new BytesWritable("value2".getBytes()), new BytesWritable("value3".getBytes())};
        SortedMapWritable inMap = new SortedMapWritable();
        for (int i = 0; i < keys.length; ++i) {
            inMap.put((WritableComparable)keys[i], (Writable)values[i]);
        }
        Assertions.assertEquals((int)0, (int)((Text)inMap.firstKey()).compareTo((BinaryComparable)keys[0]));
        Assertions.assertEquals((int)0, (int)((Text)inMap.lastKey()).compareTo((BinaryComparable)keys[2]));
        SortedMapWritable outMap = new SortedMapWritable(inMap);
        Assertions.assertEquals((int)inMap.size(), (int)outMap.size());
        for (Map.Entry e : inMap.entrySet()) {
            Assertions.assertTrue((boolean)outMap.containsKey(e.getKey()));
            WritableComparable aValue = (WritableComparable)outMap.get(e.getKey());
            WritableComparable bValue = (WritableComparable)e.getValue();
            Assertions.assertEquals((int)0, (int)aValue.compareTo((Object)bValue));
        }
        Text[] maps = new Text[]{new Text("map1"), new Text("map2")};
        SortedMapWritable mapOfMaps = new SortedMapWritable();
        mapOfMaps.put((WritableComparable)maps[0], (Writable)inMap);
        mapOfMaps.put((WritableComparable)maps[1], (Writable)outMap);
        SortedMapWritable copyOfMapOfMaps = new SortedMapWritable(mapOfMaps);
        for (int i = 0; i < maps.length; ++i) {
            Assertions.assertTrue((boolean)copyOfMapOfMaps.containsKey((Object)maps[i]));
            SortedMapWritable a = (SortedMapWritable)mapOfMaps.get((Object)maps[i]);
            SortedMapWritable b = (SortedMapWritable)copyOfMapOfMaps.get((Object)maps[i]);
            Assertions.assertEquals((int)a.size(), (int)b.size());
            for (Writable key : a.keySet()) {
                Assertions.assertTrue((boolean)b.containsKey((Object)key));
                WritableComparable aValue = (WritableComparable)a.get((Object)key);
                WritableComparable bValue = (WritableComparable)b.get((Object)key);
                Assertions.assertEquals((int)0, (int)aValue.compareTo((Object)bValue));
            }
        }
    }

    @Test
    public void testForeignClass() {
        SortedMapWritable inMap = new SortedMapWritable();
        inMap.put((WritableComparable)new Text("key"), (Writable)new UTF8("value"));
        inMap.put((WritableComparable)new Text("key2"), (Writable)new UTF8("value2"));
        SortedMapWritable outMap = new SortedMapWritable(inMap);
        SortedMapWritable copyOfCopy = new SortedMapWritable(outMap);
        Assertions.assertEquals((int)1, (int)copyOfCopy.getNewClasses());
    }

    @Test
    public void testEqualsAndHashCode() {
        SortedMapWritable mapA = new SortedMapWritable();
        SortedMapWritable mapB = new SortedMapWritable();
        String failureReason = "SortedMapWritable couldn't be initialized. Got null reference";
        Assertions.assertNotNull((Object)mapA, (String)failureReason);
        Assertions.assertNotNull((Object)mapB, (String)failureReason);
        Assertions.assertFalse((boolean)mapA.equals(null), (String)"equals method returns true when passed null");
        Assertions.assertTrue((boolean)mapA.equals((Object)mapB), (String)"Two empty SortedMapWritables are no longer equal");
        Text[] keys = new Text[]{new Text("key1"), new Text("key2")};
        BytesWritable[] values = new BytesWritable[]{new BytesWritable("value1".getBytes()), new BytesWritable("value2".getBytes())};
        mapA.put((WritableComparable)keys[0], (Writable)values[0]);
        mapB.put((WritableComparable)keys[1], (Writable)values[1]);
        failureReason = "Two SortedMapWritables with different data are now equal";
        Assertions.assertTrue((mapA.hashCode() != mapB.hashCode() ? 1 : 0) != 0, (String)failureReason);
        Assertions.assertTrue((!mapA.equals((Object)mapB) ? 1 : 0) != 0, (String)failureReason);
        Assertions.assertTrue((!mapB.equals((Object)mapA) ? 1 : 0) != 0, (String)failureReason);
        mapA.put((WritableComparable)keys[1], (Writable)values[1]);
        mapB.put((WritableComparable)keys[0], (Writable)values[0]);
        failureReason = "Two SortedMapWritables with same entry sets formed in different order are now different";
        Assertions.assertEquals((int)mapA.hashCode(), (int)mapB.hashCode(), (String)failureReason);
        Assertions.assertTrue((boolean)mapA.equals((Object)mapB), (String)failureReason);
        Assertions.assertTrue((boolean)mapB.equals((Object)mapA), (String)failureReason);
        mapA.put((WritableComparable)keys[0], (Writable)values[1]);
        mapA.put((WritableComparable)keys[1], (Writable)values[0]);
        failureReason = "Two SortedMapWritables with different content are now equal";
        Assertions.assertTrue((mapA.hashCode() != mapB.hashCode() ? 1 : 0) != 0, (String)failureReason);
        Assertions.assertTrue((!mapA.equals((Object)mapB) ? 1 : 0) != 0, (String)failureReason);
        Assertions.assertTrue((!mapB.equals((Object)mapA) ? 1 : 0) != 0, (String)failureReason);
    }

    @Test
    @Timeout(value=10L)
    public void testPutAll() {
        SortedMapWritable map1 = new SortedMapWritable();
        SortedMapWritable map2 = new SortedMapWritable();
        map1.put((WritableComparable)new Text("key"), (Writable)new Text("value"));
        map2.putAll((Map)map1);
        Assertions.assertEquals((Object)map1, (Object)map2, (String)"map1 entries don't match map2 entries");
        Assertions.assertTrue((map2.classToIdMap.containsKey(Text.class) && map2.idToClassMap.containsValue(Text.class) ? 1 : 0) != 0, (String)"map2 doesn't have class information from map1");
    }
}

