/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.thirdparty.protobuf.DescriptorProtos;
import org.apache.hadoop.thirdparty.protobuf.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestObjectWritableProtos {
    @Test
    public void testProtoBufs() throws IOException {
        this.doTest(1);
    }

    @Test
    public void testProtoBufs2() throws IOException {
        this.doTest(2);
    }

    @Test
    public void testProtoBufs3() throws IOException {
        this.doTest(3);
    }

    private void doTest(int numProtos) throws IOException {
        Configuration conf = new Configuration();
        DataOutputBuffer out = new DataOutputBuffer();
        Message[] sent = new Message[numProtos];
        for (int i = 0; i < numProtos; ++i) {
            DescriptorProtos.EnumValueDescriptorProto testProto = DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName("test" + i).setNumber(i).build();
            ObjectWritable.writeObject((DataOutput)out, (Object)testProto, DescriptorProtos.EnumValueDescriptorProto.class, (Configuration)conf);
            sent[i] = testProto;
        }
        DataInputBuffer in = new DataInputBuffer();
        in.reset(out.getData(), out.getLength());
        for (int i = 0; i < numProtos; ++i) {
            Message received = (Message)ObjectWritable.readObject((DataInput)in, (Configuration)conf);
            Assertions.assertEquals((Object)sent[i], (Object)received);
        }
    }
}

