/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMapFile {
    private static final Logger LOG = LoggerFactory.getLogger(TestMapFile.class);
    private static final Path TEST_DIR = new Path(GenericTestUtils.getTempPath(TestMapFile.class.getSimpleName()));
    private static Configuration conf = new Configuration();
    private static final Progressable defaultProgressable = new Progressable(){

        public void progress() {
        }
    };
    private static final CompressionCodec defaultCodec = new CompressionCodec(){

        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        public Compressor createCompressor() {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        public Decompressor createDecompressor() {
            return null;
        }

        public String getDefaultExtension() {
            return null;
        }
    };

    @BeforeEach
    public void setup() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(TEST_DIR) && !fs.delete(TEST_DIR, true)) {
            Assertions.fail((String)"Can't clean up test root dir");
        }
        fs.mkdirs(TEST_DIR);
    }

    private MapFile.Writer createWriter(String fileName, Class<? extends WritableComparable<?>> keyClass, Class<? extends Writable> valueClass) throws IOException {
        Path dirName = new Path(TEST_DIR, fileName);
        MapFile.Writer.setIndexInterval((Configuration)conf, (int)4);
        return new MapFile.Writer(conf, dirName, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(keyClass), MapFile.Writer.valueClass(valueClass)});
    }

    private MapFile.Reader createReader(String fileName, Class<? extends WritableComparable<?>> keyClass) throws IOException {
        Path dirName = new Path(TEST_DIR, fileName);
        return new MapFile.Reader(dirName, conf, new SequenceFile.Reader.Option[]{MapFile.Reader.comparator((WritableComparator)new WritableComparator(keyClass))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosestOnCurrentApi() throws Exception {
        String TEST_PREFIX = "testGetClosestOnCurrentApi.mapfile";
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            int FIRST_KEY;
            writer = this.createWriter("testGetClosestOnCurrentApi.mapfile", Text.class, Text.class);
            for (int i = FIRST_KEY = 1; i < 100; i += 10) {
                Text t = new Text(Integer.toString(i));
                writer.append((WritableComparable)t, (Writable)t);
            }
            writer.close();
            reader = this.createReader("testGetClosestOnCurrentApi.mapfile", Text.class);
            Text key = new Text("55");
            Text value = new Text();
            Text closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assertions.assertEquals((Object)new Text("61"), (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assertions.assertEquals((Object)new Text("51"), (Object)closest);
            Text explicitKey = new Text("21");
            closest = (Text)reader.getClosest((WritableComparable)explicitKey, (Writable)value);
            Assertions.assertEquals((Object)new Text("21"), (Object)explicitKey);
            key = new Text("00");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assertions.assertEquals((int)FIRST_KEY, (int)Integer.parseInt(closest.toString()));
            key = new Text("92");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assertions.assertNull((Object)closest, (String)"Not null key in testGetClosestWithNewCode");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assertions.assertEquals((Object)new Text("91"), (Object)closest);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKeyOnCurrentApi() throws Exception {
        String TEST_PREFIX = "testMidKeyOnCurrentApi.mapfile";
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testMidKeyOnCurrentApi.mapfile", IntWritable.class, IntWritable.class);
            int SIZE = 10;
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new IntWritable(i));
            }
            writer.close();
            reader = this.createReader("testMidKeyOnCurrentApi.mapfile", IntWritable.class);
            Assertions.assertEquals((Object)new IntWritable((SIZE - 1) / 2), (Object)reader.midKey());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRename() {
        String NEW_FILE_NAME = "test-new.mapfile";
        String OLD_FILE_NAME = "test-old.mapfile";
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            writer = this.createWriter("test-old.mapfile", IntWritable.class, IntWritable.class);
            writer.close();
            MapFile.rename((FileSystem)fs, (String)new Path(TEST_DIR, "test-old.mapfile").toString(), (String)new Path(TEST_DIR, "test-new.mapfile").toString());
            MapFile.delete((FileSystem)fs, (String)new Path(TEST_DIR, "test-new.mapfile").toString());
        }
        catch (IOException ex) {
            try {
                Assertions.fail((String)("testRename error " + ex));
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithException() {
        String ERROR_MESSAGE = "Can't rename file";
        String NEW_FILE_NAME = "test-new.mapfile";
        String OLD_FILE_NAME = "test-old.mapfile";
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
            writer = this.createWriter("test-old.mapfile", IntWritable.class, IntWritable.class);
            writer.close();
            Path oldDir = new Path(TEST_DIR, "test-old.mapfile");
            Path newDir = new Path(TEST_DIR, "test-new.mapfile");
            Mockito.when((Object)spyFs.rename(oldDir, newDir)).thenThrow(new Throwable[]{new IOException("Can't rename file")});
            MapFile.rename((FileSystem)spyFs, (String)oldDir.toString(), (String)newDir.toString());
            Assertions.fail((String)"testRenameWithException no exception error !!!");
        }
        catch (IOException ex) {
            try {
                Assertions.assertEquals((Object)ex.getMessage(), (Object)"Can't rename file", (String)"testRenameWithException invalid IOExceptionMessage !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameWithFalse() {
        String ERROR_MESSAGE = "Could not rename";
        String NEW_FILE_NAME = "test-new.mapfile";
        String OLD_FILE_NAME = "test-old.mapfile";
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
            writer = this.createWriter("test-old.mapfile", IntWritable.class, IntWritable.class);
            writer.close();
            Path oldDir = new Path(TEST_DIR, "test-old.mapfile");
            Path newDir = new Path(TEST_DIR, "test-new.mapfile");
            Mockito.when((Object)spyFs.rename(oldDir, newDir)).thenReturn((Object)false);
            MapFile.rename((FileSystem)spyFs, (String)oldDir.toString(), (String)newDir.toString());
            Assertions.fail((String)"testRenameWithException no exception error !!!");
        }
        catch (IOException ex) {
            try {
                Assertions.assertTrue((boolean)ex.getMessage().startsWith("Could not rename"), (String)"testRenameWithFalse invalid IOExceptionMessage error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteWithFailDirCreation() {
        String ERROR_MESSAGE = "Mkdirs failed to create directory";
        Path dirName = new Path(TEST_DIR, "fail.mapfile");
        MapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            FileSystem spyFs = (FileSystem)Mockito.spy((Object)fs);
            Path pathSpy = (Path)Mockito.spy((Object)dirName);
            Mockito.when((Object)pathSpy.getFileSystem(conf)).thenReturn((Object)spyFs);
            Mockito.when((Object)spyFs.mkdirs(dirName)).thenReturn((Object)false);
            writer = new MapFile.Writer(conf, pathSpy, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            Assertions.fail((String)"testWriteWithFailDirCreation error !!!");
        }
        catch (IOException ex) {
            try {
                Assertions.assertTrue((boolean)ex.getMessage().startsWith(ERROR_MESSAGE), (String)"testWriteWithFailDirCreation ex error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnFinalKey() {
        String TEST_METHOD_KEY = "testOnFinalKey.mapfile";
        int SIZE = 10;
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testOnFinalKey.mapfile", IntWritable.class, IntWritable.class);
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new IntWritable(i));
            }
            writer.close();
            reader = this.createReader("testOnFinalKey.mapfile", IntWritable.class);
            IntWritable expectedKey = new IntWritable(0);
            reader.finalKey((WritableComparable)expectedKey);
            Assertions.assertEquals((Object)expectedKey, (Object)new IntWritable(9), (String)"testOnFinalKey not same !!!");
        }
        catch (IOException ex) {
            try {
                Assertions.fail((String)"testOnFinalKey error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    @Test
    public void testKeyValueClasses() {
        Class<IntWritable> keyClass = IntWritable.class;
        Class<Text> valueClass = Text.class;
        try {
            this.createWriter("testKeyValueClasses.mapfile", IntWritable.class, Text.class).close();
            Assertions.assertNotNull((Object)MapFile.Writer.keyClass(keyClass), (String)"writer key class null error !!!");
            Assertions.assertNotNull((Object)MapFile.Writer.valueClass(valueClass), (String)"writer value class null error !!!");
        }
        catch (IOException ex) {
            Assertions.fail((String)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testReaderGetClosest() throws Exception {
        String TEST_METHOD_KEY = "testReaderWithWrongKeyClass.mapfile";
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testReaderWithWrongKeyClass.mapfile", IntWritable.class, Text.class);
            for (int i = 0; i < 10; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text("value" + i));
            }
            writer.close();
            reader = this.createReader("testReaderWithWrongKeyClass.mapfile", Text.class);
            reader.getClosest((WritableComparable)new Text("2"), (Writable)new Text(""));
            Assertions.fail((String)"no excepted exception in testReaderWithWrongKeyClass !!!");
        }
        catch (IOException iOException) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderWithWrongValueClass() {
        String TEST_METHOD_KEY = "testReaderWithWrongValueClass.mapfile";
        MapFile.Writer writer = null;
        try {
            writer = this.createWriter("testReaderWithWrongValueClass.mapfile", IntWritable.class, Text.class);
            writer.append((WritableComparable)new IntWritable(0), (Writable)new IntWritable(0));
            Assertions.fail((String)"no excepted exception in testReaderWithWrongKeyClass !!!");
        }
        catch (IOException iOException) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderKeyIteration() {
        String TEST_METHOD_KEY = "testReaderKeyIteration.mapfile";
        int SIZE = 10;
        int ITERATIONS = 5;
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = this.createWriter("testReaderKeyIteration.mapfile", IntWritable.class, Text.class);
            int start = 0;
            for (int i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text("Value:" + i));
            }
            writer.close();
            reader = this.createReader("testReaderKeyIteration.mapfile", IntWritable.class);
            Text startValue = new Text("Value:" + start);
            int i = 0;
            while (i++ < ITERATIONS) {
                IntWritable key = new IntWritable(start);
                Text value = startValue;
                while (reader.next((WritableComparable)key, (Writable)value)) {
                    Assertions.assertNotNull((Object)key);
                    Assertions.assertNotNull((Object)value);
                }
                reader.reset();
            }
            Assertions.assertTrue((boolean)reader.seek((WritableComparable)new IntWritable(SIZE / 2)), (String)"reader seek error !!!");
            Assertions.assertFalse((boolean)reader.seek((WritableComparable)new IntWritable(SIZE * 2)), (String)"reader seek error !!!");
        }
        catch (IOException ex) {
            try {
                Assertions.fail((String)"reader seek error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFix() {
        MapFile.Writer writer;
        block6: {
            String INDEX_LESS_MAP_FILE = "testFix.mapfile";
            int PAIR_SIZE = 20;
            writer = null;
            try {
                LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
                Path dir = new Path(TEST_DIR, "testFix.mapfile");
                writer = this.createWriter("testFix.mapfile", IntWritable.class, Text.class);
                for (int i = 0; i < PAIR_SIZE; ++i) {
                    writer.append((WritableComparable)new IntWritable(0), (Writable)new Text("value"));
                }
                writer.close();
                File indexFile = new File(".", ".testFix.mapfile/index");
                boolean isDeleted = false;
                if (indexFile.exists()) {
                    isDeleted = indexFile.delete();
                }
                if (!isDeleted) break block6;
                Assertions.assertTrue((MapFile.fix((FileSystem)fs, (Path)dir, IntWritable.class, Text.class, (boolean)true, (Configuration)conf) == (long)PAIR_SIZE ? 1 : 0) != 0, (String)"testFix error !!!");
            }
            catch (Exception ex) {
                try {
                    Assertions.fail((String)"testFix error !!!");
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
            }
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFixBlockCompress() throws Exception {
        String indexLessMapFile = "testFixBlockCompress.mapfile";
        int compressBlocksize = 100;
        int indexInterval = 4;
        int noBlocks = 4;
        String value = "value-";
        int size = 400 / (4 + "value-".length());
        conf.setInt("io.seqfile.compress.blocksize", 100);
        MapFile.Writer.setIndexInterval((Configuration)conf, (int)4);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path dir = new Path(TEST_DIR, "testFixBlockCompress.mapfile");
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = new MapFile.Writer(conf, dir, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class), MapFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK)});
            for (int i = 0; i < size; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text("value-" + i));
            }
            writer.close();
            Path index = new Path(dir, "index");
            fs.rename(index, index.suffix(".orig"));
            Assertions.assertEquals((long)size, (long)MapFile.fix((FileSystem)fs, (Path)dir, IntWritable.class, Text.class, (boolean)false, (Configuration)conf), (String)"No of valid MapFile entries wrong");
            reader = new MapFile.Reader(dir, conf, new SequenceFile.Reader.Option[0]);
            Text val = new Text();
            int notFound = 0;
            for (int i = 0; i < size; ++i) {
                IntWritable key = new IntWritable(i);
                if (null != reader.get((WritableComparable)key, (Writable)val)) continue;
                ++notFound;
            }
            Assertions.assertEquals((int)0, (int)notFound, (String)"With MapFile.fix-ed index, could not get entries # ");
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{writer, reader});
            if (fs.exists(dir)) {
                fs.delete(dir, true);
            }
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{writer, reader});
        if (fs.exists(dir)) {
            fs.delete(dir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeprecatedConstructors() {
        String path = new Path(TEST_DIR, "writes.mapfile").toString();
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD);
            Assertions.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultProgressable);
            Assertions.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultCodec, defaultProgressable);
            Assertions.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, WritableComparator.get(Text.class), Text.class);
            Assertions.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, WritableComparator.get(Text.class), Text.class, SequenceFile.CompressionType.RECORD);
            Assertions.assertNotNull((Object)writer);
            writer.close();
            writer = new MapFile.Writer(conf, (FileSystem)fs, path, WritableComparator.get(Text.class), Text.class, SequenceFile.CompressionType.RECORD, defaultProgressable);
            Assertions.assertNotNull((Object)writer);
            writer.close();
            reader = new MapFile.Reader((FileSystem)fs, path, WritableComparator.get(IntWritable.class), conf);
            Assertions.assertNotNull((Object)reader);
            Assertions.assertNotNull((Object)reader.getKeyClass(), (String)"reader key is null !!!");
            Assertions.assertNotNull((Object)reader.getValueClass(), (String)"reader value in null");
        }
        catch (IOException e) {
            try {
                Assertions.fail((String)e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    @Test
    public void testKeyLessWriterCreation() {
        MapFile.Writer writer = null;
        try {
            writer = new MapFile.Writer(conf, TEST_DIR, new SequenceFile.Writer.Option[0]);
            Assertions.fail((String)"fail in testKeyLessWriterCreation !!!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        catch (Exception e) {
            try {
                Assertions.fail((String)"fail in testKeyLessWriterCreation. Other ex !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testPathExplosionWriterCreation() {
        Path path = new Path(TEST_DIR, "testPathExplosionWriterCreation.mapfile");
        String TEST_ERROR_MESSAGE = "Mkdirs failed to create directory " + path.getName();
        MapFile.Writer writer = null;
        try {
            FileSystem fsSpy = (FileSystem)Mockito.spy((Object)FileSystem.get((Configuration)conf));
            Path pathSpy = (Path)Mockito.spy((Object)path);
            Mockito.when((Object)fsSpy.mkdirs(path)).thenThrow(new Throwable[]{new IOException(TEST_ERROR_MESSAGE)});
            Mockito.when((Object)pathSpy.getFileSystem(conf)).thenReturn((Object)fsSpy);
            writer = new MapFile.Writer(conf, pathSpy, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(IntWritable.class)});
            Assertions.fail((String)"fail in testPathExplosionWriterCreation !!!");
        }
        catch (IOException ex) {
            Assertions.assertEquals((Object)ex.getMessage(), (Object)TEST_ERROR_MESSAGE, (String)"testPathExplosionWriterCreation ex message error !!!");
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        catch (Exception e) {
            Assertions.fail((String)"fail in testPathExplosionWriterCreation. Other ex !!!");
            {
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    @Test
    public void testDescOrderWithThrowExceptionWriterAppend() {
        MapFile.Writer writer = null;
        try {
            writer = this.createWriter(".mapfile", IntWritable.class, Text.class);
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("value: 1"));
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("value: 2"));
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("value: 4"));
            writer.append((WritableComparable)new IntWritable(1), (Writable)new Text("value: 3"));
            Assertions.fail((String)"testDescOrderWithThrowExceptionWriterAppend not expected exception error !!!");
        }
        catch (IOException iOException) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        catch (Exception e) {
            try {
                Assertions.fail((String)"testDescOrderWithThrowExceptionWriterAppend other ex throw !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethodMapFile() {
        String inFile = "mainMethodMapFile.mapfile";
        String path = new Path(TEST_DIR, inFile).toString();
        String[] args = new String[]{path, path};
        MapFile.Writer writer = null;
        try {
            writer = this.createWriter(inFile, IntWritable.class, Text.class);
            writer.append((WritableComparable)new IntWritable(1), (Writable)new Text("test_text1"));
            writer.append((WritableComparable)new IntWritable(2), (Writable)new Text("test_text2"));
            writer.close();
            MapFile.main((String[])args);
        }
        catch (Exception ex) {
            try {
                Assertions.fail((String)"testMainMethodMapFile error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosest() throws Exception {
        Path dirName = new Path(TEST_DIR, "testGetClosest.mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer.setIndexInterval((Configuration)conf, (int)3);
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, Text.class);
            Assertions.assertEquals((int)3, (int)writer.getIndexInterval());
            int FIRST_KEY = 10;
            for (int i = 10; i < 100; i += 10) {
                String iStr = Integer.toString(i);
                Text t = new Text("00".substring(iStr.length()) + iStr);
                writer.append((WritableComparable)t, (Writable)t);
            }
            writer.close();
            reader = new MapFile.Reader(qualifiedDirName, conf, new SequenceFile.Reader.Option[0]);
            Text key = new Text("55");
            Text value = new Text();
            Text closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assertions.assertEquals((Object)new Text("60"), (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assertions.assertEquals((Object)new Text("50"), (Object)closest);
            Text TWENTY = new Text("20");
            closest = (Text)reader.getClosest((WritableComparable)TWENTY, (Writable)value);
            Assertions.assertEquals((Object)TWENTY, (Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)TWENTY, (Writable)value, true);
            Assertions.assertEquals((Object)TWENTY, (Object)closest);
            key = new Text("00");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assertions.assertEquals((int)10, (int)Integer.parseInt(closest.toString()));
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assertions.assertNull((Object)closest);
            key = new Text("99");
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value);
            Assertions.assertNull((Object)closest);
            closest = (Text)reader.getClosest((WritableComparable)key, (Writable)value, true);
            Assertions.assertEquals((Object)new Text("90"), (Object)closest);
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKey() throws Exception {
        Path dirName = new Path(TEST_DIR, "testMidKey.mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer writer = null;
        MapFile.Reader reader = null;
        try {
            writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, IntWritable.class);
            writer.append((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
            writer.close();
            reader = new MapFile.Reader(qualifiedDirName, conf, new SequenceFile.Reader.Option[0]);
            Assertions.assertEquals((Object)new IntWritable(1), (Object)reader.midKey());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMidKeyEmpty() throws Exception {
        Path dirName = new Path(TEST_DIR, "testMidKeyEmpty.mapfile");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(dirName);
        MapFile.Writer writer = new MapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, IntWritable.class);
        writer.close();
        try (MapFile.Reader reader = new MapFile.Reader(qualifiedDirName, conf, new SequenceFile.Reader.Option[0]);){
            Assertions.assertEquals(null, (Object)reader.midKey());
        }
    }

    @Test
    public void testMerge() throws Exception {
        String TEST_METHOD_KEY = "testMerge.mapfile";
        int SIZE = 10;
        int ITERATIONS = 5;
        Path[] in = new Path[5];
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (int j = 0; j < 5; ++j) {
            try (MapFile.Writer writer = this.createWriter("testMerge.mapfile." + j, IntWritable.class, Text.class);){
                in[j] = new Path(TEST_DIR, "testMerge.mapfile." + j);
                for (int i = 0; i < SIZE; ++i) {
                    expected.add(i + j);
                    writer.append((WritableComparable)new IntWritable(i + j), (Writable)new Text("Value:" + (i + j)));
                }
                continue;
            }
        }
        Collections.sort(expected);
        MapFile.Merger merger = new MapFile.Merger(conf);
        merger.merge(in, true, new Path(TEST_DIR, "testMerge.mapfile"));
        try (MapFile.Reader reader = this.createReader("testMerge.mapfile", IntWritable.class);){
            int start = 0;
            Text startValue = new Text("Value:" + start);
            int i = 0;
            while (i++ < ITERATIONS) {
                Iterator expectedIterator = expected.iterator();
                IntWritable key = new IntWritable(start);
                Text value = startValue;
                IntWritable prev = new IntWritable(start);
                while (reader.next((WritableComparable)key, (Writable)value)) {
                    Assertions.assertTrue((prev.get() <= key.get() ? 1 : 0) != 0, (String)"Next key should be always equal or more");
                    Assertions.assertEquals((int)((Integer)expectedIterator.next()), (int)key.get());
                    prev.set(key.get());
                }
                reader.reset();
            }
        }
        for (int j = 0; j < in.length; ++j) {
            Path path = in[j];
            Assertions.assertFalse((boolean)path.getFileSystem(conf).exists(path), (String)"inputs should be deleted");
        }
    }
}

