/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBytesWritable {
    @Test
    public void testSizeChange() throws Exception {
        byte[] hadoop = "hadoop".getBytes();
        BytesWritable buf = new BytesWritable(hadoop);
        int size = buf.getLength();
        int orig_capacity = buf.getCapacity();
        buf.setSize(size * 2);
        int new_capacity = buf.getCapacity();
        System.arraycopy(buf.getBytes(), 0, buf.getBytes(), size, size);
        Assertions.assertTrue((new_capacity >= size * 2 ? 1 : 0) != 0);
        Assertions.assertEquals((int)(size * 2), (int)buf.getLength());
        Assertions.assertTrue((new_capacity != orig_capacity ? 1 : 0) != 0);
        buf.setSize(size * 4);
        Assertions.assertTrue((new_capacity != buf.getCapacity() ? 1 : 0) != 0);
        for (int i = 0; i < size * 2; ++i) {
            Assertions.assertEquals((byte)hadoop[i % size], (byte)buf.getBytes()[i]);
        }
        Assertions.assertEquals((int)(size * 4), (int)buf.copyBytes().length);
        buf.setCapacity(1);
        Assertions.assertEquals((int)1, (int)buf.getLength());
        Assertions.assertEquals((byte)hadoop[0], (byte)buf.getBytes()[0]);
    }

    @Test
    public void testHash() throws Exception {
        byte[] owen = "owen".getBytes();
        BytesWritable buf = new BytesWritable(owen);
        Assertions.assertEquals((int)4347922, (int)buf.hashCode());
        buf.setCapacity(10000);
        Assertions.assertEquals((int)4347922, (int)buf.hashCode());
        buf.setSize(0);
        Assertions.assertEquals((int)1, (int)buf.hashCode());
    }

    @Test
    public void testCompare() throws Exception {
        int i;
        byte[][] values = new byte[][]{"abc".getBytes(), "ad".getBytes(), "abcd".getBytes(), "".getBytes(), "b".getBytes()};
        BytesWritable[] buf = new BytesWritable[values.length];
        for (i = 0; i < values.length; ++i) {
            buf[i] = new BytesWritable(values[i]);
        }
        for (i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Assertions.assertTrue((buf[i].compareTo((BinaryComparable)buf[j]) == -buf[j].compareTo((BinaryComparable)buf[i]) ? 1 : 0) != 0);
                Assertions.assertTrue((i == j == (buf[i].compareTo((BinaryComparable)buf[j]) == 0) ? 1 : 0) != 0);
            }
        }
        Assertions.assertTrue((buf[0].compareTo((BinaryComparable)buf[1]) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((buf[1].compareTo((BinaryComparable)buf[2]) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((buf[2].compareTo((BinaryComparable)buf[3]) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((buf[3].compareTo((BinaryComparable)buf[4]) < 0 ? 1 : 0) != 0);
    }

    private void checkToString(byte[] input, String expected) {
        String actual = new BytesWritable(input).toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testToString() {
        this.checkToString(new byte[]{0, 1, 2, 16}, "00 01 02 10");
        this.checkToString(new byte[]{-128, -127, -1, -2, 1, 0}, "80 81 ff fe 01 00");
    }

    @Test
    public void testZeroCopy() {
        byte[] bytes = "brock".getBytes();
        BytesWritable zeroBuf = new BytesWritable(bytes, bytes.length);
        BytesWritable copyBuf = new BytesWritable(bytes);
        Assertions.assertTrue((bytes == zeroBuf.getBytes() ? 1 : 0) != 0, (String)"copy took place, backing array != array passed to constructor");
        Assertions.assertTrue((zeroBuf.getLength() == bytes.length ? 1 : 0) != 0, (String)"length of BW should backing byte array");
        Assertions.assertEquals((Object)zeroBuf, (Object)copyBuf, (String)"objects with same backing array should be equal");
        Assertions.assertEquals((Object)zeroBuf.toString(), (Object)copyBuf.toString(), (String)"string repr of objects with same backing array should be equal");
        Assertions.assertTrue((zeroBuf.compareTo((BinaryComparable)copyBuf) == 0 ? 1 : 0) != 0, (String)"compare order objects with same backing array should be equal");
        Assertions.assertTrue((zeroBuf.hashCode() == copyBuf.hashCode() ? 1 : 0) != 0, (String)"hash of objects with same backing array should be equal");
        byte[] buffer = new byte[bytes.length * 5];
        zeroBuf.set(buffer, 0, buffer.length);
        zeroBuf.set(bytes, 0, bytes.length);
        Assertions.assertEquals((Object)zeroBuf, (Object)copyBuf, (String)"buffer created with (array, len) has bad contents");
        Assertions.assertTrue((zeroBuf.getLength() == copyBuf.getLength() ? 1 : 0) != 0, (String)"buffer created with (array, len) has bad length");
    }

    @Test
    public void testObjectCommonMethods() {
        byte b = 9;
        ByteWritable bw = new ByteWritable();
        bw.set(b);
        Assertions.assertTrue((bw.get() == b ? 1 : 0) != 0, (String)"testSetByteWritable error");
        Assertions.assertTrue((bw.compareTo(new ByteWritable(10)) < 0 ? 1 : 0) != 0, (String)"testSetByteWritable error < 0");
        Assertions.assertTrue((bw.compareTo(new ByteWritable(8)) > 0 ? 1 : 0) != 0, (String)"testSetByteWritable error > 0");
        Assertions.assertTrue((bw.compareTo(new ByteWritable(9)) == 0 ? 1 : 0) != 0, (String)"testSetByteWritable error == 0");
        Assertions.assertTrue((boolean)bw.equals((Object)new ByteWritable(9)), (String)"testSetByteWritable equals error !!!");
        Assertions.assertTrue((!bw.equals((Object)new ByteWritable(10)) ? 1 : 0) != 0, (String)"testSetByteWritable equals error !!!");
        Assertions.assertTrue((!bw.equals((Object)new IntWritable(1)) ? 1 : 0) != 0, (String)"testSetByteWritable equals error !!!");
        Assertions.assertEquals((Object)"9", (Object)bw.toString(), (String)"testSetByteWritable error ");
    }
}

