/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.http.IsActiveServlet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIsActiveServlet {
    private IsActiveServlet servlet;
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private ByteArrayOutputStream respOut;

    @BeforeEach
    public void setUp() throws Exception {
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.respOut = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(this.respOut);
        Mockito.when((Object)this.resp.getWriter()).thenReturn((Object)writer);
    }

    @Test
    public void testSucceedsOnActive() throws IOException {
        this.servlet = new IsActiveServlet(){

            protected boolean isActive() {
                return true;
            }
        };
        String response = this.doGet();
        ((HttpServletResponse)Mockito.verify((Object)this.resp, (VerificationMode)Mockito.never())).sendError(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString());
        Assertions.assertEquals((Object)"I am Active!", (Object)response);
    }

    @Test
    public void testFailsOnInactive() throws IOException {
        this.servlet = new IsActiveServlet(){

            protected boolean isActive() {
                return false;
            }
        };
        this.doGet();
        ((HttpServletResponse)Mockito.verify((Object)this.resp, (VerificationMode)Mockito.atLeastOnce())).sendError(ArgumentMatchers.eq((int)405), (String)ArgumentMatchers.eq((Object)"I am not Active!"));
    }

    private String doGet() throws IOException {
        this.servlet.doGet(this.req, this.resp);
        return new String(this.respOut.toByteArray(), StandardCharsets.UTF_8);
    }
}

