/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.ClientBaseWithFixes;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HealthCheckFailedException;
import org.apache.hadoop.ha.MiniZKFCCluster;
import org.apache.hadoop.util.Time;
import org.apache.zookeeper.server.ServerCnxn;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestZKFailoverControllerStress
extends ClientBaseWithFixes {
    private static final int STRESS_RUNTIME_SECS = 30;
    private static final int EXTRA_TIMEOUT_SECS = 10;
    private Configuration conf;
    private MiniZKFCCluster cluster;

    @BeforeEach
    public void setupConfAndServices() throws Exception {
        this.conf = new Configuration();
        this.conf.set("ha.zookeeper.quorum", this.hostPort);
        this.cluster = new MiniZKFCCluster(this.conf, TestZKFailoverControllerStress.getServer(this.serverFactory));
    }

    @AfterEach
    public void stopCluster() throws Exception {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    @Test
    @Timeout(value=40L)
    public void testExpireBackAndForth() throws Exception {
        this.cluster.start();
        long st = Time.now();
        long runFor = 30000L;
        int i = 0;
        while (Time.now() - st < runFor) {
            int from = i % 2;
            int to = (i + 1) % 2;
            LOG.info("Failing over via expiration from " + from + " to " + to);
            this.cluster.expireAndVerifyFailover(from, to);
            ++i;
        }
    }

    @Test
    @Timeout(value=40L)
    public void testRandomExpirations() throws Exception {
        this.cluster.start();
        long st = Time.now();
        long runFor = 30000L;
        Random r = new Random();
        while (Time.now() - st < runFor) {
            this.cluster.getTestContext().checkException();
            int targetIdx = r.nextInt(2);
            ActiveStandbyElector target = this.cluster.getElector(targetIdx);
            long sessId = target.getZKSessionIdForTests();
            if (sessId != -1L) {
                LOG.info(String.format("Expiring session %x for svc %d", sessId, targetIdx));
                TestZKFailoverControllerStress.getServer(this.serverFactory).closeSession(sessId);
            }
            Thread.sleep(r.nextInt(300));
        }
    }

    @Test
    @Timeout(value=40L)
    public void testRandomHealthAndDisconnects() throws Exception {
        long runFor = 30000L;
        ((HAServiceProtocol)Mockito.doAnswer((Answer)new RandomlyThrow(0)).when((Object)this.cluster.getService((int)0).proxy)).monitorHealth();
        ((HAServiceProtocol)Mockito.doAnswer((Answer)new RandomlyThrow(1)).when((Object)this.cluster.getService((int)1).proxy)).monitorHealth();
        this.conf.setInt("ha.failover-controller.active-standby-elector.zk.op.retries", 100);
        this.cluster.start();
        long st = Time.now();
        while (Time.now() - st < runFor) {
            this.cluster.getTestContext().checkException();
            this.serverFactory.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
            Thread.sleep(50L);
        }
    }

    private static class RandomlyThrow
    implements Answer {
        private Random r = new Random();
        private final int svcIdx;

        public RandomlyThrow(int svcIdx) {
            this.svcIdx = svcIdx;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            if (this.r.nextBoolean()) {
                ClientBaseWithFixes.LOG.info("Throwing an exception for svc " + this.svcIdx);
                throw new HealthCheckFailedException("random failure");
            }
            return invocation.callRealMethod();
        }
    }
}

