/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.TestFileUtil;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.FsGetter;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.TestChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.fs.viewfs.ViewFileSystemUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewFileSystemBaseTest {
    FileSystem fsView;
    FileSystem fsTarget;
    Path targetTestRoot;
    Configuration conf;
    final FileSystemTestHelper fileSystemTestHelper = this.createFileSystemHelper();
    private static final Logger LOG = LoggerFactory.getLogger(ViewFileSystemBaseTest.class);
    @TempDir
    public File temporaryFolder;
    protected static boolean SupportsBlocks = false;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.initializeTargetTestRoot();
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "user"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "data"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "dir2"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "dir3"));
        FileSystemTestHelper.createFile(this.fsTarget, new Path(this.targetTestRoot, "aFile"));
        this.conf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
    }

    void setupMountPoints() {
        ConfigUtil.addLink((Configuration)this.conf, (String)"/targetRoot", (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user2", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/data", (URI)new Path(this.targetTestRoot, "data").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/linkToDir2", (URI)new Path(this.targetTestRoot, "dir2").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/internalDir2/linkToDir3", (URI)new Path(this.targetTestRoot, "dir3").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/danglingLink", (URI)new Path(this.targetTestRoot, "missingTarget").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/linkToAFile", (URI)new Path(this.targetTestRoot, "aFile").toUri());
    }

    @Test
    public void testGetMountPoints() {
        ViewFileSystem.MountPoint[] mountPoints;
        ViewFileSystem viewfs = (ViewFileSystem)this.fsView;
        for (ViewFileSystem.MountPoint mountPoint : mountPoints = viewfs.getMountPoints()) {
            LOG.info("MountPoint: " + mountPoint.getMountedOnPath() + " => " + mountPoint.getTargetFileSystemURIs()[0]);
        }
        Assertions.assertEquals((int)mountPoints.length, (int)this.getExpectedMountPoints());
    }

    int getExpectedMountPoints() {
        return 8;
    }

    @Test
    public void testGetDelegationTokens() throws IOException {
        Token[] delTokens = this.fsView.addDelegationTokens("sanjay", new Credentials());
        Assertions.assertEquals((int)delTokens.length, (int)this.getExpectedDelegationTokenCount());
    }

    int getExpectedDelegationTokenCount() {
        return 0;
    }

    @Test
    public void testGetDelegationTokensWithCredentials() throws IOException {
        Credentials credentials = new Credentials();
        List<Token> delTokens = Arrays.asList(this.fsView.addDelegationTokens("sanjay", credentials));
        int expectedTokenCount = this.getExpectedDelegationTokenCountWithCredentials();
        Assertions.assertEquals((int)delTokens.size(), (int)expectedTokenCount);
        Credentials newCredentials = new Credentials();
        for (int i = 0; i < expectedTokenCount / 2; ++i) {
            Token token = delTokens.get(i);
            newCredentials.addToken(token.getService(), token);
        }
        List<Token> delTokens2 = Arrays.asList(this.fsView.addDelegationTokens("sanjay", newCredentials));
        Assertions.assertEquals((int)delTokens2.size(), (int)((expectedTokenCount + 1) / 2));
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 0;
    }

    @Test
    public void testBasicPaths() {
        Assertions.assertEquals((Object)this.fsView.getUri(), (Object)FsConstants.VIEWFS_URI);
        Assertions.assertEquals((Object)this.fsView.getWorkingDirectory(), (Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))));
        Assertions.assertEquals((Object)this.fsView.getHomeDirectory(), (Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))));
        Assertions.assertEquals((Object)this.fsView.makeQualified(new Path("/foo/bar")), (Object)new Path("/foo/bar").makeQualified(FsConstants.VIEWFS_URI, null));
    }

    @Test
    public void testLocatedOperationsThroughMountLinks() throws IOException {
        this.testOperationsThroughMountLinksInternal(true);
    }

    @Test
    public void testOperationsThroughMountLinks() throws IOException {
        this.testOperationsThroughMountLinksInternal(false);
    }

    private void testOperationsThroughMountLinksInternal(boolean located) throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        Assertions.assertTrue((boolean)this.fsView.isFile(new Path("/user/foo")), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "user/foo")), (String)"Target of created file should be type file");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/user/foo"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/user/foo")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/foo")), (String)"Target File should not exist after delete");
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/linkToDir2/foo");
        Assertions.assertTrue((boolean)this.fsView.isFile(new Path("/internalDir/linkToDir2/foo")), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "dir2/foo")), (String)"Target of created file should be type file");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/internalDir/linkToDir2/foo"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/internalDir/linkToDir2/foo")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "dir2/foo")), (String)"Target File should not exist after delete");
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/internalDir2/linkToDir3/foo");
        Assertions.assertTrue((boolean)this.fsView.isFile(new Path("/internalDir/internalDir2/linkToDir3/foo")), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "dir3/foo")), (String)"Target of created file should be type file");
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/linkToDir2/missingDir/miss2/foo");
        Assertions.assertTrue((boolean)this.fsView.isFile(new Path("/internalDir/linkToDir2/missingDir/miss2/foo")), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "dir2/missingDir/miss2/foo")), (String)"Target of created file should be type file");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/internalDir/internalDir2/linkToDir3/foo"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/internalDir/internalDir2/linkToDir3/foo")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "dir3/foo")), (String)"Target File should not exist after delete");
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX"));
        Assertions.assertTrue((boolean)this.fsView.isDirectory(new Path("/user/dirX")), (String)"New dir should be type dir");
        Assertions.assertTrue((boolean)this.fsTarget.isDirectory(new Path(this.targetTestRoot, "user/dirX")), (String)"Target of new dir should be of type dir");
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX/dirY"));
        Assertions.assertTrue((boolean)this.fsView.isDirectory(new Path("/user/dirX/dirY")), (String)"New dir should be type dir");
        Assertions.assertTrue((boolean)this.fsTarget.isDirectory(new Path(this.targetTestRoot, "user/dirX/dirY")), (String)"Target of new dir should be of type dir");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/user/dirX/dirY"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/user/dirX/dirY")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/dirX/dirY")), (String)"Target File should not exist after delete");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/user/dirX"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/user/dirX")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/dirX")));
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        this.fsView.rename(new Path("/user/foo"), new Path("/user/fooBar"));
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/user/foo")), (String)"Renamed src should not exist");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/foo")), (String)"Renamed src should not exist in target");
        Assertions.assertTrue((boolean)this.fsView.isFile(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/fooBar")), (String)"Renamed dest should  exist as file");
        Assertions.assertTrue((boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "user/fooBar")), (String)"Renamed dest should  exist as file in target");
        this.fsView.mkdirs(new Path("/user/dirFoo"));
        this.fsView.rename(new Path("/user/dirFoo"), new Path("/user/dirFooBar"));
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/user/dirFoo")), (String)"Renamed src should not exist");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "user/dirFoo")), (String)"Renamed src should not exist in target");
        Assertions.assertTrue((boolean)this.fsView.isDirectory(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirFooBar")), (String)"Renamed dest should  exist as dir");
        Assertions.assertTrue((boolean)this.fsTarget.isDirectory(new Path(this.targetTestRoot, "user/dirFooBar")), (String)"Renamed dest should  exist as dir in target");
        this.fsView.mkdirs(new Path("/targetRoot/dirFoo"));
        Assertions.assertTrue((boolean)this.fsView.exists(new Path("/targetRoot/dirFoo")));
        boolean dirFooPresent = false;
        for (FileStatus fileStatus : this.listStatusInternal(located, new Path("/targetRoot/"))) {
            if (!fileStatus.getPath().getName().equals("dirFoo")) continue;
            dirFooPresent = true;
        }
        Assertions.assertTrue((boolean)dirFooPresent);
    }

    @Test
    public void testRenameAcrossMounts1() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        try {
            this.fsView.rename(new Path("/user/foo"), new Path("/user2/fooBarBar"));
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMounts2() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        try {
            this.fsView.rename(new Path("/user/foo"), new Path("/data/fooBar"));
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMounts3() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_TARGET_URI_ACROSS_MOUNTPOINT.toString());
        FileSystem fsView2 = FileSystem.newInstance((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        this.fileSystemTestHelper.createFile(fsView2, "/user/foo");
        fsView2.rename(new Path("/user/foo"), new Path("/user2/fooBarBar"));
        ContractTestUtils.assertPathDoesNotExist(fsView2, "src should not exist after rename", new Path("/user/foo"));
        ContractTestUtils.assertPathDoesNotExist(this.fsTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fsView2, this.fileSystemTestHelper.getTestRootPath(fsView2, "/user2/fooBarBar"));
        ContractTestUtils.assertIsFile(this.fsTarget, new Path(this.targetTestRoot, "user/fooBarBar"));
    }

    @Test
    public void testRenameAcrossMounts4() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_FILESYSTEM_ACROSS_MOUNTPOINT.toString());
        FileSystem fsView2 = FileSystem.newInstance((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        this.fileSystemTestHelper.createFile(fsView2, "/user/foo");
        fsView2.rename(new Path("/user/foo"), new Path("/data/fooBar"));
        ContractTestUtils.assertPathDoesNotExist(fsView2, "src should not exist after rename", new Path("/user/foo"));
        ContractTestUtils.assertPathDoesNotExist(this.fsTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fsView2, this.fileSystemTestHelper.getTestRootPath(fsView2, "/data/fooBar"));
        ContractTestUtils.assertIsFile(this.fsTarget, new Path(this.targetTestRoot, "data/fooBar"));
    }

    @Test
    public void testRenameAcrossNestedMountPointSameTarget() throws IOException {
        this.setUpNestedMountPoint();
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        try {
            this.fsView.rename(new Path("/user/foo"), new Path("/user/userA/foo"));
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMountPointDifferentTarget() throws IOException {
        this.setUpNestedMountPoint();
        this.fileSystemTestHelper.createFile(this.fsView, "/data/foo");
        try {
            this.fsView.rename(new Path("/data/foo"), new Path("/data/dataA/fooBar"));
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossNestedMountPointSameTargetUriAcrossMountPoint() throws IOException {
        this.setUpNestedMountPoint();
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_TARGET_URI_ACROSS_MOUNTPOINT.toString());
        FileSystem fsView2 = FileSystem.newInstance((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        this.fileSystemTestHelper.createFile(fsView2, "/user/foo");
        fsView2.rename(new Path("/user/foo"), new Path("/user/userA/fooBarBar"));
        ContractTestUtils.assertPathDoesNotExist(fsView2, "src should not exist after rename", new Path("/user/foo"));
        ContractTestUtils.assertPathDoesNotExist(this.fsTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fsView2, this.fileSystemTestHelper.getTestRootPath(fsView2, "/user/userA/fooBarBar"));
        ContractTestUtils.assertIsFile(this.fsTarget, new Path(this.targetTestRoot, "user/fooBarBar"));
    }

    @Test
    public void testRenameAcrossNestedMountPointSameFileSystemAcrossMountPoint() throws IOException {
        this.setUpNestedMountPoint();
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_FILESYSTEM_ACROSS_MOUNTPOINT.toString());
        FileSystem fsView2 = FileSystem.newInstance((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        this.fileSystemTestHelper.createFile(fsView2, "/data/foo");
        fsView2.rename(new Path("/data/foo"), new Path("/data/dataB/fooBar"));
        ContractTestUtils.assertPathDoesNotExist(fsView2, "src should not exist after rename", new Path("/data/foo"));
        ContractTestUtils.assertPathDoesNotExist(this.fsTarget, "src should not exist after rename", new Path(this.targetTestRoot, "data/foo"));
        ContractTestUtils.assertIsFile(fsView2, this.fileSystemTestHelper.getTestRootPath(fsView2, "/user/fooBar"));
        ContractTestUtils.assertIsFile(this.fsTarget, new Path(this.targetTestRoot, "user/fooBar"));
    }

    @Test
    public void testOperationsThroughNestedMountPointsInternal() throws IOException {
        this.setUpNestedMountPoint();
        this.fileSystemTestHelper.createFile(this.fsView, "/user/userB/foo");
        Assertions.assertTrue((boolean)this.fsView.getFileStatus(new Path("/user/userB/foo")).isFile(), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.getFileStatus(new Path(this.targetTestRoot, "userB/foo")).isFile(), (String)"Target of created file should be type file");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/user/userB/foo"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/user/userB/foo")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "userB/foo")), (String)"Target File should not exist after delete");
        this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/linkToDir2/linkToDir2/foo");
        Assertions.assertTrue((boolean)this.fsView.getFileStatus(new Path("/internalDir/linkToDir2/linkToDir2/foo")).isFile(), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.getFileStatus(new Path(this.targetTestRoot, "linkToDir2/foo")).isFile(), (String)"Target of created file should be type file");
        Assertions.assertTrue((boolean)this.fsView.delete(new Path("/internalDir/linkToDir2/linkToDir2/foo"), false), (String)"Delete should succeed");
        Assertions.assertFalse((boolean)this.fsView.exists(new Path("/internalDir/linkToDir2/linkToDir2/foo")), (String)"File should not exist after delete");
        Assertions.assertFalse((boolean)this.fsTarget.exists(new Path(this.targetTestRoot, "linkToDir2/foo")), (String)"Target File should not exist after delete");
    }

    private void setUpNestedMountPoint() throws IOException {
        ConfigUtil.setIsNestedMountPointSupported((Configuration)this.conf, (boolean)true);
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user/userA", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user/userB", (URI)new Path(this.targetTestRoot, "userB").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/data/dataA", (URI)new Path(this.targetTestRoot, "dataA").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/data/dataB", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/linkToDir2/linkToDir2", (URI)new Path(this.targetTestRoot, "linkToDir2").toUri());
        this.fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
    }

    @Test
    public void testGetBlockLocations() throws IOException {
        Path targetFilePath = new Path(this.targetTestRoot, "data/largeFile");
        FileSystemTestHelper.createFile(this.fsTarget, targetFilePath, 10, 1024);
        Path viewFilePath = new Path("/data/largeFile");
        Assertions.assertTrue((boolean)this.fsView.isFile(viewFilePath), (String)"Created File should be type File");
        BlockLocation[] viewBL = this.fsView.getFileBlockLocations(this.fsView.getFileStatus(viewFilePath), 0L, 10340L);
        Assertions.assertEquals((int)(SupportsBlocks ? 10 : 1), (int)viewBL.length);
        BlockLocation[] targetBL = this.fsTarget.getFileBlockLocations(this.fsTarget.getFileStatus(targetFilePath), 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
        this.fsView.getFileBlockLocations(this.fsView.getFileStatus(viewFilePath), 0L, 10340L);
        targetBL = this.fsTarget.getFileBlockLocations(this.fsTarget.getFileStatus(targetFilePath), 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
    }

    void compareBLs(BlockLocation[] viewBL, BlockLocation[] targetBL) {
        Assertions.assertEquals((int)viewBL.length, (int)targetBL.length);
        int i = 0;
        for (BlockLocation vbl : viewBL) {
            Assertions.assertEquals((Object)vbl.toString(), (Object)targetBL[i].toString());
            Assertions.assertEquals((long)vbl.getOffset(), (long)targetBL[i].getOffset());
            Assertions.assertEquals((long)vbl.getLength(), (long)targetBL[i].getLength());
            ++i;
        }
    }

    @Test
    public void testLocatedListOnInternalDirsOfMountTable() throws IOException {
        this.testListOnInternalDirsOfMountTableInternal(true);
    }

    @Test
    public void testListOnInternalDirsOfMountTable() throws IOException {
        this.testListOnInternalDirsOfMountTableInternal(false);
    }

    private void testListOnInternalDirsOfMountTableInternal(boolean located) throws IOException {
        FileStatus[] dirPaths = this.listStatusInternal(located, new Path("/"));
        this.verifyRootChildren(dirPaths);
        dirPaths = this.listStatusInternal(located, new Path("/internalDir"));
        Assertions.assertEquals((int)dirPaths.length, (int)2);
        FileStatus fs = this.fileSystemTestHelper.containsPath(this.fsView, "/internalDir/internalDir2", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isDirectory(), (String)"A mount should appear as symlink");
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/internalDir/linkToDir2", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
    }

    private void verifyRootChildren(FileStatus[] dirPaths) throws IOException {
        Assertions.assertEquals((int)dirPaths.length, (int)this.getExpectedDirPaths());
        FileStatus fs = this.fileSystemTestHelper.containsPath(this.fsView, "/user", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/internalDir", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isDirectory(), (String)"A mount should appear as symlink");
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/danglingLink", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/linkToAFile", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
    }

    int getExpectedDirPaths() {
        return 7;
    }

    @Test
    public void testListOnMountTargetDirs() throws IOException {
        this.testListOnMountTargetDirsInternal(false);
    }

    @Test
    public void testLocatedListOnMountTargetDirs() throws IOException {
        this.testListOnMountTargetDirsInternal(true);
    }

    private void testListOnMountTargetDirsInternal(boolean located) throws IOException {
        Path dataPath = new Path("/data");
        FileStatus[] dirPaths = this.listStatusInternal(located, dataPath);
        Assertions.assertEquals((int)dirPaths.length, (int)0);
        long len = this.fileSystemTestHelper.createFile(this.fsView, "/data/foo");
        dirPaths = this.listStatusInternal(located, dataPath);
        Assertions.assertEquals((int)dirPaths.length, (int)1);
        FileStatus fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data/foo", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isFile(), (String)"Created file shoudl appear as a file");
        Assertions.assertEquals((long)fs.getLen(), (long)len);
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/data/dirX"));
        dirPaths = this.listStatusInternal(located, dataPath);
        Assertions.assertEquals((int)dirPaths.length, (int)2);
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data/foo", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isFile(), (String)"Created file shoudl appear as a file");
        fs = this.fileSystemTestHelper.containsPath(this.fsView, "/data/dirX", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isDirectory(), (String)"Created dir should appear as a dir");
    }

    private FileStatus[] listStatusInternal(boolean located, Path dataPath) throws IOException {
        FileStatus[] dirPaths = new FileStatus[]{};
        if (located) {
            RemoteIterator statIter = this.fsView.listLocatedStatus(dataPath);
            ArrayList<LocatedFileStatus> tmp = new ArrayList<LocatedFileStatus>(10);
            while (statIter.hasNext()) {
                tmp.add((LocatedFileStatus)statIter.next());
            }
            dirPaths = tmp.toArray(dirPaths);
        } else {
            dirPaths = this.fsView.listStatus(dataPath);
        }
        return dirPaths;
    }

    @Test
    public void testFileStatusOnMountLink() throws IOException {
        Assertions.assertTrue((boolean)this.fsView.getFileStatus(new Path("/")).isDirectory());
        FileSystemTestHelper.checkFileStatus(this.fsView, "/", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/user", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/data", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/internalDir", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/internalDir/linkToDir2", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/internalDir/internalDir2/linkToDir3", FileSystemTestHelper.fileType.isDir);
        FileSystemTestHelper.checkFileStatus(this.fsView, "/linkToAFile", FileSystemTestHelper.fileType.isFile);
    }

    @Test
    public void testgetFSonDanglingLink() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.getFileStatus(new Path("/danglingLink")));
    }

    @Test
    public void testgetFSonNonExistingInternalDir() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.getFileStatus(new Path("/internalDir/nonExisting")));
    }

    @Test
    public void testResolvePathInternalPaths() throws IOException {
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/")), (Object)new Path("/"));
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/internalDir")), (Object)new Path("/internalDir"));
    }

    @Test
    public void testResolvePathMountPoints() throws IOException {
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/user")), (Object)new Path(this.targetTestRoot, "user"));
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/data")), (Object)new Path(this.targetTestRoot, "data"));
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/internalDir/linkToDir2")), (Object)new Path(this.targetTestRoot, "dir2"));
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/internalDir/internalDir2/linkToDir3")), (Object)new Path(this.targetTestRoot, "dir3"));
    }

    @Test
    public void testResolvePathThroughMountPoints() throws IOException {
        this.fileSystemTestHelper.createFile(this.fsView, "/user/foo");
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/user/foo")), (Object)new Path(this.targetTestRoot, "user/foo"));
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX"));
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/user/dirX")), (Object)new Path(this.targetTestRoot, "user/dirX"));
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX/dirY"));
        Assertions.assertEquals((Object)this.fsView.resolvePath(new Path("/user/dirX/dirY")), (Object)new Path(this.targetTestRoot, "user/dirX/dirY"));
    }

    @Test
    public void testResolvePathDanglingLink() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.resolvePath(new Path("/danglingLink")));
    }

    @Test
    public void testResolvePathMissingThroughMountPoints() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.resolvePath(new Path("/user/nonExisting")));
    }

    @Test
    public void testResolvePathMissingThroughMountPoints2() throws IOException {
        this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/dirX"));
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.resolvePath(new Path("/user/dirX/nonExisting")));
    }

    @Test
    public void testInternalMkdirSlash() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/")));
    }

    public void testInternalMkdirExisting1() throws IOException {
        Assertions.assertTrue((boolean)this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/internalDir")), (String)"mkdir of existing dir should succeed");
    }

    public void testInternalMkdirExisting2() throws IOException {
        Assertions.assertTrue((boolean)this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/internalDir/linkToDir2")), (String)"mkdir of existing dir should succeed");
    }

    @Test
    public void testInternalMkdirNew() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/dirNew")));
    }

    @Test
    public void testInternalMkdirNew2() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.mkdirs(this.fileSystemTestHelper.getTestRootPath(this.fsView, "/internalDir/dirNew")));
    }

    @Test
    public void testInternalCreate1() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fileSystemTestHelper.createFile(this.fsView, "/foo"));
    }

    @Test
    public void testInternalCreate2() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/foo"));
    }

    @Test
    public void testInternalCreateMissingDir() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fileSystemTestHelper.createFile(this.fsView, "/missingDir/foo"));
    }

    @Test
    public void testInternalCreateMissingDir2() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fileSystemTestHelper.createFile(this.fsView, "/missingDir/miss2/foo"));
    }

    @Test
    public void testInternalCreateMissingDir3() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fileSystemTestHelper.createFile(this.fsView, "/internalDir/miss2/foo"));
    }

    @Test
    public void testInternalDeleteNonExisting() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.delete(new Path("/NonExisting"), false));
    }

    @Test
    public void testInternalDeleteNonExisting2() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fsView.delete(new Path("/internalDir/NonExisting"), false));
    }

    @Test
    public void testInternalDeleteExisting() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.delete(new Path("/internalDir"), false));
    }

    @Test
    public void testInternalDeleteExisting2() throws IOException {
        this.fsView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory();
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.delete(new Path("/internalDir/linkToDir2"), false));
    }

    @Test
    public void testMkdirOfMountLink() throws IOException {
        Assertions.assertTrue((boolean)this.fsView.mkdirs(new Path("/data")), (String)"mkdir of existing mount link should succeed");
    }

    @Test
    public void testInternalRename1() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.rename(new Path("/internalDir"), new Path("/newDir")));
    }

    @Test
    public void testInternalRename2() throws IOException {
        this.fsView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory();
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.rename(new Path("/internalDir/linkToDir2"), new Path("/internalDir/dir1")));
    }

    @Test
    public void testInternalRename3() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.rename(new Path("/user"), new Path("/internalDir/linkToDir2")));
    }

    @Test
    public void testInternalRenameToSlash() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.rename(new Path("/internalDir/linkToDir2/foo"), new Path("/")));
    }

    @Test
    public void testInternalRenameFromSlash() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.rename(new Path("/"), new Path("/bar")));
    }

    @Test
    public void testInternalSetOwner() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.setOwner(new Path("/internalDir"), "foo", "bar"));
    }

    @Test
    public void testCreateNonRecursive() throws IOException {
        Path path = this.fileSystemTestHelper.getTestRootPath(this.fsView, "/user/foo");
        this.fsView.createNonRecursive(path, false, 1024, (short)1, 1024L, null);
        FileStatus status = this.fsView.getFileStatus(new Path("/user/foo"));
        Assertions.assertTrue((boolean)this.fsView.isFile(new Path("/user/foo")), (String)"Created file should be type file");
        Assertions.assertTrue((boolean)this.fsTarget.isFile(new Path(this.targetTestRoot, "user/foo")), (String)"Target of created file should be type file");
    }

    @Test
    public void testRootReadableExecutable() throws IOException {
        this.testRootReadableExecutableInternal(false);
    }

    @Test
    public void testLocatedRootReadableExecutable() throws IOException {
        this.testRootReadableExecutableInternal(true);
    }

    private void testRootReadableExecutableInternal(boolean located) throws IOException {
        Assertions.assertFalse((boolean)this.fsView.getWorkingDirectory().isRoot(), (String)"In root before cd");
        this.fsView.setWorkingDirectory(new Path("/"));
        Assertions.assertTrue((boolean)this.fsView.getWorkingDirectory().isRoot(), (String)"Not in root dir after cd");
        this.verifyRootChildren(this.listStatusInternal(located, this.fsView.getWorkingDirectory()));
        FileStatus rootStatus = this.fsView.getFileStatus(this.fsView.getWorkingDirectory());
        FsPermission perms = rootStatus.getPermission();
        Assertions.assertTrue((boolean)perms.getUserAction().implies(FsAction.EXECUTE), (String)"User-executable permission not set!");
        Assertions.assertTrue((boolean)perms.getUserAction().implies(FsAction.READ), (String)"User-readable permission not set!");
        Assertions.assertTrue((boolean)perms.getGroupAction().implies(FsAction.EXECUTE), (String)"Group-executable permission not set!");
        Assertions.assertTrue((boolean)perms.getGroupAction().implies(FsAction.READ), (String)"Group-readable permission not set!");
        Assertions.assertTrue((boolean)perms.getOtherAction().implies(FsAction.EXECUTE), (String)"Other-executable permission not set!");
        Assertions.assertTrue((boolean)perms.getOtherAction().implies(FsAction.READ), (String)"Other-readable permission not set!");
    }

    @Test
    public void testInternalModifyAclEntries() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.modifyAclEntries(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalRemoveAclEntries() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.removeAclEntries(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalRemoveDefaultAcl() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.removeDefaultAcl(new Path("/internalDir")));
    }

    @Test
    public void testInternalRemoveAcl() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.removeAcl(new Path("/internalDir")));
    }

    @Test
    public void testInternalSetAcl() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.setAcl(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalGetAclStatus() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        AclStatus aclStatus = this.fsView.getAclStatus(new Path("/internalDir"));
        Assertions.assertEquals((Object)currentUser.getUserName(), (Object)aclStatus.getOwner());
        Assertions.assertEquals((Object)currentUser.getGroupNames()[0], (Object)aclStatus.getGroup());
        Assertions.assertEquals((Object)AclUtil.getMinimalAcl((FsPermission)Constants.PERMISSION_555), (Object)aclStatus.getEntries());
        Assertions.assertFalse((boolean)aclStatus.isStickyBit());
    }

    @Test
    public void testInternalSetXAttr() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.setXAttr(new Path("/internalDir"), "xattrName", null));
    }

    @Test
    public void testInternalGetXAttr() throws IOException {
        Assertions.assertThrows(NotInMountpointException.class, () -> this.fsView.getXAttr(new Path("/internalDir"), "xattrName"));
    }

    @Test
    public void testInternalGetXAttrs() throws IOException {
        Assertions.assertThrows(NotInMountpointException.class, () -> this.fsView.getXAttrs(new Path("/internalDir")));
    }

    @Test
    public void testInternalGetXAttrsWithNames() throws IOException {
        Assertions.assertThrows(NotInMountpointException.class, () -> this.fsView.getXAttrs(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalListXAttr() throws IOException {
        Assertions.assertThrows(NotInMountpointException.class, () -> this.fsView.listXAttrs(new Path("/internalDir")));
    }

    @Test
    public void testInternalRemoveXAttr() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.removeXAttr(new Path("/internalDir"), "xattrName"));
    }

    @Test
    public void testInternalCreateSnapshot1() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.createSnapshot(new Path("/internalDir")));
    }

    @Test
    public void testInternalCreateSnapshot2() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.createSnapshot(new Path("/internalDir"), "snap1"));
    }

    @Test
    public void testInternalRenameSnapshot() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.renameSnapshot(new Path("/internalDir"), "snapOldName", "snapNewName"));
    }

    @Test
    public void testInternalDeleteSnapshot() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.deleteSnapshot(new Path("/internalDir"), "snap1"));
    }

    @Test
    public void testInternalSetStoragePolicy() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.setStoragePolicy(new Path("/internalDir"), "HOT"));
    }

    @Test
    public void testInternalUnsetStoragePolicy() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.unsetStoragePolicy(new Path("/internalDir")));
    }

    @Test
    public void testInternalSatisfyStoragePolicy() throws IOException {
        Assertions.assertThrows(AccessControlException.class, () -> this.fsView.satisfyStoragePolicy(new Path("/internalDir")));
    }

    @Test
    public void testInternalgetStoragePolicy() throws IOException {
        Assertions.assertThrows(NotInMountpointException.class, () -> this.fsView.getStoragePolicy(new Path("/internalDir")));
    }

    @Test
    public void testInternalGetAllStoragePolicies() throws IOException {
        Collection policies = this.fsView.getAllStoragePolicies();
        for (FileSystem fs : this.fsView.getChildFileSystems()) {
            try {
                for (BlockStoragePolicySpi s : fs.getAllStoragePolicies()) {
                    Assertions.assertTrue((boolean)policies.contains(s), (String)("Missing policy: " + s));
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConfLinkSlash() throws Exception {
        String clusterName = "ClusterX";
        URI viewFsUri = new URI("viewfs", clusterName, "/", null, null);
        Configuration newConf = new Configuration();
        ConfigUtil.addLink((Configuration)newConf, (String)clusterName, (String)"/", (URI)new Path(this.targetTestRoot, "/").toUri());
        String mtPrefix = "fs.viewfs.mounttable." + clusterName + ".";
        try {
            FileSystem.get((URI)viewFsUri, (Configuration)newConf);
            Assertions.fail((String)("ViewFileSystem should error out on mount table entry: " + mtPrefix + "link./"));
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFileSystemException) {
                String msg = " Use linkMergeSlash instead";
                GenericTestUtils.assertExceptionContains(msg, e);
            }
            Assertions.fail((String)("Unexpected exception: " + e.getMessage()));
        }
    }

    @Test
    public void testTrashRoot() throws IOException {
        Path mountDataRootPath = new Path("/data");
        Path fsTargetFilePath = new Path("debug.log");
        Path mountDataFilePath = new Path(mountDataRootPath, fsTargetFilePath);
        Path mountDataNonExistingFilePath = new Path(mountDataRootPath, "no.log");
        FileSystemTestHelper.createFile(this.fsTarget, fsTargetFilePath);
        Path mountDataRootTrashPath = this.fsView.getTrashRoot(mountDataRootPath);
        Path mountDataFileTrashPath = this.fsView.getTrashRoot(mountDataFilePath);
        Path fsTargetRootTrashRoot = this.fsTarget.getTrashRoot(mountDataRootPath);
        Path fsTargetFileTrashPath = this.fsTarget.getTrashRoot(mountDataFilePath);
        Assertions.assertEquals((Object)fsTargetRootTrashRoot.toUri().getPath(), (Object)mountDataRootTrashPath.toUri().getPath());
        Assertions.assertEquals((Object)fsTargetFileTrashPath.toUri().getPath(), (Object)mountDataFileTrashPath.toUri().getPath());
        Assertions.assertEquals((Object)mountDataFileTrashPath.toUri().getPath(), (Object)mountDataRootTrashPath.toUri().getPath());
        Path trashRoot = this.fsView.getTrashRoot(mountDataNonExistingFilePath);
        Assertions.assertEquals((Object)trashRoot.toUri().getPath(), (Object)mountDataRootTrashPath.toUri().getPath());
        Path invalidMountRootPath = new Path("/invalid_mount");
        Path invalidMountFilePath = new Path(invalidMountRootPath, "debug.log");
        try {
            this.fsView.getTrashRoot(invalidMountRootPath);
            Assertions.fail((String)"ViewFileSystem getTashRoot should fail for non-mountpoint paths.");
        }
        catch (NotInMountpointException notInMountpointException) {
            // empty catch block
        }
        try {
            this.fsView.getTrashRoot(invalidMountFilePath);
            Assertions.fail((String)"ViewFileSystem getTashRoot should fail for non-mountpoint paths.");
        }
        catch (NotInMountpointException notInMountpointException) {
            // empty catch block
        }
        try {
            this.fsView.getTrashRoot(null);
            Assertions.fail((String)"ViewFileSystem getTashRoot should fail for empty paths.");
        }
        catch (NotInMountpointException notInMountpointException) {
            // empty catch block
        }
        FileStatus fileStatus = this.fsTarget.getFileStatus(fsTargetFilePath);
        Configuration newConf = new Configuration(this.conf);
        newConf.setLong("fs.trash.interval", 1000L);
        Trash lTrash = new Trash(this.fsTarget, newConf);
        boolean trashed = lTrash.moveToTrash(fsTargetFilePath);
        Assertions.assertTrue((boolean)trashed, (String)("File " + fileStatus + " move to trash failed."));
        Assertions.assertTrue((this.fsView.getTrashRoots(true).size() > 0 ? 1 : 0) != 0, (String)"");
    }

    Path getTrashRootInFallBackFS() throws IOException {
        return new Path(this.fsTarget.getHomeDirectory().toUri().getPath(), ".Trash");
    }

    @Test
    public void testTrashRootForceInsideMountPoint() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Configuration conf2 = new Configuration(this.conf);
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", true);
        ConfigUtil.addLinkFallback((Configuration)conf2, (URI)this.targetTestRoot.toUri());
        FileSystem fsView2 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        Path dataTestPath = new Path("/data/dir/file");
        Path dataTrashRoot = fsView2.makeQualified(new Path("/data/.Trash/" + ugi.getShortUserName()));
        Assertions.assertEquals((Object)fsView2.getTrashRoot(dataTestPath), (Object)dataTrashRoot);
        Path nonExistentPath = new Path("/nonExistentDir/nonExistentFile");
        Path expectedTrash = fsView2.makeQualified(this.getTrashRootInFallBackFS());
        Assertions.assertEquals((Object)fsView2.getTrashRoot(nonExistentPath), (Object)expectedTrash);
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", false);
        fsView2 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        Path targetFSUserHomeTrashRoot = this.fsTarget.makeQualified(new Path(this.fsTarget.getHomeDirectory(), ".Trash"));
        Assertions.assertEquals((Object)fsView2.getTrashRoot(dataTestPath), (Object)targetFSUserHomeTrashRoot);
        conf2 = new Configuration(this.conf);
        fsView2 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        try {
            fsView2.getTrashRoot(nonExistentPath);
        }
        catch (NotInMountpointException notInMountpointException) {
            // empty catch block
        }
    }

    @Test
    public void testTrashRootDeepTrashDir() throws IOException {
        Configuration conf2 = ViewFileSystemTestSetup.createConfig();
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", true);
        conf2.setClass("fs.mocktrashfs.impl", DeepTrashRootMockFS.class, FileSystem.class);
        ConfigUtil.addLink((Configuration)conf2, (String)"/mnt/datavol1", (URI)URI.create("mocktrashfs://localhost/vol"));
        Path testPath = new Path("/mnt/datavol1/projs/proj");
        FileSystem fsView2 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        Path expectedTrash = fsView2.makeQualified(new Path("/mnt/datavol1/very/deep/deep/trash/dir/.Trash"));
        Assertions.assertEquals((Object)fsView2.getTrashRoot(testPath), (Object)expectedTrash);
    }

    @Test
    public void testTrashRootsAllUsers() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", true);
        FileSystem fsView2 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        int beforeTrashRootNum = this.fsView.getTrashRoots(true).size();
        int beforeTrashRootNum2 = fsView2.getTrashRoots(true).size();
        Assertions.assertEquals((int)beforeTrashRootNum2, (int)beforeTrashRootNum);
        this.fsView.mkdirs(new Path("/data/.Trash/user1"));
        this.fsView.mkdirs(new Path("/data/.Trash/user2"));
        this.fsView.mkdirs(new Path("/user/.Trash/user3"));
        this.fsView.mkdirs(new Path("/user/.Trash/user4"));
        this.fsView.mkdirs(new Path("/user2/.Trash/user5"));
        int afterTrashRootsNum = this.fsView.getTrashRoots(true).size();
        int afterTrashRootsNum2 = fsView2.getTrashRoots(true).size();
        Assertions.assertEquals((int)afterTrashRootsNum, (int)beforeTrashRootNum);
        Assertions.assertEquals((int)afterTrashRootsNum2, (int)(beforeTrashRootNum2 + 5));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "Users/userA/.Trash/userA"));
        Configuration conf3 = new Configuration(conf2);
        ConfigUtil.addLink((Configuration)conf3, (String)"/Users/userA", (URI)new Path(this.targetTestRoot, "Users/userA").toUri());
        FileSystem fsView3 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf3);
        int trashRootsNum3 = fsView3.getTrashRoots(true).size();
        Assertions.assertEquals((int)trashRootsNum3, (int)(afterTrashRootsNum2 + 1));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "Users/.Trash/user1"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, "Users/.Trash/user2"));
        Configuration conf4 = new Configuration(conf2);
        ConfigUtil.addLink((Configuration)conf4, (String)"/Users", (URI)new Path(this.targetTestRoot, "Users").toUri());
        FileSystem fsView4 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf4);
        int trashRootsNum4 = fsView4.getTrashRoots(true).size();
        Assertions.assertEquals((int)trashRootsNum4, (int)(afterTrashRootsNum2 + 2));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, ".Trash/user10"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, ".Trash/user11"));
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, ".Trash/user12"));
        Configuration conf5 = new Configuration(conf2);
        ConfigUtil.addLinkFallback((Configuration)conf5, (URI)this.targetTestRoot.toUri());
        FileSystem fsView5 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf5);
        int trashRootsNum5 = fsView5.getTrashRoots(true).size();
        Assertions.assertEquals((int)trashRootsNum5, (int)(afterTrashRootsNum2 + 3));
    }

    @Test
    public void testTrashRootsCurrentUser() throws IOException {
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        Configuration conf2 = new Configuration(this.conf);
        conf2.setBoolean("fs.viewfs.trash.force-inside-mount-point", true);
        FileSystem fsView2 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        int beforeTrashRootNum = this.fsView.getTrashRoots(false).size();
        int beforeTrashRootNum2 = fsView2.getTrashRoots(false).size();
        Assertions.assertEquals((int)beforeTrashRootNum2, (int)beforeTrashRootNum);
        this.fsView.mkdirs(new Path("/data/.Trash/" + currentUser));
        this.fsView.mkdirs(new Path("/data/.Trash/user2"));
        this.fsView.mkdirs(new Path("/user/.Trash/" + currentUser));
        this.fsView.mkdirs(new Path("/user/.Trash/user4"));
        this.fsView.mkdirs(new Path("/user2/.Trash/user5"));
        int afterTrashRootsNum = this.fsView.getTrashRoots(false).size();
        int afterTrashRootsNum2 = fsView2.getTrashRoots(false).size();
        Assertions.assertEquals((int)afterTrashRootsNum, (int)beforeTrashRootNum);
        Assertions.assertEquals((int)afterTrashRootsNum2, (int)(beforeTrashRootNum2 + 2));
        Configuration conf3 = new Configuration(conf2);
        this.fsTarget.mkdirs(new Path(this.targetTestRoot, ".Trash/" + currentUser));
        ConfigUtil.addLinkFallback((Configuration)conf3, (URI)this.targetTestRoot.toUri());
        FileSystem fsView3 = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf3);
        int trashRootsNum3 = fsView3.getTrashRoots(false).size();
        Assertions.assertEquals((int)trashRootsNum3, (int)(afterTrashRootsNum2 + 1));
    }

    @Test
    public void testViewFileSystemUtil() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        FileSystem fileSystem = FileSystem.get((URI)FsConstants.LOCAL_FS_URI, (Configuration)newConf);
        Assertions.assertFalse((boolean)ViewFileSystemUtil.isViewFileSystem((FileSystem)fileSystem), (String)("Unexpected FileSystem: " + fileSystem));
        fileSystem = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)newConf);
        Assertions.assertTrue((boolean)ViewFileSystemUtil.isViewFileSystem((FileSystem)fileSystem), (String)("Unexpected FileSystem: " + fileSystem));
        Map mountPointFsStatusMap = ViewFileSystemUtil.getStatus((FileSystem)fileSystem, (Path)InodeTree.SlashPath);
        Assertions.assertEquals((int)mountPointFsStatusMap.size(), (int)this.getExpectedMountPoints());
        mountPointFsStatusMap = ViewFileSystemUtil.getStatus((FileSystem)fileSystem, (Path)new Path("/internalDir"));
        Assertions.assertEquals((int)mountPointFsStatusMap.size(), (int)this.getExpectedMountPoints());
        mountPointFsStatusMap = ViewFileSystemUtil.getStatus((FileSystem)fileSystem, (Path)new Path("/user"));
        Assertions.assertEquals((int)mountPointFsStatusMap.size(), (int)1);
        for (Map.Entry entry : mountPointFsStatusMap.entrySet()) {
            Assertions.assertEquals((Object)"/user", (Object)((ViewFileSystem.MountPoint)entry.getKey()).getMountedOnPath().toString());
        }
        mountPointFsStatusMap = ViewFileSystemUtil.getStatus((FileSystem)fileSystem, (Path)new Path("/user/cloud"));
        Assertions.assertEquals((int)mountPointFsStatusMap.size(), (int)1);
        for (Map.Entry entry : mountPointFsStatusMap.entrySet()) {
            Assertions.assertEquals((Object)"/user", (Object)((ViewFileSystem.MountPoint)entry.getKey()).getMountedOnPath().toString());
        }
        mountPointFsStatusMap = ViewFileSystemUtil.getStatus((FileSystem)fileSystem, (Path)new Path("/internalDir/internalDir2"));
        Assertions.assertEquals((int)mountPointFsStatusMap.size(), (int)this.getExpectedMountPoints());
        mountPointFsStatusMap = ViewFileSystemUtil.getStatus((FileSystem)fileSystem, (Path)new Path("viewfs:/user/"));
        Assertions.assertEquals((int)mountPointFsStatusMap.size(), (int)1);
        for (Map.Entry entry : mountPointFsStatusMap.entrySet()) {
            Assertions.assertEquals((Object)"/user", (Object)((ViewFileSystem.MountPoint)entry.getKey()).getMountedOnPath().toString());
        }
        FileSystem fsCopy = fileSystem;
        Assertions.assertThrows(NotInMountpointException.class, () -> ViewFileSystemUtil.getStatus((FileSystem)fsCopy, (Path)new Path("/non-existing")));
    }

    @Test
    public void testCheckOwnerWithFileStatus() throws IOException, InterruptedException {
        final UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user@HADOOP.COM", (String[])new String[]{"hadoop"});
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                String doAsUserName = ugi.getUserName();
                Assertions.assertEquals((Object)"user@HADOOP.COM", (Object)doAsUserName);
                FileSystem vfs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)ViewFileSystemBaseTest.this.conf);
                FileStatus stat = vfs.getFileStatus(new Path("/internalDir"));
                Assertions.assertEquals((Object)stat.getOwner(), (Object)userUgi.getShortUserName());
                return null;
            }
        });
    }

    @Test
    public void testUsed() throws IOException {
        try {
            this.fsView.getUsed();
            Assertions.fail((String)"ViewFileSystem getUsed() should fail for slash root path when the slash root mount point is not configured.");
        }
        catch (NotInMountpointException notInMountpointException) {
            // empty catch block
        }
        long usedSpaceByPathViaViewFs = this.fsView.getUsed(new Path("/user"));
        long usedSpaceByPathViaTargetFs = this.fsTarget.getUsed(new Path(this.targetTestRoot, "user"));
        Assertions.assertEquals((long)usedSpaceByPathViaTargetFs, (long)usedSpaceByPathViaViewFs, (String)"Space used not matching between ViewFileSystem and the mounted FileSystem!");
        Path mountDataRootPath = new Path("/data");
        String fsTargetFileName = "debug.log";
        Path fsTargetFilePath = new Path(this.targetTestRoot, "data/debug.log");
        Path mountDataFilePath = new Path(mountDataRootPath, fsTargetFileName);
        FileSystemTestHelper.createFile(this.fsTarget, fsTargetFilePath);
        usedSpaceByPathViaViewFs = this.fsView.getUsed(mountDataFilePath);
        usedSpaceByPathViaTargetFs = this.fsTarget.getUsed(fsTargetFilePath);
        Assertions.assertEquals((long)usedSpaceByPathViaTargetFs, (long)usedSpaceByPathViaViewFs, (String)"Space used not matching between ViewFileSystem and the mounted FileSystem!");
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testLinkTarget() throws Exception {
        if (!this.fsTarget.supportsSymlinks()) ** GOTO lbl-1000
        v0 = this;
        if (v0.fsTarget.areSymlinksEnabled()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assumptions.assumeTrue((boolean)v1);
        targetFileName = "debug.log";
        linkFileName = "debug.link";
        targetFile = new Path(this.targetTestRoot, "debug.log");
        symLink = new Path(this.targetTestRoot, "debug.link");
        FileSystemTestHelper.createFile(this.fsTarget, targetFile);
        this.fsTarget.createSymlink(targetFile, symLink, false);
        mountTargetRootPath = new Path("/targetRoot");
        mountTargetSymLinkPath = new Path(mountTargetRootPath, "debug.link");
        expectedMountLinkTarget = this.fsTarget.makeQualified(new Path(this.targetTestRoot, "debug.log"));
        actualMountLinkTarget = this.fsView.getLinkTarget(mountTargetSymLinkPath);
        Assertions.assertEquals((Object)expectedMountLinkTarget, (Object)actualMountLinkTarget, (String)"Resolved link target path not matching!");
        relativeFileName = "dir2/../debug.log";
        link2FileName = "dir2/rel.link";
        relTargetFile = new Path(this.targetTestRoot, "dir2/../debug.log");
        relativeSymLink = new Path(this.targetTestRoot, "dir2/rel.link");
        this.fsTarget.createSymlink(relTargetFile, relativeSymLink, true);
        mountTargetRelativeSymLinkPath = new Path(mountTargetRootPath, "dir2/rel.link");
        expectedMountRelLinkTarget = this.fsTarget.makeQualified(new Path(this.targetTestRoot, "dir2/../debug.log"));
        actualMountRelLinkTarget = this.fsView.getLinkTarget(mountTargetRelativeSymLinkPath);
        Assertions.assertEquals((Object)expectedMountRelLinkTarget, (Object)actualMountRelLinkTarget, (String)"Resolved relative link target path not matching!");
        try {
            this.fsView.getLinkTarget(new Path("/linkToAFile"));
            Assertions.fail((String)"Resolving link target for a ViewFs mount link should fail!");
        }
        catch (Exception e) {
            ViewFileSystemBaseTest.LOG.info("Expected exception: " + e);
            GenericTestUtils.assertExceptionContains("not a symbolic link", e);
        }
        try {
            this.fsView.getLinkTarget(this.fsView.makeQualified(new Path(mountTargetRootPath, "debug.log")));
            Assertions.fail((String)"Resolving link target for a non sym link should fail!");
        }
        catch (Exception e) {
            ViewFileSystemBaseTest.LOG.info("Expected exception: " + e);
            GenericTestUtils.assertExceptionContains("not a symbolic link", e);
        }
        try {
            this.fsView.getLinkTarget(new Path("/targetRoot/non-existing-file"));
            Assertions.fail((String)"Resolving link target for a non existing link should fail!");
        }
        catch (Exception e) {
            ViewFileSystemBaseTest.LOG.info("Expected exception: " + e);
            GenericTestUtils.assertExceptionContains("File does not exist:", e);
        }
    }

    @Test
    public void testViewFileSystemInnerCache() throws Exception {
        ViewFileSystem.InnerCache cache = new ViewFileSystem.InnerCache(new FsGetter());
        FileSystem fs = cache.get(this.fsTarget.getUri(), this.conf);
        Assertions.assertSame((Object)cache.get(this.fsTarget.getUri(), this.conf), (Object)fs);
        Assertions.assertNotSame((Object)FileSystem.get((URI)this.fsTarget.getUri(), (Configuration)this.conf), (Object)fs);
        cache.closeAll();
        try {
            fs.exists(new Path("/"));
            if (!(fs instanceof LocalFileSystem)) {
                Assertions.fail((String)"Expect Filesystem closed exception");
            }
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Filesystem closed", e);
        }
    }

    @Test
    public void testCloseChildrenFileSystem() throws Exception {
        String clusterName = "cluster" + new Random().nextInt();
        Configuration config = new Configuration(this.conf);
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        config.setBoolean("fs.viewfs.impl.disable.cache", false);
        URI uri = new URI("viewfs://" + clusterName + "/");
        ViewFileSystem viewFs = (ViewFileSystem)FileSystem.get((URI)uri, (Configuration)config);
        Assertions.assertTrue((viewFs.getChildFileSystems().length > 0 ? 1 : 0) != 0, (String)"viewfs should have at least one child fs.");
        Assertions.assertSame((Object)FileSystem.get((URI)uri, (Configuration)config), (Object)viewFs);
        FileSystem child = viewFs.getChildFileSystems()[0];
        Assertions.assertNotSame((Object)FileSystem.get((URI)child.getUri(), (Configuration)config), (Object)child);
        viewFs.close();
        for (FileSystem childfs : viewFs.getChildFileSystems()) {
            try {
                childfs.exists(new Path("/"));
                if (childfs instanceof LocalFileSystem) continue;
                Assertions.fail((String)"Expect Filesystem closed exception");
            }
            catch (IOException e) {
                GenericTestUtils.assertExceptionContains("Filesystem closed", e);
            }
        }
    }

    @Test
    public void testChildrenFileSystemLeak() throws Exception {
        String clusterName = "cluster" + new Random().nextInt();
        Configuration config = new Configuration(this.conf);
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        int cacheSize = TestFileUtil.getCacheSize();
        ViewFileSystem viewFs = (ViewFileSystem)FileSystem.get((URI)new URI("viewfs://" + clusterName + "/"), (Configuration)config);
        viewFs.resolvePath(new Path(String.format("viewfs://%s/%s", clusterName, "/user")));
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)(cacheSize + 1));
        viewFs.close();
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)cacheSize);
    }

    @Test
    public void testDeleteOnExit() throws Exception {
        String clusterName = "cluster" + new Random().nextInt();
        Configuration config = new Configuration(this.conf);
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        Path testDir = new Path("/user/testDeleteOnExit");
        Path realTestPath = new Path(this.targetTestRoot, "user/testDeleteOnExit");
        ViewFileSystem viewFs = (ViewFileSystem)FileSystem.get((URI)new URI("viewfs://" + clusterName + "/"), (Configuration)config);
        viewFs.mkdirs(testDir);
        Assertions.assertTrue((boolean)viewFs.exists(testDir));
        Assertions.assertTrue((boolean)this.fsTarget.exists(realTestPath));
        viewFs.deleteOnExit(testDir);
        viewFs.close();
        Assertions.assertFalse((boolean)this.fsTarget.exists(realTestPath));
    }

    @Test
    public void testGetContentSummary() throws IOException {
        ContentSummary summaryBefore = this.fsView.getContentSummary(new Path("/internalDir"));
        String expected = "GET CONTENT SUMMARY";
        Path filePath = new Path("/internalDir/internalDir2/linkToDir3", "foo");
        try (FSDataOutputStream outputStream = this.fsView.create(filePath);){
            outputStream.write(expected.getBytes());
        }
        Path newDirPath = new Path("/internalDir/linkToDir2", "bar");
        this.fsView.mkdirs(newDirPath);
        ContentSummary summaryAfter = this.fsView.getContentSummary(new Path("/internalDir"));
        Assertions.assertEquals((long)(summaryBefore.getFileCount() + 1L), (long)summaryAfter.getFileCount(), (String)"The file count didn't match");
        Assertions.assertEquals((long)(summaryBefore.getLength() + (long)expected.length()), (long)summaryAfter.getLength(), (String)"The size didn't match");
        Assertions.assertEquals((long)(summaryBefore.getDirectoryCount() + 1L), (long)summaryAfter.getDirectoryCount(), (String)"The directory count didn't match");
    }

    @Test
    public void testGetContentSummaryWithFileInLocalFS() throws Exception {
        ContentSummary summaryBefore = this.fsView.getContentSummary(new Path("/internalDir"));
        String expected = "GET CONTENT SUMMARY";
        File localFile = this.temporaryFolder.toPath().resolve("localFile").toFile();
        try (FileOutputStream fos = new FileOutputStream(localFile);){
            fos.write(expected.getBytes());
        }
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/internalDir2/linkToLocalFile", (URI)localFile.toURI());
        try (FileSystem fs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);){
            ContentSummary summaryAfter = fs.getContentSummary(new Path("/internalDir"));
            Assertions.assertEquals((long)summaryAfter.getFileCount(), (long)(summaryBefore.getFileCount() + 1L), (String)"The file count didn't match");
            Assertions.assertEquals((long)summaryAfter.getLength(), (long)(summaryBefore.getLength() + (long)expected.length()), (String)"The directory count didn't match");
        }
    }

    @Test
    public void testTargetFileSystemLazyInitialization() throws Exception {
        String clusterName = "cluster" + new Random().nextInt();
        Configuration config = new Configuration(this.conf);
        config.setBoolean("fs.viewfs.enable.inner.cache", false);
        config.setClass("fs.mockfs.impl", TestChRootedFileSystem.MockFileSystem.class, FileSystem.class);
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/user", (URI)URI.create("mockfs://mockauth1/mockpath"));
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/mock", (URI)URI.create("mockfs://mockauth/mockpath"));
        int cacheSize = TestFileUtil.getCacheSize();
        ViewFileSystem viewFs = (ViewFileSystem)FileSystem.get((URI)new URI("viewfs://" + clusterName + "/"), (Configuration)config);
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)cacheSize);
        viewFs.resolvePath(new Path(String.format("viewfs://%s/%s", clusterName, "/user")));
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)(cacheSize + 1));
        viewFs.resolvePath(new Path(String.format("viewfs://%s/%s", clusterName, "/mock")));
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)(cacheSize + 2));
        viewFs.close();
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)(cacheSize + 2));
    }

    @Test
    public void testTargetFileSystemLazyInitializationForChecksumMethods() throws Exception {
        String clusterName = "cluster" + new Random().nextInt();
        Configuration config = new Configuration(this.conf);
        config.setBoolean("fs.viewfs.enable.inner.cache", false);
        config.setClass("fs.othermockfs.impl", TestChRootedFileSystem.MockFileSystem.class, FileSystem.class);
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/user", (URI)URI.create("othermockfs://mockauth1/mockpath"));
        ConfigUtil.addLink((Configuration)config, (String)clusterName, (String)"/mock", (URI)URI.create("othermockfs://mockauth/mockpath"));
        int cacheSize = TestFileUtil.getCacheSize();
        ViewFileSystem viewFs = (ViewFileSystem)FileSystem.get((URI)new URI("viewfs://" + clusterName + "/"), (Configuration)config);
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)cacheSize);
        viewFs.setVerifyChecksum(true);
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)cacheSize);
        viewFs.getFileChecksum(new Path(String.format("viewfs://%s/%s", clusterName, "/user")));
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)(cacheSize + 1));
        viewFs.close();
        Assertions.assertEquals((int)TestFileUtil.getCacheSize(), (int)(cacheSize + 1));
    }

    @Test
    public void testInvalidMountPoints() throws Exception {
        String clusterName = "cluster" + new Random().nextInt();
        Configuration config = new Configuration(this.conf);
        config.set(ConfigUtil.getConfigViewFsPrefix((String)clusterName) + ".link./invalidPath", "othermockfs:|mockauth/mockpath");
        try {
            FileSystem viewFs = FileSystem.get((URI)new URI("viewfs://" + clusterName + "/"), (Configuration)config);
            Assertions.fail((String)"FileSystem should not initialize. Should fail with IOException");
        }
        catch (IOException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("URISyntax exception"), (String)"Should get URISyntax Exception");
        }
    }

    static class DeepTrashRootMockFS
    extends FileSystemTestHelper.MockFileSystem {
        public static final Path TRASH = new Path("/vol/very/deep/deep/trash/dir/.Trash");

        DeepTrashRootMockFS() {
        }

        public Path getTrashRoot(Path path) {
            return TRASH;
        }
    }
}

